/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.ASN1;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASN1.ASN1Assignment;
import org.eclipse.titan.designer.AST.ASN1.Ass_pard;
import org.eclipse.titan.designer.AST.ASN1.ObjectClass;
import org.eclipse.titan.designer.AST.ASN1.ObjectSet;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class ObjectSet_Assignment
extends ASN1Assignment {
    public static final String PARAMETERISEDOBJECTSET = "`{0}'' is a parameterized objectset assignment";
    private final ObjectClass objectClass;
    private final ObjectSet objectSet;

    public ObjectSet_Assignment(Identifier id, Ass_pard assPard, ObjectClass objectClass, ObjectSet objectSet) {
        super(id, assPard);
        this.objectClass = objectClass;
        this.objectSet = objectSet;
        if (null != objectClass) {
            objectClass.setFullNameParent(this);
        }
        if (null != objectSet) {
            objectSet.setFullNameParent(this);
        }
    }

    @Override
    public Assignment.Assignment_type getAssignmentType() {
        return Assignment.Assignment_type.A_OS;
    }

    @Override
    protected ASN1Assignment internalNewInstance(Identifier identifier) {
        return new ObjectSet_Assignment(identifier, null, this.objectClass.newInstance(), this.objectSet.newInstance());
    }

    @Override
    public void setRightScope(Scope rightScope) {
        if (null != this.objectSet) {
            this.objectSet.setMyScope(rightScope);
        }
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (null != this.objectClass) {
            this.objectClass.setMyScope(scope);
        }
        if (null != this.objectSet) {
            this.objectSet.setMyScope(scope);
        }
    }

    public ObjectSet getObjectSet(CompilationTimeStamp timestamp) {
        if (null != this.assPard) {
            this.location.reportSemanticError(MessageFormat.format(PARAMETERISEDOBJECTSET, this.getFullName()));
            return null;
        }
        this.check(timestamp);
        return this.objectSet;
    }

    @Override
    public ObjectSet getSetting(CompilationTimeStamp timestamp) {
        return this.getObjectSet(timestamp);
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        this.check(timestamp, null);
    }

    @Override
    public void check(CompilationTimeStamp timestamp, IReferenceChain refChain) {
        if (null != this.lastTimeChecked && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        if (null != this.assPard) {
            this.assPard.check(timestamp);
            return;
        }
        if (null != this.objectClass) {
            this.objectClass.check(timestamp);
        }
        if (null != this.objectSet) {
            this.objectSet.setMyGovernor(this.objectClass);
            this.objectSet.check(timestamp);
        }
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector, int i) {
        List<ISubReference> subrefs = declarationCollector.getReference().getSubreferences();
        if (subrefs.size() > i && this.identifier.getName().equals(subrefs.get(i).getId().getName())) {
            if (subrefs.size() > i + 1 && null != this.objectSet) {
                this.objectSet.addDeclaration(declarationCollector, i + 1);
            } else if (subrefs.size() == i + 1 && ISubReference.Subreference_type.fieldSubReference.equals((Object)subrefs.get(i).getReferenceType())) {
                declarationCollector.addDeclaration(this);
            }
        }
    }

    @Override
    public void addProposal(ProposalCollector propCollector, int i) {
        List<ISubReference> subrefs = propCollector.getReference().getSubreferences();
        if (subrefs.size() <= i) {
            return;
        }
        if (subrefs.size() == i + 1 && this.identifier.getName().toLowerCase().startsWith(subrefs.get(i).getId().getName().toLowerCase())) {
            propCollector.addProposal(this.identifier, " - ObjectSet assignment", ImageCache.getImage(this.getOutlineIcon()), "ObjectSet assignment");
        } else if (subrefs.size() > i + 1 && null != this.objectSet && this.identifier.getName().equals(subrefs.get(i).getId().getName())) {
            this.objectSet.addProposal(propCollector, i + 1);
        }
    }

    @Override
    public String getAssignmentName() {
        return "information object set";
    }

    @Override
    public String getOutlineIcon() {
        return "titan.gif";
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        if (this.objectClass != null && !this.objectClass.accept(v)) {
            return false;
        }
        return this.objectSet == null || this.objectSet.accept(v);
    }
}

