/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.selection.SelectionUtils;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;

public class PushMenu
extends CompoundContributionItem
implements IWorkbenchContribution {
    private IServiceLocator serviceLocator;
    private IHandlerService handlerService;

    public PushMenu() {
        this(null);
    }

    public PushMenu(String id) {
        super(id);
    }

    public boolean isDynamic() {
        return true;
    }

    public void initialize(IServiceLocator locator) {
        this.serviceLocator = locator;
        this.handlerService = CommonUtils.getService(locator, IHandlerService.class);
    }

    protected IContributionItem[] getContributionItems() {
        Repository repository;
        ArrayList<CommandContributionItem> res = new ArrayList<CommandContributionItem>();
        if (this.handlerService != null && (repository = SelectionUtils.getRepository(this.handlerService.getCurrentState())) != null) {
            try {
                String ref = repository.getFullBranch();
                String menuLabel = UIText.PushMenu_PushHEAD;
                if (ref != null && ref.startsWith("refs/heads/")) {
                    menuLabel = NLS.bind((String)UIText.PushMenu_PushBranch, (Object)Repository.shortenRefName((String)ref));
                }
                CommandContributionItemParameter params = new CommandContributionItemParameter(this.serviceLocator, ((Object)((Object)this)).getClass().getName(), "org.eclipse.egit.ui.team.PushBranch", 8);
                params.label = menuLabel;
                CommandContributionItem item = new CommandContributionItem(params);
                res.add(item);
            }
            catch (IOException ex) {
                Activator.handleError(ex.getLocalizedMessage(), ex, false);
            }
        }
        return res.toArray(new IContributionItem[res.size()]);
    }
}

