/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.glyphs;

import fr.inria.zvtm.engine.Camera;
import fr.inria.zvtm.engine.VirtualSpaceManager;
import fr.inria.zvtm.glyphs.ClosedShape;
import fr.inria.zvtm.glyphs.RectangularShape;
import fr.inria.zvtm.glyphs.projection.RProjectedCoordsP;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class VRectangle<T>
extends ClosedShape
implements RectangularShape {
    public double vw;
    public double vh;
    public double ar;
    public RProjectedCoordsP[] pc;

    public VRectangle() {
        this(0.0, 0.0, 0, 10.0, 10.0, Color.WHITE, Color.BLACK, 1.0f);
    }

    public VRectangle(double x, double y, int z, double w, double h, Color c) {
        this(x, y, z, w, h, c, Color.BLACK, 1.0f);
    }

    public VRectangle(double x, double y, int z, double w, double h, Color c, Color bc) {
        this(x, y, z, w, h, c, bc, 1.0f);
    }

    public VRectangle(double x, double y, int z, double w, double h, Color c, Color bc, float alpha) {
        this.vx = x;
        this.vy = y;
        this.vz = z;
        this.vw = w;
        this.vh = h;
        this.computeSize();
        this.ar = this.vw == 0.0 && this.vh == 0.0 ? 1.0 : this.vw / this.vh;
        this.orient = 0.0;
        this.setColor(c);
        this.setBorderColor(bc);
        this.setTranslucencyValue(alpha);
    }

    @Override
    public void initCams(int nbCam) {
        this.pc = new RProjectedCoordsP[nbCam];
        for (int i = 0; i < nbCam; ++i) {
            this.pc[i] = new RProjectedCoordsP();
        }
    }

    @Override
    public void addCamera(int verifIndex) {
        if (this.pc != null) {
            if (verifIndex == this.pc.length) {
                RProjectedCoordsP[] ta = this.pc;
                this.pc = new RProjectedCoordsP[ta.length + 1];
                for (int i = 0; i < ta.length; ++i) {
                    this.pc[i] = ta[i];
                }
                this.pc[this.pc.length - 1] = new RProjectedCoordsP();
            } else {
                System.err.println("VRectangle:Error while adding camera " + verifIndex);
            }
        } else if (verifIndex == 0) {
            this.pc = new RProjectedCoordsP[1];
            this.pc[0] = new RProjectedCoordsP();
        } else {
            System.err.println("VRectangle:Error while adding camera " + verifIndex);
        }
    }

    @Override
    public void removeCamera(int index) {
        this.pc[index] = null;
    }

    @Override
    public void resetMouseIn() {
        for (int i = 0; i < this.pc.length; ++i) {
            this.resetMouseIn(i);
        }
    }

    @Override
    public void resetMouseIn(int i) {
        if (this.pc[i] != null) {
            this.pc[i].prevMouseIn = false;
        }
        this.borderColor = this.bColor;
    }

    @Override
    public double getOrient() {
        return this.orient;
    }

    @Override
    public void orientTo(double angle) {
    }

    @Override
    public double getSize() {
        return this.size;
    }

    @Override
    public double getWidth() {
        return this.vw;
    }

    @Override
    public double getHeight() {
        return this.vh;
    }

    void computeSize() {
        this.size = Math.sqrt(this.vw * this.vw + this.vh * this.vh);
    }

    @Override
    public void sizeTo(double s) {
        this.size = s;
        this.vw = this.size * this.ar / Math.sqrt(this.ar * this.ar + 1.0);
        this.vh = this.size / Math.sqrt(this.ar * this.ar + 1.0);
        VirtualSpaceManager.INSTANCE.repaint();
    }

    @Override
    public void setWidth(double w) {
        this.vw = w;
        this.ar = this.vw / this.vh;
        this.computeSize();
        VirtualSpaceManager.INSTANCE.repaint();
    }

    @Override
    public void setHeight(double h) {
        this.vh = h;
        this.ar = this.vw / this.vh;
        this.computeSize();
        VirtualSpaceManager.INSTANCE.repaint();
    }

    @Override
    public void reSize(double factor) {
        this.size *= factor;
        this.vw = this.size * this.ar / Math.sqrt(this.ar * this.ar + 1.0);
        this.vh = this.size / Math.sqrt(this.ar * this.ar + 1.0);
        VirtualSpaceManager.INSTANCE.repaint();
    }

    @Override
    public boolean fillsView(double w, double h, int camIndex) {
        return this.alphaC == null && w <= (double)(this.pc[camIndex].cx + this.pc[camIndex].cw) && 0 >= this.pc[camIndex].cx - this.pc[camIndex].cw && h <= (double)(this.pc[camIndex].cy + this.pc[camIndex].ch) && 0 >= this.pc[camIndex].cy - this.pc[camIndex].ch;
    }

    @Override
    public boolean coordInside(int jpx, int jpy, int camIndex, double cvx, double cvy) {
        return jpx >= this.pc[camIndex].cx - this.pc[camIndex].cw && jpx <= this.pc[camIndex].cx + this.pc[camIndex].cw && jpy >= this.pc[camIndex].cy - this.pc[camIndex].ch && jpy <= this.pc[camIndex].cy + this.pc[camIndex].ch;
    }

    @Override
    public boolean visibleInRegion(double wb, double nb, double eb, double sb, int i) {
        if (this.vx >= wb && this.vx <= eb && this.vy >= sb && this.vy <= nb) {
            return true;
        }
        return this.vx - this.vw / 2.0 <= eb && this.vx + this.vw / 2.0 >= wb && this.vy - this.vh / 2.0 <= nb && this.vy + this.vh / 2.0 >= sb;
    }

    @Override
    public boolean visibleInDisc(double dvx, double dvy, double dvr, Shape dvs, int camIndex, int jpx, int jpy, int dpr) {
        return dvs.intersects(this.vx - this.vw / 2.0, this.vy - this.vh / 2.0, this.vw, this.vh);
    }

    @Override
    public double[] getBounds() {
        double[] res = new double[]{this.vx - this.vw / 2.0, this.vy + this.vh / 2.0, this.vx + this.vw / 2.0, this.vy - this.vh / 2.0};
        return res;
    }

    @Override
    public short mouseInOut(int jpx, int jpy, int camIndex, double cvx, double cvy) {
        if (this.coordInside(jpx, jpy, camIndex, cvx, cvy)) {
            if (!this.pc[camIndex].prevMouseIn) {
                this.pc[camIndex].prevMouseIn = true;
                return 1;
            }
            return 0;
        }
        if (this.pc[camIndex].prevMouseIn) {
            this.pc[camIndex].prevMouseIn = false;
            return -1;
        }
        return 0;
    }

    @Override
    public void project(Camera c, Dimension d) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude);
        this.pc[i].cx = (int)Math.round((double)(d.width / 2) + (this.vx - c.vx) * this.coef);
        this.pc[i].cy = (int)Math.round((double)(d.height / 2) - (this.vy - c.vy) * this.coef);
        this.pc[i].cw = (int)Math.round(Math.ceil(this.vw / 2.0 * this.coef));
        this.pc[i].ch = (int)Math.round(Math.ceil(this.vh / 2.0 * this.coef));
    }

    @Override
    public void projectForLens(Camera c, int lensWidth, int lensHeight, float lensMag, double lensx, double lensy) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude) * (double)lensMag;
        this.pc[i].lcx = (int)Math.round((double)(lensWidth / 2) + (this.vx - lensx) * this.coef);
        this.pc[i].lcy = (int)Math.round((double)(lensHeight / 2) - (this.vy - lensy) * this.coef);
        this.pc[i].lcw = (int)Math.round(Math.ceil(this.vw / 2.0 * this.coef));
        this.pc[i].lch = (int)Math.round(Math.ceil(this.vh / 2.0 * this.coef));
    }

    @Override
    public void draw(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.alphaC != null && this.alphaC.getAlpha() == 0.0f) {
            return;
        }
        if (this.pc[i].cw == 1 && this.pc[i].ch == 1) {
            g.setColor(this.color);
            if (this.alphaC != null) {
                g.setComposite(this.alphaC);
                g.fillRect(dx + this.pc[i].cx, dy + this.pc[i].cy, 1, 1);
                g.setComposite(acO);
            } else {
                g.fillRect(dx + this.pc[i].cx, dy + this.pc[i].cy, 1, 1);
            }
        } else if (this.alphaC != null) {
            g.setComposite(this.alphaC);
            if (this.filled) {
                g.setColor(this.color);
                g.fillRect(dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch, 2 * this.pc[i].cw, 2 * this.pc[i].ch);
            }
            if (this.paintBorder) {
                g.setColor(this.borderColor);
                if (this.stroke != null) {
                    if (dx + this.pc[i].cx - this.pc[i].cw > 0 || dy + this.pc[i].cy - this.pc[i].ch > 0 || dx + this.pc[i].cx - this.pc[i].cw + 2 * this.pc[i].cw - 1 < vW || dy + this.pc[i].cy - this.pc[i].ch + 2 * this.pc[i].ch - 1 < vH) {
                        g.setStroke(this.stroke);
                        g.drawRect(dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch, 2 * this.pc[i].cw, 2 * this.pc[i].ch);
                        g.setStroke(stdS);
                    }
                } else {
                    g.drawRect(dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch, 2 * this.pc[i].cw, 2 * this.pc[i].ch);
                }
            }
            g.setComposite(acO);
        } else {
            if (this.filled) {
                g.setColor(this.color);
                g.fillRect(dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch, 2 * this.pc[i].cw, 2 * this.pc[i].ch);
            }
            if (this.paintBorder) {
                g.setColor(this.borderColor);
                if (this.stroke != null) {
                    if (dx + this.pc[i].cx - this.pc[i].cw > 0 || dy + this.pc[i].cy - this.pc[i].ch > 0 || dx + this.pc[i].cx - this.pc[i].cw + 2 * this.pc[i].cw - 1 < vW || dy + this.pc[i].cy - this.pc[i].ch + 2 * this.pc[i].ch - 1 < vH) {
                        g.setStroke(this.stroke);
                        g.drawRect(dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch, 2 * this.pc[i].cw, 2 * this.pc[i].ch);
                        g.setStroke(stdS);
                    }
                } else {
                    g.drawRect(dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch, 2 * this.pc[i].cw, 2 * this.pc[i].ch);
                }
            }
        }
    }

    @Override
    public void drawForLens(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.alphaC != null && this.alphaC.getAlpha() == 0.0f) {
            return;
        }
        if (this.pc[i].lcw == 1 && this.pc[i].lch == 1) {
            g.setColor(this.color);
            if (this.alphaC != null) {
                g.setComposite(this.alphaC);
                g.fillRect(dx + this.pc[i].lcx, dy + this.pc[i].lcy, 1, 1);
                g.setComposite(acO);
            } else {
                g.fillRect(dx + this.pc[i].lcx, dy + this.pc[i].lcy, 1, 1);
            }
        } else if (this.alphaC != null) {
            g.setComposite(this.alphaC);
            if (this.filled) {
                g.setColor(this.color);
                g.fillRect(dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].lcy - this.pc[i].lch, 2 * this.pc[i].lcw, 2 * this.pc[i].lch);
            }
            if (this.paintBorder) {
                g.setColor(this.borderColor);
                if (this.stroke != null) {
                    if (dx + this.pc[i].lcx - this.pc[i].lcw > 0 || dy + this.pc[i].lcy - this.pc[i].lch > 0 || dx + this.pc[i].lcx - this.pc[i].lcw + 2 * this.pc[i].lcw - 1 < vW || dy + this.pc[i].lcy - this.pc[i].lch + 2 * this.pc[i].lch - 1 < vH) {
                        g.setStroke(this.stroke);
                        g.drawRect(dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].lcy - this.pc[i].lch, 2 * this.pc[i].lcw, 2 * this.pc[i].lch);
                        g.setStroke(stdS);
                    }
                } else {
                    g.drawRect(dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].lcy - this.pc[i].lch, 2 * this.pc[i].lcw, 2 * this.pc[i].lch);
                }
            }
            g.setComposite(acO);
        } else {
            if (this.filled) {
                g.setColor(this.color);
                g.fillRect(dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].lcy - this.pc[i].lch, 2 * this.pc[i].lcw, 2 * this.pc[i].lch);
            }
            if (this.paintBorder) {
                g.setColor(this.borderColor);
                if (this.stroke != null) {
                    if (dx + this.pc[i].lcx - this.pc[i].lcw > 0 || dy + this.pc[i].lcy - this.pc[i].lch > 0 || dx + this.pc[i].lcx - this.pc[i].lcw + 2 * this.pc[i].lcw - 1 < vW || dy + this.pc[i].lcy - this.pc[i].lch + 2 * this.pc[i].lch - 1 < vH) {
                        g.setStroke(this.stroke);
                        g.drawRect(dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].lcy - this.pc[i].lch, 2 * this.pc[i].lcw, 2 * this.pc[i].lch);
                        g.setStroke(stdS);
                    }
                } else {
                    g.drawRect(dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].lcy - this.pc[i].lch, 2 * this.pc[i].lcw, 2 * this.pc[i].lch);
                }
            }
        }
    }

    @Override
    public Shape getJava2DShape() {
        return new Rectangle2D.Double(this.vx - this.vw / 2.0, this.vy - this.vh / 2.0, this.vw, this.vh);
    }

    @Override
    public Object clone() {
        VRectangle<T> res = new VRectangle<T>(this.vx, this.vy, this.vz, this.vw, this.vh, this.color, this.borderColor);
        res.cursorInsideColor = this.cursorInsideColor;
        return res;
    }
}

