/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.execution.core.workflow;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.efm.execution.core.IWorkflowConfigurationConstants;
import org.eclipse.efm.execution.core.util.PrettyPrintWriter;
import org.eclipse.efm.execution.core.workflow.SupervisorWorkerCustomImpl;
import org.eclipse.efm.execution.core.workflow.Worker;
import org.eclipse.efm.execution.core.workflow.Workflow;
import org.eclipse.efm.execution.core.workflow.common.CommonFactory;
import org.eclipse.efm.execution.core.workflow.common.ConsoleLogFormatCustomImpl;
import org.eclipse.efm.execution.core.workflow.common.DeveloperTuningOptionCustomImpl;
import org.eclipse.efm.execution.core.workflow.common.ManifestCustomImpl;
import org.eclipse.efm.execution.core.workflow.common.Project;
import org.eclipse.efm.execution.core.workflow.common.RedundancyDetection;
import org.eclipse.efm.execution.core.workflow.coverage.BehaviorCoverageWorkerCustomImpl;
import org.eclipse.efm.execution.core.workflow.coverage.TransitionCoverageWorkerCustomImpl;
import org.eclipse.efm.execution.core.workflow.impl.DirectorImpl;
import org.eclipse.efm.execution.core.workflow.impl.SerializerImpl;
import org.eclipse.efm.execution.core.workflow.impl.WorkerImpl;
import org.eclipse.efm.execution.core.workflow.serializer.BasicTraceSerializerWorkerCustomImpl;
import org.eclipse.efm.execution.core.workflow.serializer.ModelGraphvizSerializerWorkerCustomImpl;
import org.eclipse.efm.execution.core.workflow.serializer.SymbexGraphvizSerializerWorkerCustomImpl;
import org.eclipse.efm.execution.core.workflow.serializer.TTCNTraceSerializerWorkerCustomImpl;
import org.eclipse.efm.execution.core.workflow.test.OfflineTestWorkerCustomImpl;

public class DirectorCustomImpl
extends DirectorImpl
implements IWorkflowConfigurationConstants {
    protected DirectorCustomImpl(Workflow workflow) {
        this.setWorkflow(workflow);
    }

    protected DirectorCustomImpl(Workflow workflow, String name) {
        this.setWorkflow(workflow);
        this.setName(name);
    }

    public static DirectorCustomImpl create(Workflow workflow, ILaunchConfiguration configuration, boolean hasSecond) {
        DirectorCustomImpl director = new DirectorCustomImpl(workflow);
        director.setManifest(ManifestCustomImpl.create(true, true));
        director.configureProject(configuration);
        director.configureMainWorker(configuration);
        director.configureSerializerWorker(configuration);
        if (!hasSecond) {
            director.configureSecondSerializerWorker(configuration, hasSecond);
        }
        director.configureDebugWorker(configuration);
        return director;
    }

    public static String getModelPath(ILaunchConfiguration configuration) {
        String modelPath;
        try {
            modelPath = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_SPECIFICATION_MODEL_FILE_LOCATION", "");
        }
        catch (CoreException e) {
            e.printStackTrace();
            modelPath = null;
        }
        return modelPath;
    }

    public static String getModelFilename(ILaunchConfiguration configuration) {
        String modelPath = DirectorCustomImpl.getModelPath(configuration);
        int pos = modelPath.lastIndexOf(47);
        if (pos > 0) {
            modelPath = modelPath.substring(pos + 1);
        }
        return modelPath;
    }

    public static String getModelBasename(ILaunchConfiguration configuration) {
        String modelFilename = DirectorCustomImpl.getModelFilename(configuration);
        int pos = modelFilename.lastIndexOf(46);
        if (pos > 0) {
            modelFilename = modelFilename.substring(0, pos);
        }
        return modelFilename;
    }

    public boolean configureProject(ILaunchConfiguration configuration) {
        String modelPath = DirectorCustomImpl.getModelPath(configuration);
        if (modelPath != null && !modelPath.isEmpty()) {
            Project project = CommonFactory.eINSTANCE.createProject();
            int pos = modelPath.lastIndexOf(47);
            if (pos > 0) {
                project.setSource(modelPath.substring(0, pos));
                modelPath = modelPath.substring(pos + 1);
            }
            project.setModel(modelPath);
            this.setProject(project);
            return true;
        }
        return false;
    }

    public boolean configureMainWorker(ILaunchConfiguration configuration) {
        String modelAnalysisProfile;
        SupervisorWorkerCustomImpl supervisor = SupervisorWorkerCustomImpl.create(configuration);
        this.setDescription("of graph exploration");
        this.setSupervisor(supervisor);
        try {
            modelAnalysisProfile = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_SPECIFICATION_MODEL_ANALYSIS_PROFILE", "Exploration");
        }
        catch (CoreException e) {
            e.printStackTrace();
            modelAnalysisProfile = "Exploration";
        }
        boolean isRedundancyDetectionPossible = false;
        switch (modelAnalysisProfile) {
            case "Exploration": {
                isRedundancyDetectionPossible = true;
                break;
            }
            case "Transition Coverage": {
                WorkerImpl worker = TransitionCoverageWorkerCustomImpl.create(this, configuration);
                this.getWorker().add(worker);
                supervisor.getQueue().setHeuristic(true);
                supervisor.getQueue().setWeight(8);
                isRedundancyDetectionPossible = true;
                break;
            }
            case "Behavior Selection": {
                WorkerImpl worker = BehaviorCoverageWorkerCustomImpl.create(this, configuration);
                this.getWorker().add(worker);
                supervisor.getQueue().setHeuristic(true);
                break;
            }
            case "Test Offline": {
                WorkerImpl worker = OfflineTestWorkerCustomImpl.create(this, configuration);
                this.getWorker().add(worker);
                supervisor.getQueue().setHeuristic(true);
                break;
            }
        }
        if (isRedundancyDetectionPossible) {
            RedundancyDetection redundancy = CommonFactory.eINSTANCE.createRedundancyDetection();
            this.getSupervisor().setRedundancy(redundancy);
            boolean enabledRedundancyDetection = false;
            try {
                enabledRedundancyDetection = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_ENABLED_REDUNDANCY_INCLUSION_CRITERION", false);
            }
            catch (CoreException e) {
                e.printStackTrace();
                enabledRedundancyDetection = false;
            }
            if (!enabledRedundancyDetection) {
                redundancy.setComparer(null);
            }
            try {
                enabledRedundancyDetection = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_ENABLED_REDUNDANCY_LOOP_DETECTION_TRIVIAL", false);
            }
            catch (CoreException e) {
                e.printStackTrace();
                enabledRedundancyDetection = false;
            }
            redundancy.setLoopDetetctionTrivial(enabledRedundancyDetection);
        }
        return true;
    }

    public boolean configureSerializerWorker(ILaunchConfiguration configuration) {
        SerializerImpl modelSerializer;
        boolean enabledSerialization;
        try {
            enabledSerialization = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_ENABLED_FIRST_PARSED_MODEL_GRAPHVIZ_GENERATION", false);
        }
        catch (CoreException e) {
            e.printStackTrace();
            enabledSerialization = false;
        }
        if (enabledSerialization) {
            modelSerializer = ModelGraphvizSerializerWorkerCustomImpl.create(this, configuration);
            this.getWorker().add(modelSerializer);
        }
        try {
            enabledSerialization = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_ENABLED_FIRST_SYMBEX_OUTPUT_GRAPHVIZ_GENERATION", false);
        }
        catch (CoreException e) {
            e.printStackTrace();
            enabledSerialization = false;
        }
        if (enabledSerialization) {
            modelSerializer = SymbexGraphvizSerializerWorkerCustomImpl.create(this, configuration);
            this.getWorker().add(modelSerializer);
        }
        DeveloperTuningOptionCustomImpl devTuning = DeveloperTuningOptionCustomImpl.createDirector(configuration);
        this.setDeveloperTuning(devTuning);
        return true;
    }

    public boolean configureDebugWorker(ILaunchConfiguration configuration) {
        return true;
    }

    public boolean configureOtherWorker(ILaunchConfiguration configuration) {
        return true;
    }

    public static DirectorCustomImpl createSecond(Workflow workflow, ILaunchConfiguration configuration) {
        DirectorCustomImpl director = new DirectorCustomImpl(workflow);
        director.setManifest(ManifestCustomImpl.create(true, true));
        director.configureSecondWorker(configuration);
        director.configureSecondSerializerWorker(configuration, true);
        return director;
    }

    public boolean configureSecondWorker(ILaunchConfiguration configuration) {
        SupervisorWorkerCustomImpl supervisor = SupervisorWorkerCustomImpl.createSecond(configuration);
        this.setDescription("of graph exploration");
        this.setSupervisor(supervisor);
        BehaviorCoverageWorkerCustomImpl worker = BehaviorCoverageWorkerCustomImpl.createSecond(this, configuration);
        this.getWorker().add(worker);
        supervisor.getQueue().setHeuristic(true);
        return true;
    }

    public boolean configureSecondSerializerWorker(ILaunchConfiguration configuration, boolean hasSecond) {
        boolean enabledSerialization;
        try {
            enabledSerialization = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_BASIC_TRACE_ENABLED_GENERATION", false);
        }
        catch (CoreException e) {
            e.printStackTrace();
            enabledSerialization = false;
        }
        if (enabledSerialization) {
            BasicTraceSerializerWorkerCustomImpl basicSerializer = BasicTraceSerializerWorkerCustomImpl.create(this, configuration);
            this.getWorker().add(basicSerializer);
        }
        try {
            enabledSerialization = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_TTCN_ENABLED_GENERATION", false);
        }
        catch (CoreException e) {
            e.printStackTrace();
            enabledSerialization = false;
        }
        if (enabledSerialization) {
            TTCNTraceSerializerWorkerCustomImpl ttcnSerializer = TTCNTraceSerializerWorkerCustomImpl.create(this, configuration);
            this.getWorker().add(ttcnSerializer);
        }
        try {
            enabledSerialization = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_ENABLED_SECOND_SYMBEX_OUTPUT_GRAPHVIZ_GENERATION", false);
        }
        catch (CoreException e) {
            e.printStackTrace();
            enabledSerialization = false;
        }
        if (enabledSerialization) {
            SymbexGraphvizSerializerWorkerCustomImpl modelSerializer = SymbexGraphvizSerializerWorkerCustomImpl.createSecond(this, configuration);
            this.getWorker().add(modelSerializer);
        }
        if (hasSecond) {
            DeveloperTuningOptionCustomImpl devTuning = DeveloperTuningOptionCustomImpl.createSecondDirector(configuration);
            this.setDeveloperTuning(devTuning);
        }
        return true;
    }

    public void toWriter(PrettyPrintWriter writer) {
        DeveloperTuningOptionCustomImpl devTuning;
        Project project;
        writer.commentLine(this.getComment());
        writer.appendTab("director");
        String str = this.getName();
        if (str != null) {
            writer.append(' ').append(str);
        }
        if ((str = this.getDescription()) != null) {
            writer.append(" '").append(str).append("'");
        }
        writer.appendEol(" {");
        PrettyPrintWriter writer2 = writer.itab2();
        ManifestCustomImpl manifest = (ManifestCustomImpl)this.getManifest();
        if (manifest != null) {
            manifest.toWriter(writer2);
        }
        if ((project = this.getProject()) != null) {
            writer2.appendTabEol("project 'path of input model' [");
            writer2.appendTab2("source = \"").append(project.getSource()).appendEol("\"");
            writer2.appendTab2("model  = \"").append(project.getModel()).appendEol("\"");
            writer2.appendTabEol("] // end project");
        }
        ((SupervisorWorkerCustomImpl)this.getSupervisor()).toWriter(writer2);
        writer2.appendTabEol("worker [");
        PrettyPrintWriter writer3 = writer.itab3();
        for (Worker worker : this.getWorker()) {
            if (worker instanceof BehaviorCoverageWorkerCustomImpl) {
                ((BehaviorCoverageWorkerCustomImpl)worker).toWriter(writer3);
                continue;
            }
            if (worker instanceof TransitionCoverageWorkerCustomImpl) {
                ((TransitionCoverageWorkerCustomImpl)worker).toWriter(writer3);
                continue;
            }
            if (worker instanceof ModelGraphvizSerializerWorkerCustomImpl) {
                ((ModelGraphvizSerializerWorkerCustomImpl)worker).toWriter(writer3);
                continue;
            }
            if (worker instanceof SymbexGraphvizSerializerWorkerCustomImpl) {
                ((SymbexGraphvizSerializerWorkerCustomImpl)worker).toWriter(writer3);
                continue;
            }
            if (worker instanceof BasicTraceSerializerWorkerCustomImpl) {
                ((BasicTraceSerializerWorkerCustomImpl)worker).toWriter(writer3);
                continue;
            }
            if (worker instanceof TTCNTraceSerializerWorkerCustomImpl) {
                ((TTCNTraceSerializerWorkerCustomImpl)worker).toWriter(writer3);
                continue;
            }
            if (worker instanceof OfflineTestWorkerCustomImpl) {
                ((OfflineTestWorkerCustomImpl)worker).toWriter(writer3);
                continue;
            }
            writer3.commentLine(worker.getComment());
            writer3.appendTab();
            str = worker.getName();
            if (str != null) {
                writer3.append(str).append(' ');
            }
            if ((str = worker.getDescription()) != null) {
                writer3.append("'").append(str).append("' ");
            }
            writer3.appendEol("{");
            writer3.appendTabEol("}");
        }
        writer.appendTab2Eol("] // end worker");
        ConsoleLogFormatCustomImpl console = (ConsoleLogFormatCustomImpl)this.getConsole();
        if (console != null) {
            console.toWriter(writer2);
        }
        if ((devTuning = (DeveloperTuningOptionCustomImpl)this.getDeveloperTuning()) != null) {
            devTuning.toWriter(writer2);
        }
        writer.appendTabEol("}");
    }
}

