/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.spelling;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.spelling.HtmlTagDictionary;
import org.eclipse.jdt.internal.ui.text.spelling.JavaDocTagDictionary;
import org.eclipse.jdt.internal.ui.text.spelling.TaskTagDictionary;
import org.eclipse.jdt.internal.ui.text.spelling.engine.DefaultSpellChecker;
import org.eclipse.jdt.internal.ui.text.spelling.engine.ISpellCheckEngine;
import org.eclipse.jdt.internal.ui.text.spelling.engine.ISpellChecker;
import org.eclipse.jdt.internal.ui.text.spelling.engine.ISpellDictionary;
import org.eclipse.jdt.internal.ui.text.spelling.engine.LocaleSensitiveSpellDictionary;
import org.eclipse.jdt.internal.ui.text.spelling.engine.PersistentSpellDictionary;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.editors.text.EditorsUI;

public class SpellCheckEngine
implements ISpellCheckEngine,
IPropertyChangeListener {
    public static final String DICTIONARY_LOCATION = "dictionaries/";
    private static ISpellCheckEngine fgEngine = null;
    private static Set<Locale> fgLocalesWithInstalledDictionaries;
    private Set<ISpellDictionary> fGlobalDictionaries = new HashSet<ISpellDictionary>();
    private ISpellChecker fChecker = null;
    private Map<Locale, ISpellDictionary> fLocaleDictionaries = new HashMap<Locale, ISpellDictionary>();
    private ISpellDictionary fUserDictionary = null;

    private static Set<Locale> getLocalesWithInstalledDictionaries(URL location) {
        String[] fileNames;
        try {
            URL url = FileLocator.toFileURL((URL)location);
            File file = new File(url.getFile());
            if (!file.isDirectory()) {
                return Collections.emptySet();
            }
            fileNames = file.list();
            if (fileNames == null) {
                return Collections.emptySet();
            }
        }
        catch (IOException ex) {
            JavaPlugin.log(ex);
            return Collections.emptySet();
        }
        HashSet<Locale> localesWithInstalledDictionaries = new HashSet<Locale>();
        int fileNameCount = fileNames.length;
        int i = 0;
        while (i < fileNameCount) {
            String fileName = fileNames[i];
            int localeEnd = fileName.indexOf(".dictionary");
            if (localeEnd > 1) {
                String localeName = fileName.substring(0, localeEnd);
                int languageEnd = localeName.indexOf(95);
                if (languageEnd == -1) {
                    localesWithInstalledDictionaries.add(new Locale(localeName));
                } else if (languageEnd == 2 && localeName.length() == 5) {
                    localesWithInstalledDictionaries.add(new Locale(localeName.substring(0, 2), localeName.substring(3)));
                } else if (localeName.length() > 6 && localeName.charAt(5) == '_') {
                    localesWithInstalledDictionaries.add(new Locale(localeName.substring(0, 2), localeName.substring(3, 5), localeName.substring(6)));
                }
            }
            ++i;
        }
        return localesWithInstalledDictionaries;
    }

    public static Set<Locale> getLocalesWithInstalledDictionaries() {
        Enumeration<URL> locations;
        if (fgLocalesWithInstalledDictionaries != null) {
            return fgLocalesWithInstalledDictionaries;
        }
        try {
            locations = SpellCheckEngine.getDictionaryLocations();
            if (locations == null) {
                fgLocalesWithInstalledDictionaries = Collections.emptySet();
                return fgLocalesWithInstalledDictionaries;
            }
        }
        catch (IOException ex) {
            JavaPlugin.log(ex);
            fgLocalesWithInstalledDictionaries = Collections.emptySet();
            return fgLocalesWithInstalledDictionaries;
        }
        fgLocalesWithInstalledDictionaries = new HashSet<Locale>();
        while (locations.hasMoreElements()) {
            URL location = locations.nextElement();
            Set<Locale> locales = SpellCheckEngine.getLocalesWithInstalledDictionaries(location);
            fgLocalesWithInstalledDictionaries.addAll(locales);
        }
        return fgLocalesWithInstalledDictionaries;
    }

    public static Locale getDefaultLocale() {
        return Locale.getDefault();
    }

    public ISpellDictionary findDictionary(Locale locale) {
        ISpellDictionary dictionary = this.fLocaleDictionaries.get(locale);
        if (dictionary != null) {
            return dictionary;
        }
        String language = locale.getLanguage();
        for (Map.Entry<Locale, ISpellDictionary> entry : this.fLocaleDictionaries.entrySet()) {
            Locale dictLocale = entry.getKey();
            if (!dictLocale.getLanguage().equals(language)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static Locale findClosestLocale(Locale locale) {
        if (locale == null || locale.toString().length() == 0) {
            return locale;
        }
        if (SpellCheckEngine.getLocalesWithInstalledDictionaries().contains(locale)) {
            return locale;
        }
        String language = locale.getLanguage();
        for (Locale dictLocale : SpellCheckEngine.getLocalesWithInstalledDictionaries()) {
            if (!dictLocale.getLanguage().equals(language)) continue;
            return dictLocale;
        }
        Locale defaultLocale = Locale.US;
        if (SpellCheckEngine.getLocalesWithInstalledDictionaries().contains(defaultLocale)) {
            return defaultLocale;
        }
        return null;
    }

    public static Enumeration<URL> getDictionaryLocations() throws IOException {
        JavaPlugin plugin = JavaPlugin.getDefault();
        if (plugin != null) {
            return plugin.getBundle().getResources("/dictionaries/");
        }
        return null;
    }

    public static final synchronized ISpellCheckEngine getInstance() {
        if (fgEngine == null) {
            fgEngine = new SpellCheckEngine();
        }
        return fgEngine;
    }

    public static final synchronized void shutdownInstance() {
        if (fgEngine != null) {
            fgEngine.shutdown();
            fgEngine = null;
        }
    }

    private SpellCheckEngine() {
        this.fGlobalDictionaries.add(new TaskTagDictionary());
        this.fGlobalDictionaries.add(new HtmlTagDictionary());
        this.fGlobalDictionaries.add(new JavaDocTagDictionary());
        try {
            Locale locale2 = null;
            Enumeration<URL> locations = SpellCheckEngine.getDictionaryLocations();
            while (locations != null && locations.hasMoreElements()) {
                URL location = locations.nextElement();
                for (Locale locale2 : SpellCheckEngine.getLocalesWithInstalledDictionaries(location)) {
                    this.fLocaleDictionaries.put(locale2, new LocaleSensitiveSpellDictionary(locale2, location));
                }
            }
        }
        catch (IOException iOException) {}
        JavaPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        EditorsUI.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    @Override
    public final synchronized ISpellChecker getSpellChecker() throws IllegalStateException {
        if (this.fGlobalDictionaries == null) {
            throw new IllegalStateException("spell checker has been shut down");
        }
        IPreferenceStore store = JavaPlugin.getDefault().getPreferenceStore();
        Locale locale = this.getCurrentLocale(store);
        if (this.fUserDictionary == null && "".equals(locale.toString())) {
            return null;
        }
        if (this.fChecker != null && this.fChecker.getLocale().equals(locale)) {
            return this.fChecker;
        }
        this.resetSpellChecker();
        this.fChecker = new DefaultSpellChecker(store, locale);
        this.resetUserDictionary();
        for (ISpellDictionary dictionary : this.fGlobalDictionaries) {
            this.fChecker.addDictionary(dictionary);
        }
        ISpellDictionary dictionary = this.findDictionary(this.fChecker.getLocale());
        if (dictionary != null) {
            this.fChecker.addDictionary(dictionary);
        }
        return this.fChecker;
    }

    private Locale getCurrentLocale(IPreferenceStore store) {
        return SpellCheckEngine.convertToLocale(store.getString("spelling_locale"));
    }

    public static Locale convertToLocale(String locale) {
        Locale defaultLocale = SpellCheckEngine.getDefaultLocale();
        if (locale.equals(defaultLocale.toString())) {
            return defaultLocale;
        }
        int length = locale.length();
        if (length >= 5) {
            return new Locale(locale.substring(0, 2), locale.substring(3, 5));
        }
        if (length == 2 && locale.indexOf(95) == -1) {
            return new Locale(locale);
        }
        if (length == 3 && locale.charAt(0) == '_') {
            return new Locale("", locale.substring(1));
        }
        return new Locale("");
    }

    @Override
    public final synchronized Locale getLocale() {
        if (this.fChecker == null) {
            return null;
        }
        return this.fChecker.getLocale();
    }

    public final void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("spelling_locale")) {
            this.resetSpellChecker();
            return;
        }
        if (event.getProperty().equals("spelling_user_dictionary")) {
            this.resetUserDictionary();
            return;
        }
        if (event.getProperty().equals("spelling_user_dictionary_encoding")) {
            this.resetUserDictionary();
            return;
        }
        if (event.getProperty().equals("spellingEnabled") && !EditorsUI.getPreferenceStore().getBoolean("spellingEnabled")) {
            if (this == fgEngine) {
                SpellCheckEngine.shutdownInstance();
            } else {
                this.shutdown();
            }
        }
    }

    private synchronized void resetUserDictionary() {
        block13: {
            if (this.fChecker == null) {
                return;
            }
            if (this.fUserDictionary != null) {
                this.fChecker.removeDictionary(this.fUserDictionary);
                this.fUserDictionary.unload();
                this.fUserDictionary = null;
            }
            IPreferenceStore store = JavaPlugin.getDefault().getPreferenceStore();
            String filePath = store.getString("spelling_user_dictionary");
            VariablesPlugin variablesPlugin = VariablesPlugin.getDefault();
            if (variablesPlugin == null) {
                return;
            }
            IStringVariableManager variableManager = variablesPlugin.getStringVariableManager();
            try {
                filePath = variableManager.performStringSubstitution(filePath);
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
                return;
            }
            if (filePath.length() > 0) {
                try {
                    File file = new File(filePath);
                    if (!file.exists() && !file.createNewFile()) {
                        return;
                    }
                    URL url = new URL("file", null, filePath);
                    InputStream stream = url.openStream();
                    if (stream == null) break block13;
                    try {
                        this.fUserDictionary = new PersistentSpellDictionary(url);
                        this.fChecker.addDictionary(this.fUserDictionary);
                    }
                    finally {
                        stream.close();
                    }
                }
                catch (MalformedURLException malformedURLException) {
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public final synchronized void registerGlobalDictionary(ISpellDictionary dictionary) {
        this.fGlobalDictionaries.add(dictionary);
        this.resetSpellChecker();
    }

    @Override
    public final synchronized void registerDictionary(Locale locale, ISpellDictionary dictionary) {
        this.fLocaleDictionaries.put(locale, dictionary);
        this.resetSpellChecker();
    }

    @Override
    public final synchronized void shutdown() {
        JavaPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        EditorsUI.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        ISpellDictionary dictionary2 = null;
        for (ISpellDictionary dictionary2 : this.fGlobalDictionaries) {
            dictionary2.unload();
        }
        this.fGlobalDictionaries = null;
        for (ISpellDictionary dictionary2 : this.fLocaleDictionaries.values()) {
            dictionary2.unload();
        }
        this.fLocaleDictionaries = null;
        this.fUserDictionary = null;
        this.fChecker = null;
    }

    private synchronized void resetSpellChecker() {
        ISpellDictionary dictionary;
        if (this.fChecker != null && (dictionary = this.fLocaleDictionaries.get(this.fChecker.getLocale())) != null) {
            dictionary.unload();
        }
        this.fChecker = null;
    }

    @Override
    public final synchronized void unregisterDictionary(ISpellDictionary dictionary) {
        this.fGlobalDictionaries.remove(dictionary);
        this.fLocaleDictionaries.values().remove(dictionary);
        dictionary.unload();
        this.resetSpellChecker();
    }
}

