/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionMethodReference;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperMethodReference;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.TypeMethodReference;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.core.refactoring.descriptors.InlineConstantDescriptor;
import org.eclipse.jdt.core.refactoring.descriptors.JavaRefactoringDescriptor;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.core.manipulation.util.Strings;
import org.eclipse.jdt.internal.core.refactoring.descriptors.RefactoringSignatureDescriptorFactory;
import org.eclipse.jdt.internal.corext.Corext;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportReferencesCollector;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.HierarchicalASTVisitor;
import org.eclipse.jdt.internal.corext.dom.NecessaryParenthesesChecker;
import org.eclipse.jdt.internal.corext.dom.fragments.ASTFragmentFactory;
import org.eclipse.jdt.internal.corext.dom.fragments.IExpressionFragment;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.IRefactoringSearchRequestor;
import org.eclipse.jdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptorUtil;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine2;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.jdt.internal.corext.refactoring.code.ConstantChecks;
import org.eclipse.jdt.internal.corext.refactoring.code.Invocations;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TightSourceRangeComputer;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.RangeMarker;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class InlineConstantRefactoring
extends Refactoring {
    private static final String ATTRIBUTE_REPLACE = "replace";
    private static final String ATTRIBUTE_REMOVE = "remove";
    private int fSelectionStart;
    private int fSelectionLength;
    private ICompilationUnit fSelectionCu;
    private CompilationUnitRewrite fSelectionCuRewrite;
    private Name fSelectedConstantName;
    private IField fField;
    private CompilationUnitRewrite fDeclarationCuRewrite;
    private VariableDeclarationFragment fDeclaration;
    private boolean fDeclarationSelected;
    private boolean fDeclarationSelectedChecked = false;
    private boolean fInitializerAllStaticFinal;
    private boolean fInitializerChecked = false;
    private boolean fRemoveDeclaration = false;
    private boolean fReplaceAllReferences = true;
    private CompilationUnitChange[] fChanges;

    private static SimpleName getLeftmost(Name name) {
        if (name instanceof SimpleName) {
            return (SimpleName)name;
        }
        return InlineConstantRefactoring.getLeftmost(((QualifiedName)name).getQualifier());
    }

    public InlineConstantRefactoring(IField field) {
        Assert.isNotNull((Object)field);
        Assert.isTrue((!field.isBinary() ? 1 : 0) != 0);
        this.fField = field;
    }

    public InlineConstantRefactoring(ICompilationUnit unit, CompilationUnit node, int selectionStart, int selectionLength) {
        Assert.isTrue((selectionStart >= 0 ? 1 : 0) != 0);
        Assert.isTrue((selectionLength >= 0 ? 1 : 0) != 0);
        this.fSelectionCu = unit;
        this.fSelectionStart = selectionStart;
        this.fSelectionLength = selectionLength;
        if (unit != null) {
            this.initialize(unit, node);
        }
    }

    public InlineConstantRefactoring(JavaRefactoringArguments arguments, RefactoringStatus status) {
        this(null, null, 0, 0);
        RefactoringStatus initializeStatus = this.initialize(arguments);
        status.merge(initializeStatus);
    }

    private void initialize(ICompilationUnit cu, CompilationUnit node) {
        this.fSelectionCuRewrite = new CompilationUnitRewrite(cu, node);
        this.fSelectedConstantName = this.findConstantNameNode();
    }

    private Name findConstantNameNode() {
        ASTNode node = NodeFinder.perform((ASTNode)this.fSelectionCuRewrite.getRoot(), (int)this.fSelectionStart, (int)this.fSelectionLength);
        if (node == null) {
            return null;
        }
        if (node instanceof FieldAccess) {
            node = ((FieldAccess)node).getName();
        }
        if (!(node instanceof Name)) {
            return null;
        }
        Name name = (Name)node;
        IBinding binding = name.resolveBinding();
        if (!(binding instanceof IVariableBinding)) {
            return null;
        }
        IVariableBinding variableBinding = (IVariableBinding)binding;
        if (!variableBinding.isField() || variableBinding.isEnumConstant()) {
            return null;
        }
        int modifiers = binding.getModifiers();
        if (!Modifier.isStatic((int)modifiers) || !Modifier.isFinal((int)modifiers)) {
            return null;
        }
        return name;
    }

    public RefactoringStatus checkStaticFinalConstantNameSelected() {
        if (this.fSelectedConstantName == null) {
            return RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.InlineConstantRefactoring_static_final_field, null, (String)Corext.getPluginId(), (int)128, null);
        }
        return new RefactoringStatus();
    }

    public String getName() {
        return RefactoringCoreMessages.InlineConstantRefactoring_name;
    }

    public IJavaElement getField() {
        return this.fField;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask("", 3);
            if (!this.fSelectionCu.isStructureKnown()) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.InlineConstantRefactoring_syntax_errors, null, (String)Corext.getPluginId(), (int)129, null);
                return refactoringStatus;
            }
            RefactoringStatus result = this.checkStaticFinalConstantNameSelected();
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            result.merge(this.findField());
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            pm.worked(1);
            result.merge(this.findDeclaration());
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            pm.worked(1);
            result.merge(this.checkInitializer());
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            pm.worked(1);
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    private RefactoringStatus findField() {
        this.fField = (IField)((IVariableBinding)this.fSelectedConstantName.resolveBinding()).getJavaElement();
        if (this.fField != null && !this.fField.exists()) {
            return RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.InlineConstantRefactoring_local_anonymous_unsupported, null, (String)Corext.getPluginId(), (int)132, null);
        }
        return null;
    }

    private RefactoringStatus findDeclaration() throws JavaModelException {
        VariableDeclarationFragment parentDeclaration;
        this.fDeclarationSelectedChecked = true;
        this.fDeclarationSelected = false;
        ASTNode parent = this.fSelectedConstantName.getParent();
        if (parent instanceof VariableDeclarationFragment && (parentDeclaration = (VariableDeclarationFragment)parent).getName() == this.fSelectedConstantName) {
            this.fDeclarationSelected = true;
            this.fDeclarationCuRewrite = this.fSelectionCuRewrite;
            this.fDeclaration = (VariableDeclarationFragment)this.fSelectedConstantName.getParent();
            return null;
        }
        VariableDeclarationFragment declaration = (VariableDeclarationFragment)this.fSelectionCuRewrite.getRoot().findDeclaringNode(this.fSelectedConstantName.resolveBinding());
        if (declaration != null) {
            this.fDeclarationCuRewrite = this.fSelectionCuRewrite;
            this.fDeclaration = declaration;
            return null;
        }
        if (this.fField.getCompilationUnit() == null) {
            return RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.InlineConstantRefactoring_binary_file, null, (String)Corext.getPluginId(), (int)130, null);
        }
        this.fDeclarationCuRewrite = new CompilationUnitRewrite(this.fField.getCompilationUnit());
        this.fDeclaration = ASTNodeSearchUtil.getFieldDeclarationFragmentNode(this.fField, this.fDeclarationCuRewrite.getRoot());
        return null;
    }

    private RefactoringStatus checkInitializer() {
        Expression initializer = this.getInitializer();
        if (initializer == null) {
            return RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.InlineConstantRefactoring_blank_finals, null, (String)Corext.getPluginId(), (int)131, null);
        }
        this.fInitializerAllStaticFinal = ConstantChecks.isStaticFinalConstant((IExpressionFragment)ASTFragmentFactory.createFragmentForFullSubtree((ASTNode)initializer));
        this.fInitializerChecked = true;
        return new RefactoringStatus();
    }

    private VariableDeclarationFragment getDeclaration() {
        return this.fDeclaration;
    }

    private Expression getInitializer() {
        return this.fDeclaration.getInitializer();
    }

    private ICompilationUnit getDeclaringCompilationUnit() {
        return this.fField.getCompilationUnit();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        pm.beginTask("", 3);
        try {
            CompilationUnitChange change4;
            this.fSelectionCuRewrite.clearASTAndImportRewrites();
            this.fDeclarationCuRewrite.clearASTAndImportRewrites();
            ArrayList<CompilationUnitChange> changes = new ArrayList<CompilationUnitChange>();
            HashSet<SimpleName> staticImportsInInitializer = new HashSet<SimpleName>();
            ImportReferencesCollector.collect((ASTNode)this.getInitializer(), this.fField.getJavaProject(), null, new ArrayList<SimpleName>(), staticImportsInInitializer);
            if (this.getReplaceAllReferences()) {
                SearchResultGroup[] searchResultGroups = this.findReferences(pm, result);
                int i = 0;
                while (i < searchResultGroups.length) {
                    Name[] references;
                    if (pm.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    SearchResultGroup group = searchResultGroups[i];
                    ICompilationUnit cu = group.getCompilationUnit();
                    CompilationUnitRewrite cuRewrite = this.getCuRewrite(cu);
                    InlineTargetCompilationUnit targetCompilationUnit = new InlineTargetCompilationUnit(cuRewrite, references = this.extractReferenceNodes(group.getSearchResults(), cuRewrite.getRoot()), this, staticImportsInInitializer);
                    CompilationUnitChange change2 = targetCompilationUnit.getChange();
                    if (change2 != null) {
                        changes.add(change2);
                    }
                    ++i;
                }
            } else {
                Assert.isTrue((!this.isDeclarationSelected() ? 1 : 0) != 0);
                InlineTargetCompilationUnit targetForOnlySelectedReference = new InlineTargetCompilationUnit(this.fSelectionCuRewrite, new Name[]{this.fSelectedConstantName}, this, staticImportsInInitializer);
                CompilationUnitChange change3 = targetForOnlySelectedReference.getChange();
                if (change3 != null) {
                    changes.add(change3);
                }
            }
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            if (this.getRemoveDeclaration() && this.getReplaceAllReferences()) {
                InlineTargetCompilationUnit targetForDeclaration;
                boolean declarationRemoved = false;
                for (CompilationUnitChange change4 : changes) {
                    if (!change4.getCompilationUnit().equals(this.fDeclarationCuRewrite.getCu())) continue;
                    declarationRemoved = true;
                    break;
                }
                if (!declarationRemoved && (change4 = (targetForDeclaration = new InlineTargetCompilationUnit(this.fDeclarationCuRewrite, new Name[0], this, staticImportsInInitializer)).getChange()) != null) {
                    changes.add(change4);
                }
            }
            ICompilationUnit[] cus = new ICompilationUnit[changes.size()];
            int i = 0;
            while (i < changes.size()) {
                change4 = (CompilationUnitChange)changes.get(i);
                cus[i] = change4.getCompilationUnit();
                ++i;
            }
            result.merge(Checks.validateModifiesFiles(ResourceUtil.getFiles(cus), this.getValidationContext()));
            pm.worked(1);
            this.fChanges = changes.toArray(new CompilationUnitChange[changes.size()]);
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    private Name[] extractReferenceNodes(SearchMatch[] searchResults, CompilationUnit cuNode) {
        Name[] references = new Name[searchResults.length];
        int i = 0;
        while (i < searchResults.length) {
            references[i] = (Name)NodeFinder.perform((ASTNode)cuNode, (int)searchResults[i].getOffset(), (int)searchResults[i].getLength());
            ++i;
        }
        return references;
    }

    private CompilationUnitRewrite getCuRewrite(ICompilationUnit cu) {
        CompilationUnitRewrite cuRewrite = cu.equals(this.fSelectionCu) ? this.fSelectionCuRewrite : (cu.equals(this.fField.getCompilationUnit()) ? this.fDeclarationCuRewrite : new CompilationUnitRewrite(cu));
        return cuRewrite;
    }

    private SearchResultGroup[] findReferences(IProgressMonitor pm, RefactoringStatus status) throws JavaModelException {
        RefactoringSearchEngine2 engine = new RefactoringSearchEngine2(SearchPattern.createPattern((IJavaElement)this.fField, (int)2));
        engine.setFiltering(true, true);
        engine.setScope(RefactoringScopeFactory.create((IJavaElement)this.fField));
        engine.setStatus(status);
        engine.setRequestor(new IRefactoringSearchRequestor(){

            @Override
            public SearchMatch acceptSearchMatch(SearchMatch match) {
                return match.isInsideDocComment() ? null : match;
            }
        });
        engine.searchPattern((IProgressMonitor)new SubProgressMonitor(pm, 1));
        return (SearchResultGroup[])engine.getResults();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask(RefactoringCoreMessages.InlineConstantRefactoring_preview, 2);
            HashMap<String, String> arguments = new HashMap<String, String>();
            String project = null;
            IJavaProject javaProject = this.fSelectionCu.getJavaProject();
            if (javaProject != null) {
                project = javaProject.getElementName();
            }
            int flags = 786434;
            try {
                if (!Flags.isPrivate((int)this.fField.getFlags())) {
                    flags |= 4;
                }
            }
            catch (JavaModelException exception) {
                JavaPlugin.log(exception);
            }
            String description = Messages.format(RefactoringCoreMessages.InlineConstantRefactoring_descriptor_description_short, JavaElementLabels.getElementLabel((IJavaElement)this.fField, JavaElementLabels.ALL_DEFAULT));
            String header = Messages.format(RefactoringCoreMessages.InlineConstantRefactoring_descriptor_description, new String[]{JavaElementLabels.getElementLabel((IJavaElement)this.fField, JavaElementLabels.ALL_FULLY_QUALIFIED), JavaElementLabels.getElementLabel(this.fField.getParent(), JavaElementLabels.ALL_FULLY_QUALIFIED)});
            JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, (Object)this, header);
            comment.addSetting(Messages.format(RefactoringCoreMessages.InlineConstantRefactoring_original_pattern, JavaElementLabels.getElementLabel((IJavaElement)this.fField, JavaElementLabels.ALL_FULLY_QUALIFIED)));
            if (this.fRemoveDeclaration) {
                comment.addSetting(RefactoringCoreMessages.InlineConstantRefactoring_remove_declaration);
            }
            if (this.fReplaceAllReferences) {
                comment.addSetting(RefactoringCoreMessages.InlineConstantRefactoring_replace_references);
            }
            InlineConstantDescriptor descriptor = RefactoringSignatureDescriptorFactory.createInlineConstantDescriptor((String)project, (String)description, (String)comment.asString(), arguments, (int)flags);
            arguments.put("input", JavaRefactoringDescriptorUtil.elementToHandle(project, (IJavaElement)this.fSelectionCu));
            arguments.put("selection", String.valueOf(new Integer(this.fSelectionStart).toString()) + " " + new Integer(this.fSelectionLength).toString());
            arguments.put(ATTRIBUTE_REMOVE, Boolean.valueOf(this.fRemoveDeclaration).toString());
            arguments.put(ATTRIBUTE_REPLACE, Boolean.valueOf(this.fReplaceAllReferences).toString());
            DynamicValidationRefactoringChange dynamicValidationRefactoringChange = new DynamicValidationRefactoringChange((JavaRefactoringDescriptor)descriptor, RefactoringCoreMessages.InlineConstantRefactoring_inline, (Change[])this.fChanges);
            return dynamicValidationRefactoringChange;
        }
        finally {
            pm.done();
            this.fChanges = null;
        }
    }

    private void checkInvariant() {
        if (this.isDeclarationSelected()) {
            Assert.isTrue((boolean)this.fReplaceAllReferences);
        }
    }

    public boolean getRemoveDeclaration() {
        return this.fRemoveDeclaration;
    }

    public boolean getReplaceAllReferences() {
        this.checkInvariant();
        return this.fReplaceAllReferences;
    }

    public boolean isDeclarationSelected() {
        Assert.isTrue((boolean)this.fDeclarationSelectedChecked);
        return this.fDeclarationSelected;
    }

    public boolean isInitializerAllStaticFinal() {
        Assert.isTrue((boolean)this.fInitializerChecked);
        return this.fInitializerAllStaticFinal;
    }

    public void setRemoveDeclaration(boolean removeDeclaration) {
        this.fRemoveDeclaration = removeDeclaration;
    }

    public void setReplaceAllReferences(boolean replaceAllReferences) {
        this.fReplaceAllReferences = replaceAllReferences;
        this.checkInvariant();
    }

    private RefactoringStatus initialize(JavaRefactoringArguments arguments) {
        String handle;
        String selection = arguments.getAttribute("selection");
        if (selection != null) {
            int offset = -1;
            int length = -1;
            StringTokenizer tokenizer = new StringTokenizer(selection);
            if (tokenizer.hasMoreTokens()) {
                offset = Integer.valueOf(tokenizer.nextToken());
            }
            if (tokenizer.hasMoreTokens()) {
                length = Integer.valueOf(tokenizer.nextToken());
            }
            if (offset >= 0 && length >= 0) {
                this.fSelectionStart = offset;
                this.fSelectionLength = length;
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new Object[]{selection, "selection"}));
            }
        }
        if ((handle = arguments.getAttribute("input")) != null) {
            IJavaElement element = JavaRefactoringDescriptorUtil.handleToElement(arguments.getProject(), handle, false);
            if (element == null || !element.exists()) {
                return JavaRefactoringDescriptorUtil.createInputFatalStatus(element, this.getName(), "org.eclipse.jdt.ui.inline.constant");
            }
            if (element instanceof ICompilationUnit) {
                this.fSelectionCu = (ICompilationUnit)element;
                if (selection == null) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "selection"));
                }
            } else if (element instanceof IField) {
                IField field = (IField)element;
                try {
                    ISourceRange range = field.getNameRange();
                    if (range == null) {
                        return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "org.eclipse.jdt.ui.inline.constant"));
                    }
                    this.fSelectionStart = range.getOffset();
                    this.fSelectionLength = range.getLength();
                }
                catch (JavaModelException javaModelException) {
                    return JavaRefactoringDescriptorUtil.createInputFatalStatus(element, this.getName(), "org.eclipse.jdt.ui.inline.constant");
                }
                this.fSelectionCu = field.getCompilationUnit();
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new Object[]{handle, "input"}));
            }
            ASTParser parser = ASTParser.newParser((int)9);
            parser.setResolveBindings(true);
            parser.setSource(this.fSelectionCu);
            CompilationUnit unit = (CompilationUnit)parser.createAST(null);
            this.initialize(this.fSelectionCu, unit);
            if (this.checkStaticFinalConstantNameSelected().hasFatalError()) {
                return JavaRefactoringDescriptorUtil.createInputFatalStatus(element, this.getName(), "org.eclipse.jdt.ui.inline.constant");
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
        }
        String replace = arguments.getAttribute(ATTRIBUTE_REPLACE);
        if (replace == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_REPLACE));
        }
        this.fReplaceAllReferences = Boolean.valueOf(replace);
        String remove = arguments.getAttribute(ATTRIBUTE_REMOVE);
        if (remove == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_REMOVE));
        }
        this.fRemoveDeclaration = Boolean.valueOf(remove);
        return new RefactoringStatus();
    }

    private static class InlineTargetCompilationUnit {
        private final Expression fInitializer;
        private final ICompilationUnit fInitializerUnit;
        private final VariableDeclarationFragment fOriginalDeclaration;
        private final Expression[] fReferences;
        private final VariableDeclarationFragment fDeclarationToRemove;
        private final CompilationUnitRewrite fCuRewrite;
        private final TightSourceRangeComputer fSourceRangeComputer;
        private final HashSet<SimpleName> fStaticImportsInInitializer;
        private final boolean fIs15;

        private InlineTargetCompilationUnit(CompilationUnitRewrite cuRewrite, Name[] references, InlineConstantRefactoring refactoring, HashSet<SimpleName> staticImportsInInitializer) {
            this.fInitializer = refactoring.getInitializer();
            this.fInitializerUnit = refactoring.getDeclaringCompilationUnit();
            this.fCuRewrite = cuRewrite;
            this.fSourceRangeComputer = new TightSourceRangeComputer();
            this.fCuRewrite.getASTRewrite().setTargetSourceRangeComputer((TargetSourceRangeComputer)this.fSourceRangeComputer);
            this.fDeclarationToRemove = refactoring.getRemoveDeclaration() && refactoring.getReplaceAllReferences() && cuRewrite.getCu().equals(this.fInitializerUnit) ? refactoring.getDeclaration() : null;
            this.fOriginalDeclaration = refactoring.getDeclaration();
            this.fReferences = new Expression[references.length];
            int i = 0;
            while (i < references.length) {
                this.fReferences[i] = InlineTargetCompilationUnit.getQualifiedReference(references[i]);
                ++i;
            }
            this.fIs15 = JavaModelUtil.is50OrHigher((IJavaProject)cuRewrite.getCu().getJavaProject());
            this.fStaticImportsInInitializer = this.fIs15 ? staticImportsInInitializer : new HashSet(0);
        }

        private static Expression getQualifiedReference(Name fieldName) {
            if (InlineTargetCompilationUnit.doesParentQualify(fieldName)) {
                return (Expression)fieldName.getParent();
            }
            return fieldName;
        }

        private static boolean doesParentQualify(Name fieldName) {
            ASTNode parent = fieldName.getParent();
            Assert.isNotNull((Object)parent);
            if (parent instanceof FieldAccess && ((FieldAccess)parent).getName() == fieldName) {
                return true;
            }
            if (parent instanceof QualifiedName && ((QualifiedName)parent).getName() == fieldName) {
                return true;
            }
            return parent instanceof MethodInvocation && ((MethodInvocation)parent).getName() == fieldName;
        }

        public CompilationUnitChange getChange() throws CoreException {
            int i = 0;
            while (i < this.fReferences.length) {
                this.inlineReference(this.fReferences[i]);
                ++i;
            }
            this.removeConstantDeclarationIfNecessary();
            return this.fCuRewrite.createChange(true);
        }

        private void inlineReference(Expression reference) throws CoreException {
            Expression newReference;
            ASTNode importDecl = ASTNodes.getParent((ASTNode)reference, ImportDeclaration.class);
            if (importDecl != null) {
                this.fCuRewrite.getImportRemover().registerInlinedStaticImport((ImportDeclaration)importDecl);
                return;
            }
            String modifiedInitializer = this.prepareInitializerForLocation(reference);
            if (modifiedInitializer == null) {
                return;
            }
            TextEditGroup msg = this.fCuRewrite.createGroupDescription(RefactoringCoreMessages.InlineConstantRefactoring_Inline);
            boolean isStringPlaceholder = false;
            AST ast = this.fCuRewrite.getAST();
            ITypeBinding explicitCast = ASTNodes.getExplicitCast((Expression)this.fInitializer, (Expression)reference);
            if (explicitCast != null) {
                CastExpression cast = ast.newCastExpression();
                Expression modifiedInitializerExpr = (Expression)this.fCuRewrite.getASTRewrite().createStringPlaceholder(modifiedInitializer, reference.getNodeType());
                if (NecessaryParenthesesChecker.needsParentheses(this.fInitializer, (ASTNode)cast, (StructuralPropertyDescriptor)CastExpression.EXPRESSION_PROPERTY)) {
                    ParenthesizedExpression parenthesized = ast.newParenthesizedExpression();
                    parenthesized.setExpression(modifiedInitializerExpr);
                    modifiedInitializerExpr = parenthesized;
                }
                cast.setExpression(modifiedInitializerExpr);
                ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext((ASTNode)reference, this.fCuRewrite.getImportRewrite());
                cast.setType(this.fCuRewrite.getImportRewrite().addImport(explicitCast, ast, (ImportRewrite.ImportRewriteContext)context, ImportRewrite.TypeLocation.CAST));
                newReference = cast;
            } else if (this.fInitializer instanceof ArrayInitializer) {
                ArrayCreation arrayCreation = ast.newArrayCreation();
                ArrayType arrayType = (ArrayType)ASTNodeFactory.newType(ast, (VariableDeclaration)this.fOriginalDeclaration);
                arrayCreation.setType(arrayType);
                ArrayInitializer newArrayInitializer = (ArrayInitializer)this.fCuRewrite.getASTRewrite().createStringPlaceholder(modifiedInitializer, 4);
                arrayCreation.setInitializer(newArrayInitializer);
                newReference = arrayCreation;
                ITypeBinding typeToAddToImport = ASTNodes.getType((VariableDeclaration)this.fOriginalDeclaration).resolveBinding();
                ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext((ASTNode)reference, this.fCuRewrite.getImportRewrite());
                this.fCuRewrite.getImportRewrite().addImport(typeToAddToImport, (ImportRewrite.ImportRewriteContext)context);
                this.fCuRewrite.getImportRemover().registerAddedImport(typeToAddToImport.getName());
            } else {
                newReference = (Expression)this.fCuRewrite.getASTRewrite().createStringPlaceholder(modifiedInitializer, reference.getNodeType());
                isStringPlaceholder = true;
            }
            if (NecessaryParenthesesChecker.needsParentheses(isStringPlaceholder ? this.fInitializer : newReference, reference.getParent(), reference.getLocationInParent())) {
                ParenthesizedExpression parenthesized = ast.newParenthesizedExpression();
                parenthesized.setExpression(newReference);
                newReference = parenthesized;
            }
            this.fCuRewrite.getASTRewrite().replace((ASTNode)reference, (ASTNode)newReference, msg);
            this.fSourceRangeComputer.addTightSourceNode((ASTNode)reference);
            this.fCuRewrite.getImportRemover().registerRemovedNode((ASTNode)reference);
        }

        private String prepareInitializerForLocation(Expression location) throws CoreException {
            HashSet<SimpleName> staticImportsInReference = new HashSet<SimpleName>();
            IJavaProject project = this.fCuRewrite.getCu().getJavaProject();
            if (this.fIs15) {
                ImportReferencesCollector.collect((ASTNode)location, project, null, new ArrayList<SimpleName>(), staticImportsInReference);
            }
            InitializerTraversal traversal = new InitializerTraversal(this.fInitializer, this.fStaticImportsInInitializer, location, staticImportsInReference, this.fCuRewrite);
            ASTRewrite initializerRewrite = traversal.getInitializerRewrite();
            Document document = new Document(this.fInitializerUnit.getBuffer().getContents());
            RangeMarker marker = new RangeMarker(this.fInitializer.getStartPosition(), this.fInitializer.getLength());
            TextEdit[] rewriteEdits = initializerRewrite.rewriteAST((IDocument)document, this.fInitializerUnit.getJavaProject().getOptions(true)).removeChildren();
            marker.addChildren(rewriteEdits);
            try {
                marker.apply((IDocument)document, 2);
                String rewrittenInitializer = document.get(marker.getOffset(), marker.getLength());
                IRegion region = document.getLineInformation(document.getLineOfOffset(marker.getOffset()));
                int oldIndent = Strings.computeIndentUnits((String)document.get(region.getOffset(), region.getLength()), (IJavaProject)project);
                return Strings.changeIndent((String)rewrittenInitializer, (int)oldIndent, (IJavaProject)project, (String)"", (String)TextUtilities.getDefaultLineDelimiter((IDocument)document));
            }
            catch (MalformedTreeException e) {
                JavaPlugin.log(e);
            }
            catch (BadLocationException e) {
                JavaPlugin.log(e);
            }
            return this.fInitializerUnit.getBuffer().getText(this.fInitializer.getStartPosition(), this.fInitializer.getLength());
        }

        private void removeConstantDeclarationIfNecessary() {
            if (this.fDeclarationToRemove == null) {
                return;
            }
            FieldDeclaration parentDeclaration = (FieldDeclaration)this.fDeclarationToRemove.getParent();
            Object toRemove = parentDeclaration.fragments().size() == 1 ? parentDeclaration : this.fDeclarationToRemove;
            TextEditGroup msg = this.fCuRewrite.createGroupDescription(RefactoringCoreMessages.InlineConstantRefactoring_remove_declaration);
            this.fCuRewrite.getASTRewrite().remove((ASTNode)toRemove, msg);
            this.fCuRewrite.getImportRemover().registerRemovedNode((ASTNode)toRemove);
        }

        private static class InitializerTraversal
        extends HierarchicalASTVisitor {
            private final Expression fInitializer;
            private ASTRewrite fInitializerRewrite;
            private final HashSet<SimpleName> fStaticImportsInInitializer2;
            private Set<String> fNamesDeclaredLocallyAtNewLocation;
            private final Expression fNewLocation;
            private final HashSet<SimpleName> fStaticImportsInReference;
            private final CompilationUnitRewrite fNewLocationCuRewrite;
            private final ImportRewrite.ImportRewriteContext fNewLocationContext;

            private static boolean areInSameType(ASTNode one, ASTNode other) {
                ASTNode onesContainer = InitializerTraversal.getContainingTypeDeclaration(one);
                ASTNode othersContainer = InitializerTraversal.getContainingTypeDeclaration(other);
                if (onesContainer == null || othersContainer == null) {
                    return false;
                }
                ITypeBinding onesContainerBinding = InitializerTraversal.getTypeBindingForTypeDeclaration(onesContainer);
                ITypeBinding othersContainerBinding = InitializerTraversal.getTypeBindingForTypeDeclaration(othersContainer);
                Assert.isNotNull((Object)onesContainerBinding);
                Assert.isNotNull((Object)othersContainerBinding);
                String onesKey = onesContainerBinding.getKey();
                String othersKey = othersContainerBinding.getKey();
                if (onesKey == null || othersKey == null) {
                    return false;
                }
                return onesKey.equals(othersKey);
            }

            private static boolean isStaticAccess(SimpleName memberName) {
                IBinding binding = memberName.resolveBinding();
                Assert.isTrue((binding instanceof IVariableBinding || binding instanceof IMethodBinding || binding instanceof ITypeBinding ? 1 : 0) != 0);
                if (binding instanceof ITypeBinding) {
                    return true;
                }
                if (binding instanceof IVariableBinding) {
                    return ((IVariableBinding)binding).isField();
                }
                int modifiers = binding.getModifiers();
                return Modifier.isStatic((int)modifiers);
            }

            private static ASTNode getContainingTypeDeclaration(ASTNode node) {
                while (node != null && !(node instanceof AbstractTypeDeclaration) && !(node instanceof AnonymousClassDeclaration)) {
                    node = node.getParent();
                }
                return node;
            }

            private static ITypeBinding getTypeBindingForTypeDeclaration(ASTNode declaration) {
                if (declaration instanceof AnonymousClassDeclaration) {
                    return ((AnonymousClassDeclaration)declaration).resolveBinding();
                }
                if (declaration instanceof AbstractTypeDeclaration) {
                    return ((AbstractTypeDeclaration)declaration).resolveBinding();
                }
                Assert.isTrue((boolean)false);
                return null;
            }

            public InitializerTraversal(Expression initializer, HashSet<SimpleName> staticImportsInInitializer, Expression newLocation, HashSet<SimpleName> staticImportsInReference, CompilationUnitRewrite newLocationCuRewrite) {
                this.fInitializer = initializer;
                this.fInitializerRewrite = ASTRewrite.create((AST)initializer.getAST());
                this.fStaticImportsInInitializer2 = staticImportsInInitializer;
                this.fNewLocation = newLocation;
                this.fStaticImportsInReference = staticImportsInReference;
                this.fNewLocationCuRewrite = newLocationCuRewrite;
                this.fNewLocationContext = new ContextSensitiveImportRewriteContext((ASTNode)this.fNewLocation, this.fNewLocationCuRewrite.getImportRewrite());
                this.perform(initializer);
            }

            private Set<String> getLocallyDeclaredNames(BodyDeclaration scope) {
                Assert.isTrue((!(scope instanceof AbstractTypeDeclaration) ? 1 : 0) != 0);
                final HashSet<String> result = new HashSet<String>();
                if (scope instanceof FieldDeclaration) {
                    return result;
                }
                scope.accept((ASTVisitor)new HierarchicalASTVisitor(){

                    public boolean visit(AbstractTypeDeclaration node) {
                        Assert.isTrue((boolean)(node.getParent() instanceof TypeDeclarationStatement));
                        result.add(node.getName().getIdentifier());
                        return false;
                    }

                    public boolean visit(AnonymousClassDeclaration anonDecl) {
                        return false;
                    }

                    public boolean visit(VariableDeclaration varDecl) {
                        result.add(varDecl.getName().getIdentifier());
                        return false;
                    }
                });
                return result;
            }

            public ASTRewrite getInitializerRewrite() {
                return this.fInitializerRewrite;
            }

            private void perform(Expression initializer) {
                initializer.accept((ASTVisitor)this);
                this.addExplicitTypeArgumentsIfNecessary(initializer);
            }

            private void addExplicitTypeArgumentsIfNecessary(Expression invocation) {
                ASTNode referenceContext;
                if (Invocations.isResolvedTypeInferredFromExpectedType(invocation) && !((referenceContext = this.fNewLocation.getParent()) instanceof VariableDeclarationFragment) && !(referenceContext instanceof SingleVariableDeclaration) && !(referenceContext instanceof Assignment)) {
                    IMethodBinding methodBinding;
                    MethodInvocation methodInvocation;
                    Expression expression;
                    ITypeBinding[] typeArguments = Invocations.getInferredTypeArguments(invocation);
                    ListRewrite typeArgsRewrite = Invocations.getInferredTypeArgumentsRewrite(this.fInitializerRewrite, invocation);
                    int i = 0;
                    while (i < typeArguments.length) {
                        Type typeArgument = this.fNewLocationCuRewrite.getImportRewrite().addImport(typeArguments[i], this.fNewLocationCuRewrite.getAST(), this.fNewLocationContext, ImportRewrite.TypeLocation.TYPE_ARGUMENT);
                        this.fNewLocationCuRewrite.getImportRemover().registerAddedImports(typeArgument);
                        typeArgsRewrite.insertLast((ASTNode)typeArgument, null);
                        ++i;
                    }
                    if (invocation instanceof MethodInvocation && (expression = (methodInvocation = (MethodInvocation)invocation).getExpression()) == null && (methodBinding = methodInvocation.resolveMethodBinding()) != null) {
                        expression = this.fNewLocationCuRewrite.getAST().newName(this.fNewLocationCuRewrite.getImportRewrite().addImport(methodBinding.getDeclaringClass().getTypeDeclaration(), this.fNewLocationContext));
                        this.fInitializerRewrite.set((ASTNode)invocation, (StructuralPropertyDescriptor)MethodInvocation.EXPRESSION_PROPERTY, (Object)expression, null);
                    }
                }
            }

            public boolean visit(FieldAccess fieldAccess) {
                fieldAccess.getExpression().accept((ASTVisitor)this);
                return false;
            }

            public boolean visit(MethodInvocation invocation) {
                if (invocation.getExpression() == null) {
                    this.qualifyUnqualifiedMemberNameIfNecessary(invocation.getName());
                } else {
                    invocation.getExpression().accept((ASTVisitor)this);
                }
                Iterator it = invocation.arguments().iterator();
                while (it.hasNext()) {
                    ((Expression)it.next()).accept((ASTVisitor)this);
                }
                return false;
            }

            public boolean visit(Name name) {
                StructuralPropertyDescriptor locationInParent = name.getLocationInParent();
                if (locationInParent == ExpressionMethodReference.NAME_PROPERTY || locationInParent == TypeMethodReference.NAME_PROPERTY || locationInParent == SuperMethodReference.NAME_PROPERTY) {
                    return false;
                }
                SimpleName leftmost = InlineConstantRefactoring.getLeftmost(name);
                IBinding leftmostBinding = leftmost.resolveBinding();
                if (leftmostBinding instanceof IVariableBinding || leftmostBinding instanceof IMethodBinding || leftmostBinding instanceof ITypeBinding) {
                    if (this.shouldUnqualify(leftmost)) {
                        this.unqualifyMemberName(leftmost);
                    } else {
                        this.qualifyUnqualifiedMemberNameIfNecessary(leftmost);
                    }
                }
                if (leftmostBinding instanceof ITypeBinding) {
                    String addedImport = this.fNewLocationCuRewrite.getImportRewrite().addImport((ITypeBinding)leftmostBinding, this.fNewLocationContext);
                    this.fNewLocationCuRewrite.getImportRemover().registerAddedImport(addedImport);
                }
                return false;
            }

            private void qualifyUnqualifiedMemberNameIfNecessary(SimpleName memberName) {
                if (this.shouldQualify(memberName)) {
                    this.qualifyMemberName(memberName);
                }
            }

            private boolean shouldUnqualify(SimpleName memberName) {
                if (InitializerTraversal.areInSameType((ASTNode)memberName, (ASTNode)this.fNewLocation)) {
                    return !this.mayBeShadowedByLocalDeclaration(memberName);
                }
                return false;
            }

            private void unqualifyMemberName(SimpleName memberName) {
                if (InlineTargetCompilationUnit.doesParentQualify((Name)memberName)) {
                    this.fInitializerRewrite.replace(memberName.getParent(), (ASTNode)memberName, null);
                }
            }

            private boolean shouldQualify(SimpleName memberName) {
                if (!InitializerTraversal.areInSameType((ASTNode)this.fInitializer, (ASTNode)this.fNewLocation)) {
                    return true;
                }
                return this.mayBeShadowedByLocalDeclaration(memberName);
            }

            private boolean mayBeShadowedByLocalDeclaration(SimpleName memberName) {
                return this.getNamesDeclaredLocallyAtNewLocation().contains(memberName.getIdentifier());
            }

            private Set<String> getNamesDeclaredLocallyAtNewLocation() {
                if (this.fNamesDeclaredLocallyAtNewLocation != null) {
                    return this.fNamesDeclaredLocallyAtNewLocation;
                }
                BodyDeclaration enclosingBodyDecl = (BodyDeclaration)ASTNodes.getParent((ASTNode)this.fNewLocation, BodyDeclaration.class);
                Assert.isTrue((!(enclosingBodyDecl instanceof AbstractTypeDeclaration) ? 1 : 0) != 0);
                this.fNamesDeclaredLocallyAtNewLocation = this.getLocallyDeclaredNames(enclosingBodyDecl);
                return this.fNamesDeclaredLocallyAtNewLocation;
            }

            private void qualifyMemberName(SimpleName memberName) {
                if (InitializerTraversal.isStaticAccess(memberName)) {
                    IBinding memberBinding = memberName.resolveBinding();
                    if (memberBinding instanceof IVariableBinding || memberBinding instanceof IMethodBinding) {
                        if (this.fStaticImportsInReference.contains(this.fNewLocation)) {
                            this.importStatically(memberName, memberBinding);
                            return;
                        }
                        if (this.fStaticImportsInInitializer2.contains(memberName)) {
                            this.importStatically(memberName, memberBinding);
                            return;
                        }
                    }
                    this.qualifyToTopLevelClass(memberName);
                }
            }

            private void importStatically(SimpleName toImport, IBinding binding) {
                String newName = this.fNewLocationCuRewrite.getImportRewrite().addStaticImport(binding);
                this.fNewLocationCuRewrite.getImportRemover().registerAddedStaticImport(binding);
                Name newReference = ASTNodeFactory.newName(this.fInitializerRewrite.getAST(), newName);
                this.fInitializerRewrite.replace((ASTNode)toImport, (ASTNode)newReference, null);
            }

            private void qualifyToTopLevelClass(SimpleName toQualify) {
                ITypeBinding declaringClass = InitializerTraversal.getDeclaringClassBinding(toQualify);
                if (declaringClass == null) {
                    return;
                }
                Type newQualification = this.fNewLocationCuRewrite.getImportRewrite().addImport(declaringClass.getErasure(), this.fInitializerRewrite.getAST(), this.fNewLocationContext);
                this.fNewLocationCuRewrite.getImportRemover().registerAddedImports(newQualification);
                SimpleName newToQualify = (SimpleName)this.fInitializerRewrite.createMoveTarget((ASTNode)toQualify);
                QualifiedType newType = this.fInitializerRewrite.getAST().newQualifiedType(newQualification, newToQualify);
                this.fInitializerRewrite.replace((ASTNode)toQualify, (ASTNode)newType, null);
            }

            private static ITypeBinding getDeclaringClassBinding(SimpleName memberName) {
                IBinding binding = memberName.resolveBinding();
                if (binding instanceof IMethodBinding) {
                    return ((IMethodBinding)binding).getDeclaringClass();
                }
                if (binding instanceof IVariableBinding) {
                    return ((IVariableBinding)binding).getDeclaringClass();
                }
                if (binding instanceof ITypeBinding) {
                    return ((ITypeBinding)binding).getDeclaringClass();
                }
                Assert.isTrue((boolean)false);
                return null;
            }
        }
    }
}

