/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.genericeditor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;

public class CompositeContentAssistProcessor
implements IContentAssistProcessor {
    private List<IContentAssistProcessor> fContentAssistProcessors;

    public CompositeContentAssistProcessor(List<IContentAssistProcessor> contentAssistProcessors) {
        this.fContentAssistProcessors = contentAssistProcessors;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        ArrayList<ICompletionProposal> res = new ArrayList<ICompletionProposal>();
        for (IContentAssistProcessor processor : this.fContentAssistProcessors) {
            res.addAll(Arrays.asList(processor.computeCompletionProposals(viewer, offset)));
        }
        return res.toArray(new ICompletionProposal[res.size()]);
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        ArrayList<IContextInformation> res = new ArrayList<IContextInformation>();
        for (IContentAssistProcessor processor : this.fContentAssistProcessors) {
            res.addAll(Arrays.asList(processor.computeContextInformation(viewer, offset)));
        }
        return res.toArray(new IContextInformation[res.size()]);
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        HashSet<Character> res = new HashSet<Character>();
        for (IContentAssistProcessor processor : this.fContentAssistProcessors) {
            char[] chars = processor.getCompletionProposalAutoActivationCharacters();
            if (chars == null) continue;
            char[] cArray = chars;
            int n = chars.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                res.add(Character.valueOf(c));
                ++n2;
            }
        }
        return CompositeContentAssistProcessor.toCharArray(res);
    }

    private static char[] toCharArray(Set<Character> chars) {
        char[] res = new char[chars.size()];
        int i = 0;
        for (Character c : chars) {
            res[i] = c.charValue();
            ++i;
        }
        return res;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        HashSet<Character> res = new HashSet<Character>();
        for (IContentAssistProcessor processor : this.fContentAssistProcessors) {
            char[] chars = processor.getContextInformationAutoActivationCharacters();
            if (chars == null) continue;
            char[] cArray = chars;
            int n = chars.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                res.add(Character.valueOf(c));
                ++n2;
            }
        }
        return CompositeContentAssistProcessor.toCharArray(res);
    }

    public String getErrorMessage() {
        StringBuilder res = new StringBuilder();
        for (IContentAssistProcessor processor : this.fContentAssistProcessors) {
            String errorMessage = processor.getErrorMessage();
            if (errorMessage == null) continue;
            res.append(errorMessage);
            res.append('\n');
        }
        if (res.length() == 0) {
            return null;
        }
        return res.toString();
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }
}

