/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.container.common.impl.util;

import com.sun.enterprise.container.common.spi.util.JavaEEObjectStreamHandler;
import com.sun.enterprise.naming.impl.JavaURLContext;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.Serializable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.glassfish.api.naming.GlassfishNamingManager;
import org.glassfish.api.naming.SimpleJndiName;
import org.jvnet.hk2.annotations.Service;

@Service
public class JavaEEObjectStreamHandlerForJNDIContext
implements JavaEEObjectStreamHandler {
    @Inject
    private GlassfishNamingManager gfNM;

    @Override
    public Object replaceObject(Object obj) throws IOException {
        if (obj instanceof JavaURLContext) {
            JavaURLContext ctx = (JavaURLContext)obj;
            return new SerializableJNDIContext(ctx.getName());
        }
        if (obj instanceof Context) {
            Context ctx = (Context)obj;
            try {
                return new SerializableJNDIContext(SimpleJndiName.of((String)ctx.getNameInNamespace()));
            }
            catch (NamingException ex) {
                IOException ioe = new IOException();
                ioe.initCause(ex);
                throw ioe;
            }
        }
        return obj;
    }

    @Override
    public Object resolveObject(Object obj) throws IOException {
        Object result = obj;
        if (obj instanceof SerializableJNDIContext) {
            SerializableJNDIContext sctx = (SerializableJNDIContext)obj;
            try {
                SimpleJndiName name = sctx.getName();
                if (name.isEmpty()) {
                    return new InitialContext();
                }
                return this.gfNM.restoreJavaCompEnvContext(name);
            }
            catch (NamingException namEx) {
                IOException ioe = new IOException();
                ioe.initCause(namEx);
                throw ioe;
            }
        }
        return result;
    }

    private static final class SerializableJNDIContext
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final SimpleJndiName name;

        SerializableJNDIContext(SimpleJndiName name) {
            this.name = name;
        }

        public SimpleJndiName getName() {
            return this.name;
        }
    }
}

