/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.spi;

import com.sun.gjc.common.DataSourceObjectBuilder;
import com.sun.gjc.spi.ManagedConnectionFactoryImpl;
import com.sun.gjc.spi.ManagedConnectionImpl;
import com.sun.gjc.spi.base.AbstractDataSource;
import com.sun.gjc.spi.base.ConnectionHolder;
import com.sun.gjc.util.SecurityUtils;
import com.sun.logging.LogDomains;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ConfigProperty;
import jakarta.resource.spi.ConnectionDefinition;
import jakarta.resource.spi.ConnectionRequestInfo;
import jakarta.resource.spi.ManagedConnection;
import jakarta.resource.spi.ResourceAllocationException;
import jakarta.resource.spi.security.PasswordCredential;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.sql.DataSource;

@ConnectionDefinition(connectionFactory=DataSource.class, connectionFactoryImpl=AbstractDataSource.class, connection=Connection.class, connectionImpl=ConnectionHolder.class)
public class DMManagedConnectionFactory
extends ManagedConnectionFactoryImpl {
    private static Logger _logger = LogDomains.getLogger(DMManagedConnectionFactory.class, (String)"javax.enterprise.resource.resourceadapter");
    private boolean debug = _logger.isLoggable(Level.FINE);
    Properties props;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        this.logFine("In createManagedConnection");
        if (this.dataSourceObjectBuilder == null) {
            this.dataSourceObjectBuilder = new DataSourceObjectBuilder(this.spec);
        }
        PasswordCredential passwordCredential = SecurityUtils.getPasswordCredential(this, subject, cxRequestInfo);
        try {
            Class.forName(this.spec.getDetail(20));
        }
        catch (ClassNotFoundException cnfe) {
            _logger.log(Level.SEVERE, "jdbc.exc_cnfe", cnfe);
            throw new ResourceException("The driver could not be loaded: " + this.spec.getDetail(20));
        }
        Connection connection = null;
        ManagedConnectionImpl managedConnectionImpl = null;
        Properties driverProps = new Properties();
        Map<String, List<String>> properties = this.dataSourceObjectBuilder.parseDriverProperties(this.spec, false);
        for (Map.Entry<String, List<String>> entry : properties.entrySet()) {
            String value = "";
            List<String> values = entry.getValue();
            if (!values.isEmpty() && values.size() == 1) {
                value = values.get(0);
            } else if (values.size() > 1) {
                this.logFine("More than one value for key : " + entry.getKey());
            }
            String parsedKey = this.getParsedKey(entry.getKey());
            driverProps.put(parsedKey, value);
            if (!parsedKey.equalsIgnoreCase("URL") || this.spec.getDetail(3) != null) continue;
            this.setConnectionURL(value);
        }
        try {
            if (cxRequestInfo != null) {
                driverProps.setProperty("user", passwordCredential.getUserName());
                driverProps.setProperty("password", new String(passwordCredential.getPassword()));
            } else {
                String user = this.spec.getDetail(1);
                String password = this.spec.getDetail(2);
                if (user != null) {
                    driverProps.setProperty("user", user);
                }
                if (password != null) {
                    driverProps.setProperty("password", password);
                }
            }
            connection = DriverManager.getConnection(this.spec.getDetail(3), driverProps);
        }
        catch (SQLException sqle) {
            _logger.log(Level.SEVERE, "jdbc.exc_create_mc", sqle);
            throw new ResourceAllocationException("The connection could not be allocated: " + sqle.getMessage());
        }
        try {
            managedConnectionImpl = this.constructManagedConnection(null, connection, passwordCredential, this);
            this.validateAndSetIsolation(managedConnectionImpl);
        }
        finally {
            if (managedConnectionImpl == null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    _logger.log(Level.FINEST, "Exception while closing connection : createManagedConnection" + connection, e);
                }
            }
        }
        return managedConnectionImpl;
    }

    private String getParsedKey(String key) throws ResourceException {
        int indexOfSet;
        String parsedKey;
        block6: {
            parsedKey = null;
            indexOfSet = -1;
            try {
                indexOfSet = key.indexOf("set");
            }
            catch (NullPointerException npe) {
                if (!this.debug) break block6;
                _logger.log(Level.FINE, "jdbc.exc_caught_ign", npe.getMessage());
            }
        }
        if (indexOfSet == 0) {
            block7: {
                try {
                    parsedKey = key.substring(indexOfSet + 3, key.length()).trim();
                }
                catch (IndexOutOfBoundsException iobe) {
                    if (!this.debug) break block7;
                    _logger.log(Level.FINE, "jdbc.exc_caught_ign", iobe.getMessage());
                }
            }
            if (parsedKey != null && parsedKey.equals("")) {
                throw new ResourceException("Invalid driver properties string - Key cannot be an empty string");
            }
        }
        return parsedKey;
    }

    @Override
    public void setLoginTimeOut(String loginTimeOut) {
        block2: {
            try {
                DriverManager.setLoginTimeout(Integer.parseInt(loginTimeOut));
                this.spec.setDetail(4, loginTimeOut);
            }
            catch (Exception e) {
                if (!this.debug) break block2;
                _logger.log(Level.FINE, "jdbc.exc_caught_ign", e.getMessage());
            }
        }
    }

    @Override
    @ConfigProperty(type=String.class, defaultValue="org.apache.derby.jdbc.ClientDriver")
    public void setClassName(String className) {
        this.spec.setDetail(20, className);
    }

    public void setURL(String url) {
        this.spec.setDetail(3, url);
    }

    public String getURL() {
        return this.spec.getDetail(3);
    }

    public void setConnectionURL(String url) {
        this.spec.setDetail(3, url);
    }

    public String getConnectionURL() {
        return this.spec.getDetail(3);
    }

    @Override
    public Object getDataSource() throws ResourceException {
        return null;
    }

    @Override
    public boolean equals(Object other) {
        this.logFine("In equals");
        if (other instanceof DMManagedConnectionFactory) {
            DMManagedConnectionFactory otherMCF = (DMManagedConnectionFactory)other;
            return this.spec.equals(otherMCF.spec);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 217 + this.spec.hashCode();
    }
}

