/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Engine;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;

@Service(name="_list-app-refs")
@ExecuteOn(value={RuntimeType.DAS})
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="_list-app-refs", description="_list-app-refs")})
public class ListAppRefsCommand
implements AdminCommand,
AdminCommandSecurity.AccessCheckProvider {
    @Param(optional=true)
    String target = "server";
    @Param(optional=true)
    String type = null;
    @Param(optional=true, defaultValue="all")
    String state;
    @Inject
    Domain domain;
    @Inject
    Applications applications;
    private List<ApplicationRef> appRefs;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListAppRefsCommand.class);

    public Collection<? extends AccessRequired.AccessCheck> getAccessChecks() {
        ArrayList<AccessRequired.AccessCheck> accessChecks = new ArrayList<AccessRequired.AccessCheck>();
        this.appRefs = this.domain.getApplicationRefsInTarget(this.target);
        for (ApplicationRef appRef : this.appRefs) {
            accessChecks.add(new AccessRequired.AccessCheck(AccessRequired.Util.resourceNameFromConfigBeanProxy((ConfigBeanProxy)appRef), "read"));
        }
        return accessChecks;
    }

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        ActionReport.MessagePart part = report.getTopMessagePart();
        part.setMessage(this.target);
        part.setChildrenType("application");
        for (ApplicationRef appRef : this.appRefs) {
            if (!this.state.equals("all") && (!this.state.equals("running") || !Boolean.valueOf(appRef.getEnabled()).booleanValue()) && (!this.state.equals("non-running") || Boolean.valueOf(appRef.getEnabled()).booleanValue()) || !this.isApplicationOfThisType(appRef.getRef(), this.type)) continue;
            ActionReport.MessagePart childPart = part.addChild();
            childPart.setMessage(appRef.getRef());
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private boolean isApplicationOfThisType(String name, String type) {
        if (type == null) {
            return true;
        }
        Application app = this.applications.getApplication(name);
        if (app != null) {
            if (!app.isStandaloneModule()) {
                return type.equals("ear");
            }
            for (Module module : app.getModule()) {
                List engineList = module.getEngines();
                for (Engine engine : engineList) {
                    if (!engine.getSniffer().equals(type)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

