/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.javart.util.gzip;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.edt.javart.resources.Trace;
import org.eclipse.edt.javart.util.gzip.CompressionServletResponseWrapper;

public class CompressionFilter
implements Filter {
    private static final String ENABLE_COMPRESSION = "enable_compression";
    private static final String COMPRESSION_THRESHOLD = "compression_threshold";
    private static final String TRACE_LEVEL = "trace_level";
    private static final String TRACE_DEV = "trace_dev";
    private static final String TRACE_FILE = "trace_file";
    private FilterConfig config = null;
    private boolean enableCompression = true;
    private int compressionThreshold = 20480;
    private Trace tracer;

    public void init(FilterConfig filterConfig) {
        this.config = filterConfig;
        String tempValue = this.config.getInitParameter(ENABLE_COMPRESSION);
        this.enableCompression = "true".equalsIgnoreCase(tempValue);
        tempValue = this.config.getInitParameter(COMPRESSION_THRESHOLD);
        this.compressionThreshold = tempValue != null ? Integer.parseInt(tempValue) : this.compressionThreshold;
        String traceLevel = this.config.getInitParameter(TRACE_LEVEL);
        if (traceLevel == null) {
            this.tracer = new Trace("0", null, null);
        } else {
            String traceDev = this.config.getInitParameter(TRACE_DEV);
            String traceFile = this.config.getInitParameter(TRACE_FILE);
            this.tracer = new Trace(traceLevel, traceDev, traceFile);
        }
    }

    public void destroy() {
        this.config = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.enableCompression && request instanceof HttpServletRequest && response instanceof HttpServletResponse && this.isClientGzipEnabled((HttpServletRequest)request)) {
            CompressionServletResponseWrapper wrappedResponse = new CompressionServletResponseWrapper((HttpServletResponse)response, this.tracer);
            wrappedResponse.setCompressionThreshold(this.compressionThreshold);
            try {
                chain.doFilter(request, (ServletResponse)wrappedResponse);
            }
            finally {
                wrappedResponse.finishResponse();
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    public void setFilterConfig(FilterConfig filterConfig) {
        this.init(filterConfig);
    }

    public FilterConfig getFilterConfig() {
        return this.config;
    }

    private boolean isClientGzipEnabled(HttpServletRequest req) {
        String clientEncoding = req.getHeader("Accept-Encoding");
        return clientEncoding != null && clientEncoding.indexOf("gzip") != -1;
    }
}

