/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.deployment.util;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.edt.mof.egl.ExternalType;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.Service;
import org.eclipse.edt.mof.egl.utils.IRUtils;
import org.eclipse.edt.mof.serialization.IEnvironment;

public class RUIDependencyList {
    private final Part part;
    private final IEnvironment sysIREnv;
    private Set<Part> list;

    public RUIDependencyList(IEnvironment env, Part part) {
        this.part = part;
        this.sysIREnv = env;
    }

    public Set<Part> get() {
        if (this.list == null) {
            this.list = new LinkedHashSet<Part>();
            this.getReferencedParts(this.part);
            this.list.remove(this.part);
        }
        return this.list;
    }

    private void getReferencedParts(Part part) {
        if (this.list.contains(part)) {
            if (part instanceof ExternalType) {
                this.list.remove(part);
            } else {
                return;
            }
        }
        this.list.add(part);
        for (Part refPart : IRUtils.getReferencedPartsFor((Part)part)) {
            if (refPart instanceof Service || IRUtils.isSystemPart((String)refPart.getFullyQualifiedName(), (IEnvironment)this.sysIREnv)) continue;
            this.getReferencedParts(refPart);
        }
    }
}

