/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model.indexing;

import com.ibm.icu.util.StringTokenizer;
import org.eclipse.edt.ide.core.internal.model.ISourceElementRequestor;
import org.eclipse.edt.ide.core.internal.model.index.IDocument;
import org.eclipse.edt.ide.core.internal.model.indexing.BinaryIndexer;
import org.eclipse.edt.ide.core.model.IIndexConstants;

public class BinaryIndexerRequestor
implements ISourceElementRequestor,
IIndexConstants {
    private BinaryIndexer indexer;
    char[] packageName;
    char[][] enclosingTypeNames = new char[5][];
    int[] partTypes = new int[5];
    int partTypesDepth = 0;
    int depth = 0;
    int methodDepth = 0;

    public BinaryIndexerRequestor(BinaryIndexer indexer, IDocument document) {
        this.indexer = indexer;
    }

    @Override
    public void acceptField(int declarationStart, int declarationEnd, int modifiers, char[] type, char[] name, int nameSourceStart, int nameSourceEnd) {
        this.indexer.addFieldDeclaration(type, name);
    }

    @Override
    public void acceptFunctionReference(char[] functionName, int argCount, int sourcePosition) {
        this.indexer.addFunctionReference(functionName, argCount);
    }

    @Override
    public void acceptImport(int declarationStart, int declarationEnd, char[] name, boolean onDemand) {
    }

    @Override
    public void acceptLineSeparatorPositions(int[] positions) {
    }

    @Override
    public void acceptPackage(int declarationStart, int declarationEnd, char[] name) {
        this.packageName = name;
    }

    @Override
    public void acceptPartReference(char[][] typeName, int sourceStart, int sourceEnd) {
        int length = typeName.length;
        int i = 0;
        while (i < length - 1) {
            this.acceptUnknownReference(typeName[i], 0);
            ++i;
        }
        this.acceptPartReference(typeName[length - 1], 0);
    }

    @Override
    public void acceptPartReference(char[] typeName, int sourcePosition) {
        this.indexer.addPartReference(typeName);
    }

    @Override
    public void acceptProperty(int declarationStart, int declarationEnd, char[] name) {
        StringTokenizer tokenizer = new StringTokenizer(new String(name), "=\t\f\n\r");
        String key = tokenizer.nextToken().trim();
        String value = null;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("=")) continue;
            value = token.trim();
        }
        if (value != null && !value.equals("yes") && !value.equals("no")) {
            this.acceptUnknownReference(value.toCharArray(), declarationStart);
        }
        if (key != null && key.length() != 0) {
            this.acceptUnknownReference(key.toCharArray(), declarationStart);
        }
    }

    @Override
    public void acceptPropertyLiteralName(int declarationStart, int declarationEnd, char[] name) {
        if (name != null && name.length != 0) {
            this.acceptUnknownReference(name, declarationStart);
        }
    }

    @Override
    public void acceptUnknownReference(char[][] name, int sourceStart, int sourceEnd) {
        int i = 0;
        while (i < name.length) {
            this.acceptUnknownReference(name[i], 0);
            ++i;
        }
    }

    @Override
    public void acceptUnknownReference(char[] name, int sourcePosition) {
        this.indexer.addNameReference(name);
    }

    @Override
    public void acceptUse(int declarationStart, int declarationEnd, char[] name) {
    }

    @Override
    public void enterEGLFile() {
    }

    @Override
    public void enterField(int declarationStart, int modifiers, char[] type, char[] typeDeclaredPackage, char[] name, int nameSourceStart, int nameSourceEnd, boolean hasOccurs, int declarationEnd) {
        ++this.methodDepth;
        if (this.methodDepth > 1) {
            this.exitField(declarationEnd);
        }
    }

    @Override
    public void enterFunction(int declarationStart, int modifiers, char[] returnType, char[] returnTypePackage, char[] name, int nameSourceStart, int nameSourceEnd, char[][] parameterTypes, char[][] parameterNames, char[][] parameterUseTypes, boolean[] areNullable, char[][] parameterPackages) {
        this.indexer.addFunctionDeclaration(name, parameterTypes, returnType);
        ++this.methodDepth;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void enterPart(int partType, char[] subType, int contentCode, int declarationStart, int modifiers, char[] name, int nameSourceStart, int nameSourceEnd, char[][] interfaces, char[][] parameterNames, char[][] parameterTypes, char[][] usagePartTypes, char[][] usagePartPackages, String eglFileName) {
        void var16_29;
        char[][] enclosingTypeNames = new char[0][0];
        enclosingTypeNames = null;
        enclosingTypeNames = this.enclosingTypeNames();
        int n = Short.MAX_VALUE;
        switch (partType) {
            case 10: {
                int n2 = 128;
                break;
            }
            case 11: {
                int n3 = 256;
                break;
            }
            case 1: {
                boolean bl = true;
                break;
            }
            case 2: {
                int n4 = 8;
                break;
            }
            case 7: {
                int n5 = 512;
                break;
            }
            case 6: {
                int n6 = 2048;
                break;
            }
            case 16: {
                int n7 = 4096;
                break;
            }
            case 17: {
                int n8 = 8192;
                break;
            }
            case 18: {
                int n9 = 16384;
                break;
            }
            case 12: {
                int n10 = 1024;
                break;
            }
            case 19: {
                int n11 = 32;
                break;
            }
            default: {
                int n12 = Short.MAX_VALUE;
            }
        }
        this.indexer.addPartDeclaration((char)var16_29, modifiers, this.packageName, name, enclosingTypeNames, interfaces);
        this.indexer.addNameReference(subType);
        this.pushPartName(name, partType);
    }

    @Override
    public void enterPropertyBlock(int declarationStart, char[] name) {
    }

    @Override
    public void exitEGLFile(int declarationEnd) {
    }

    @Override
    public void exitField(int declarationEnd) {
        --this.methodDepth;
    }

    @Override
    public void exitFunction(int declarationEnd) {
        --this.methodDepth;
    }

    @Override
    public void exitPart(int declarationEnd) {
        this.popPartName();
    }

    @Override
    public void exitPropertyBlock(int declarationEnd) {
    }

    @Override
    public void exitUse(int declarationEnd) {
    }

    public void popPartName() {
        try {
            this.partTypes[this.partTypesDepth] = 0;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
        }
    }

    public void pushPartName(char[] typeName, int partType) {
        if (this.depth == this.enclosingTypeNames.length) {
            char[][] cArrayArray = new char[this.depth * 2][];
            this.enclosingTypeNames = cArrayArray;
            System.arraycopy(this.enclosingTypeNames, 0, cArrayArray, 0, this.depth);
        }
        if (this.partTypesDepth == this.partTypes.length) {
            this.partTypes = new int[this.partTypesDepth * 2];
            System.arraycopy(this.partTypes, 0, this.partTypes, 0, this.partTypesDepth);
        }
        this.partTypes[this.partTypesDepth++] = partType;
    }

    public char[][] enclosingTypeNames() {
        if (this.depth == 0) {
            return null;
        }
        char[][] qualification = new char[this.depth][];
        System.arraycopy(this.enclosingTypeNames, 0, qualification, 0, this.depth);
        return qualification;
    }
}

