/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model.index.impl;

import org.eclipse.edt.compiler.internal.core.utils.CharOperation;
import org.eclipse.edt.ide.core.internal.model.index.impl.Block;
import org.eclipse.edt.ide.core.internal.model.index.impl.WordEntry;

public abstract class IndexBlock
extends Block {
    public IndexBlock(int blockSize) {
        super(blockSize);
    }

    public abstract boolean addEntry(WordEntry var1);

    @Override
    public void clear() {
        this.reset();
        super.clear();
    }

    public WordEntry findEntryMatching(char[] pattern, boolean isCaseSensitive) {
        this.reset();
        WordEntry entry = new WordEntry();
        while (this.nextEntry(entry)) {
            if (!CharOperation.match((char[])pattern, (char[])entry.getWord(), (boolean)isCaseSensitive)) continue;
            return entry;
        }
        return null;
    }

    public WordEntry findEntryPrefixedBy(char[] word, boolean isCaseSensitive) {
        this.reset();
        WordEntry entry = new WordEntry();
        while (this.nextEntry(entry)) {
            if (!CharOperation.prefixEquals((char[])entry.getWord(), (char[])word, (boolean)isCaseSensitive)) continue;
            return entry;
        }
        return null;
    }

    public WordEntry findExactEntry(char[] word) {
        this.reset();
        WordEntry entry = new WordEntry();
        while (this.nextEntry(entry)) {
            if (!CharOperation.equals((char[])entry.getWord(), (char[])word)) continue;
            return entry;
        }
        return null;
    }

    public abstract boolean isEmpty();

    public abstract boolean nextEntry(WordEntry var1);

    public void reset() {
    }
}

