/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.dependency;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.compiler.internal.core.builder.BuildException;
import org.eclipse.edt.ide.core.internal.dependency.DependencyEntry;
import org.eclipse.edt.ide.core.internal.dependency.Function;
import org.eclipse.edt.ide.core.internal.dependency.FunctionEntry;
import org.eclipse.edt.ide.core.internal.dependency.IDependencyGraphEntry;
import org.eclipse.edt.ide.core.internal.dependency.IDependencyGraphValue;
import org.eclipse.edt.ide.core.internal.dependency.Part;
import org.eclipse.edt.ide.core.internal.dependency.QualifiedName;
import org.eclipse.edt.ide.core.internal.dependency.QualifiedNameDependentEntry;
import org.eclipse.edt.ide.core.internal.dependency.SimpleName;
import org.eclipse.edt.ide.core.internal.dependency.SimpleNameDependentEntry;

public class SerializationManager {
    private static final SerializationManager INSTANCE = new SerializationManager();

    private SerializationManager() {
    }

    public static SerializationManager getInstance() {
        return INSTANCE;
    }

    public void serialize(IPath outputPath, HashMap value) throws IOException {
        outputPath.removeLastSegments(1).toFile().mkdirs();
        DataOutputStream outputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outputPath.toFile())));
        try {
            outputStream.writeInt(value.size());
            for (IDependencyGraphValue entryName : value.keySet()) {
                outputStream.writeInt(entryName.getKind());
                entryName.serialize(outputStream);
                IDependencyGraphEntry entry = (IDependencyGraphEntry)value.get(entryName);
                outputStream.writeInt(entry.getKind());
                entry.serialize(outputStream);
            }
        }
        finally {
            outputStream.close();
        }
    }

    public HashMap deserialize(IPath inputPath) throws IOException {
        HashMap<IDependencyGraphValue, IDependencyGraphEntry> result = null;
        File file = inputPath.toFile();
        if (file.exists()) {
            DataInputStream inputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            result = new HashMap<IDependencyGraphValue, IDependencyGraphEntry>();
            try {
                int numEntries = inputStream.readInt();
                int i = 0;
                while (i < numEntries) {
                    IDependencyGraphEntry entry;
                    IDependencyGraphValue entryKey;
                    int valueKind = inputStream.readInt();
                    switch (valueKind) {
                        case 0: {
                            entryKey = new Function();
                            break;
                        }
                        case 1: {
                            entryKey = new Part();
                            break;
                        }
                        case 2: {
                            entryKey = new QualifiedName();
                            break;
                        }
                        case 3: {
                            entryKey = new SimpleName();
                            break;
                        }
                        default: {
                            throw new BuildException("Invalid Graph Value Kind");
                        }
                    }
                    entryKey.deserialize(inputStream);
                    int entryKind = inputStream.readInt();
                    switch (entryKind) {
                        case 0: {
                            entry = new DependencyEntry();
                            break;
                        }
                        case 1: {
                            entry = new QualifiedNameDependentEntry();
                            break;
                        }
                        case 2: {
                            entry = new SimpleNameDependentEntry();
                            break;
                        }
                        case 3: {
                            entry = new FunctionEntry();
                            break;
                        }
                        default: {
                            throw new BuildException("Invalid Graph Entry Kind");
                        }
                    }
                    entry.deserialize(inputStream);
                    result.put(entryKey, entry);
                    ++i;
                }
            }
            finally {
                inputStream.close();
            }
        }
        return result;
    }
}

