/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.bindings;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.edt.ide.core.internal.bindings.AbstractImportContainer;

public abstract class AbstractImportResolver {
    private ArrayList resolvedImports = new ArrayList();
    private ArrayList unresolvedImports = new ArrayList();
    private HashSet hashedImports = new HashSet();
    private ArrayList importContainers = new ArrayList();
    public static final char ALL_CHAR = '*';
    public static final char ANY_CHAR = '#';

    public AbstractImportResolver(String[] imports) {
        if (imports != null) {
            this.buildImportList(imports);
        }
    }

    private void buildImportList(String[] imports) {
        AbstractImportContainer temp = null;
        int i = 0;
        while (i < imports.length) {
            temp = this.getNewImportContainer(imports[i]);
            this.getImportContainers().add(temp);
            ++i;
        }
    }

    protected abstract AbstractImportContainer getNewImportContainer(String var1);

    protected boolean importHasWildcard(AbstractImportContainer importContainer) {
        String fileName;
        boolean hasWildcard = false;
        if (importContainer != null && ((fileName = importContainer.getFile()).indexOf(35) != -1 || fileName.indexOf(42) != -1)) {
            hasWildcard = true;
        }
        return hasWildcard;
    }

    public HashSet getHashedImports() {
        return this.hashedImports;
    }

    public ArrayList getImportContainers() {
        return this.importContainers;
    }

    public ArrayList getResolvedImports() {
        return this.resolvedImports;
    }

    public ArrayList getUnresolvedImports() {
        return this.unresolvedImports;
    }

    public void reset() {
        this.getResolvedImports().clear();
        this.getHashedImports().clear();
    }

    public void setUnresolvedImports(ArrayList unresolvedImports) {
        this.unresolvedImports = unresolvedImports;
    }

    protected String fixFolderSeparators(String folder) {
        String newFolder = folder;
        newFolder = newFolder.replace('\\', '/');
        return newFolder;
    }
}

