/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.deployment.core;

import java.io.FileReader;
import java.io.InputStream;
import org.eclipse.edt.ide.deployment.core.model.DeploymentDesc;
import org.eclipse.edt.ide.deployment.core.model.DeploymentProject;
import org.eclipse.edt.ide.deployment.core.model.DeploymentTarget;
import org.eclipse.edt.ide.deployment.core.model.RUIApplication;
import org.eclipse.edt.ide.deployment.core.model.RUIHandler;
import org.eclipse.edt.ide.deployment.core.model.Service;
import org.eclipse.edt.javart.resources.egldd.Parameter;
import org.eclipse.edt.javart.resources.egldd.RuntimeDeploymentDescParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;

public class DeploymentDescParser
extends RuntimeDeploymentDescParser {
    private Service currentService;
    private RUIApplication currentRuiApplication;
    private RUIHandler currentRUIHandler;
    private DeploymentTarget currentTarget;

    public DeploymentDesc parse(DeploymentDesc desc, String path) throws Exception {
        this.desc = desc;
        return (DeploymentDesc)this.parse(new InputSource(new FileReader(path)));
    }

    public DeploymentDesc parse(DeploymentDesc desc, InputStream is) throws Exception {
        this.desc = desc;
        return (DeploymentDesc)this.parse(new InputSource(is));
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (!localName.equals("deployment")) {
            if (localName.equals("service")) {
                this.currentService = new Service(attributes.getValue("type"), attributes.getValue("implementation"));
            } else if (localName.equals("target.project")) {
                this.currentTarget = new DeploymentProject(attributes.getValue("name"));
                ((DeploymentDesc)this.desc).setTarget(this.currentTarget);
            } else if (localName.equals("ruiapplication")) {
                this.currentRuiApplication = new RUIApplication(attributes.getValue("name"), attributes.getValue("deployAllHandlers"));
                ((DeploymentDesc)this.desc).setRUIApplication(this.currentRuiApplication);
            } else if (localName.equals("ruihandler")) {
                this.currentRUIHandler = new RUIHandler(attributes.getValue("implementation"), attributes.getValue("enableGeneration"));
                if (this.currentRuiApplication != null) {
                    this.currentRuiApplication.addRUIHandler(this.currentRUIHandler);
                }
            } else if (localName.equals("resource")) {
                if (this.desc != null) {
                    ((DeploymentDesc)this.desc).addResourceOmission(attributes.getValue("id"));
                }
            } else {
                super.startElement(uri, localName, qName, attributes);
            }
        }
    }

    protected void addParameter(Parameter param) {
        if (this.currentService != null) {
            this.currentService.addParameter(param);
        } else if (this.currentRUIHandler != null) {
            this.currentRUIHandler.addParameter(param);
        } else if (this.currentRuiApplication != null) {
            this.currentRuiApplication.addParameter(param);
        } else if (this.currentTarget != null) {
            this.currentTarget.addParameter(param);
        } else {
            super.addParameter(param);
        }
    }

    public void endElement(String uri, String localName, String qName) {
        if (localName.equals("service")) {
            ((DeploymentDesc)this.desc).addService(this.currentService);
            this.currentService = null;
        } else if (localName.equals("ruiapplication")) {
            this.currentRuiApplication = null;
        } else if (localName.equals("ruihandler")) {
            this.currentRUIHandler = null;
        } else if (localName.equals("target.project") || localName.equals("target.directory")) {
            this.currentTarget = null;
        } else {
            super.endElement(uri, localName, qName);
        }
    }
}

