/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.widget.layout;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.ide.rui.server.EvEditorProvider;
import org.eclipse.edt.ide.rui.server.PropertyValue;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvDesignOverlayDropLocation;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetDescriptorRegistry;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetManager;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetPart;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.layout.AbstractWidgetLayout;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.layout.WidgetLayoutData;
import org.eclipse.edt.ide.rui.visualeditor.plugin.Activator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Rectangle;

public class GridLayoutWidgetLayout
extends AbstractWidgetLayout {
    private int[] cellInfo;
    private static final String[] LAYOUTDATA_NAME = new String[]{"org.eclipse.edt.rui.widgets", "GridLayoutData"};
    private static final String[] GRIDLAYOUT = new String[]{"org.eclipse.edt.rui.widgets", "GridLayout"};
    private static final String LayoutInnerRectanglesInfoCackeKey = "GridLayout-InnerRectangles-LayoutInfoCackeKey";
    private static final String LayoutCellsInfoCackeKey = "GridLayout-Cells-LayoutInfoCackeKey";
    private static final String LayoutLocaionsInfoCackeKey = "GridLayout-Locaions-LayoutInfoCackeKey";

    @Override
    public void initialize(ScrolledComposite parentComposite, WidgetPart widget, WidgetPart _widgetDragging, WidgetManager widgetManager, WidgetDescriptorRegistry widgetDescriptorRegistry, EvEditorProvider evEditorProvider) {
        super.initialize(parentComposite, widget, _widgetDragging, widgetManager, widgetDescriptorRegistry, evEditorProvider);
        this.cellInfo = (int[])widget.getFromCache(LayoutCellsInfoCackeKey);
        if (this.cellInfo != null) {
            return;
        }
        String extrainfo = widget.getExtraInfo("LayoutInfo");
        if (extrainfo == null || extrainfo.length() == 0) {
            return;
        }
        String[] tdInfo = extrainfo.split(":");
        try {
            this.cellInfo = new int[tdInfo.length];
            int i = 0;
            while (i < tdInfo.length) {
                this.cellInfo[i] = Integer.parseInt(tdInfo[i]);
                ++i;
            }
        }
        catch (Exception exception) {}
        widget.putIntoCache(LayoutCellsInfoCackeKey, this.cellInfo);
    }

    @Override
    public void setupDropLocations(Collection listDropLocations) {
        if (this._widgetDragging != null && !this.isContainable(this._widgetDragging.getTypeName(), this.widgetRoot.getTypeName())) {
            return;
        }
        if (this.cellInfo == null || this.cellInfo.length == 0) {
            this.setupDropLocationsForInsideContainer(this.widgetRoot, listDropLocations);
            return;
        }
        ArrayList<EvDesignOverlayDropLocation> locations = (ArrayList<EvDesignOverlayDropLocation>)this.widgetRoot.getFromCache(LayoutLocaionsInfoCackeKey);
        if (locations != null) {
            listDropLocations.addAll(locations);
            return;
        }
        locations = new ArrayList<EvDesignOverlayDropLocation>();
        int i = 0;
        while (i < this.cellInfo.length / 7) {
            int index = i * 7;
            if (this.cellInfo[index + 6] == 0) {
                Rectangle rectDrop = new Rectangle(0, 0, 0, 0);
                rectDrop.x = this.cellInfo[index + 2];
                rectDrop.y = this.cellInfo[index + 3];
                rectDrop.width = this.cellInfo[index + 4];
                if (rectDrop.width < 5) {
                    rectDrop.width = 5;
                }
                rectDrop.height = this.cellInfo[index + 5];
                if (rectDrop.height < 5) {
                    rectDrop.height = 5;
                }
                EvDesignOverlayDropLocation location = new EvDesignOverlayDropLocation();
                location.iIndex = 0;
                location.iLocation = 0x1000000;
                location.widgetParent = this.widgetRoot;
                location.selectedTransparent = 255;
                location.nonselectedTransparent = 255;
                location.lineStyle = 2;
                location.lineWidth = 1;
                location.widgetLayoutData = new WidgetLayoutData(new GridLayoutWidgetLayoutData(this.cellInfo[index] + 1, this.cellInfo[index + 1] + 1), this);
                location.setBounds(rectDrop.x, rectDrop.y, rectDrop.width, rectDrop.height);
                locations.add(location);
            }
            ++i;
        }
        this.widgetRoot.putIntoCache(LayoutLocaionsInfoCackeKey, locations);
        listDropLocations.addAll(locations);
    }

    @Override
    public List getInnerRectanglesForPaintingWidget(WidgetPart widget) {
        ArrayList<Rectangle> extraRactangles = (ArrayList<Rectangle>)widget.getFromCache(LayoutInnerRectanglesInfoCackeKey);
        if (extraRactangles != null) {
            return extraRactangles;
        }
        String extrainfo = widget.getExtraInfo("LayoutInfo");
        if (extrainfo == null || extrainfo.length() == 0) {
            return null;
        }
        String[] tdInfo = extrainfo.split(":");
        try {
            this.cellInfo = new int[tdInfo.length];
            int i = 0;
            while (i < tdInfo.length) {
                this.cellInfo[i] = Integer.parseInt(tdInfo[i]);
                ++i;
            }
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui.visualeditor", "GridLayoutWidgetLayout: Error parse LayoutInfo", (Throwable)e));
        }
        extraRactangles = new ArrayList<Rectangle>();
        int i = 0;
        while (i < this.cellInfo.length / 7) {
            int index = i * 7;
            Rectangle rect = new Rectangle(0, 0, 0, 0);
            rect.x = this.cellInfo[index + 2];
            rect.y = this.cellInfo[index + 3];
            rect.width = this.cellInfo[index + 4];
            if (rect.width < 5) {
                rect.width = 5;
            }
            rect.height = this.cellInfo[index + 5];
            if (rect.height < 5) {
                rect.height = 5;
            }
            extraRactangles.add(rect);
            ++i;
        }
        widget.putIntoCache(LayoutInnerRectanglesInfoCackeKey, extraRactangles);
        return extraRactangles;
    }

    @Override
    public String processNewLayoutData(Object layoutData, String template) {
        if (layoutData instanceof GridLayoutWidgetLayoutData) {
            GridLayoutWidgetLayoutData data = (GridLayoutWidgetLayoutData)layoutData;
            template = template.replace("${row}", String.valueOf(data.row));
            template = template.replace("${column}", String.valueOf(data.column));
            return template;
        }
        return "";
    }

    @Override
    public void updateLayoutData(EvEditorProvider editorProvider, int statementOffset, WidgetPart widget, Object layoutData, PropertyValue oldLayoutData, String layoutDataTemplte) {
        if (layoutData instanceof GridLayoutWidgetLayoutData) {
            GridLayoutWidgetLayoutData data = (GridLayoutWidgetLayoutData)layoutData;
            if (oldLayoutData == null || ((String)oldLayoutData.getValues().get(0)).toLowerCase().indexOf("gridlayoutdata") < 0) {
                String layoutProperty = this.processNewLayoutData(layoutData, layoutDataTemplte);
                PropertyValue propertyValue = new PropertyValue(layoutProperty, true);
                editorProvider.setPropertyValue(statementOffset, widget.getStatementLength(), "layoutData", "", propertyValue);
            } else {
                int changed = 0;
                changed = editorProvider.setLayoutPropertyValue(statementOffset, widget.getStatementLength(), "row", "", new PropertyValue(String.valueOf(data.row), true));
                changed += editorProvider.setLayoutPropertyValue(statementOffset, widget.getStatementLength() + changed, "column", "", new PropertyValue(String.valueOf(data.column), true));
            }
        }
    }

    @Override
    public String[] getLayoutDataQualifiedName() {
        return LAYOUTDATA_NAME;
    }

    @Override
    public String[] getLayoutWidgetQualifiedName() {
        return GRIDLAYOUT;
    }

    private static class GridLayoutWidgetLayoutData {
        int row;
        int column;

        GridLayoutWidgetLayoutData(int row, int column) {
            this.row = row;
            this.column = column;
        }
    }
}

