/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.widget;

import java.util.List;
import org.eclipse.edt.ide.rui.visualeditor.internal.preferences.EvPreferences;
import org.eclipse.edt.ide.rui.visualeditor.internal.util.ColorUtil;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class WidgetPainter
implements DisposeListener {
    protected Color BLACK = null;
    protected Color GRAY = null;
    protected Color WHITE = null;
    protected boolean _bDragging = false;
    protected boolean _bFocus = false;
    protected boolean _bMouseOver = false;
    protected boolean _bOutline = false;
    protected boolean _bPatternSelection = false;
    protected boolean _bPatternSelectionWhite = false;
    protected boolean _bSelected = false;
    protected boolean _bIsContainer = false;
    protected boolean _bIsSelectedWidget = false;
    protected Color _colorSelected = null;
    protected Color _colorLogicalArea = null;
    protected Composite _compositeParent = null;
    protected Rectangle _rectBounds = new Rectangle(0, 0, 0, 0);
    protected Rectangle _rectDragging = new Rectangle(0, 0, 0, 0);
    protected List _innerRectangles = null;
    protected Point _mouseDownPoint = null;

    public WidgetPainter(Composite compositeParent) {
        this._compositeParent = compositeParent;
        this._compositeParent.addDisposeListener((DisposeListener)this);
        Display display = compositeParent.getDisplay();
        this.BLACK = display.getSystemColor(2);
        this.GRAY = display.getSystemColor(15);
        this.WHITE = display.getSystemColor(1);
        this._colorLogicalArea = new Color((Device)display, 190, 190, 190);
        this.updateColors();
    }

    public void setMouseDownPoint(Point mouseDownPoint) {
        this._mouseDownPoint = mouseDownPoint;
    }

    public void setIsSelectedWidget(boolean isSelectedWidget) {
        this._bIsSelectedWidget = isSelectedWidget;
    }

    protected Rectangle getBounds() {
        return new Rectangle(this._rectBounds.x, this._rectBounds.y, this._rectBounds.width, this._rectBounds.height);
    }

    protected void paintCorners(GC gc) {
        boolean bWidthLongerThanHeight;
        Rectangle rectBounds = this.getBounds();
        int iLengthX = 0;
        int iLengthY = 0;
        boolean bl = bWidthLongerThanHeight = rectBounds.width > rectBounds.height;
        if (this._bSelected) {
            iLengthX = bWidthLongerThanHeight ? 8 : 6;
            iLengthY = bWidthLongerThanHeight ? 6 : 8;
        } else if (this._bMouseOver) {
            iLengthX = bWidthLongerThanHeight ? 7 : 5;
            iLengthY = bWidthLongerThanHeight ? 5 : 7;
        } else {
            iLengthX = bWidthLongerThanHeight ? 6 : 4;
            iLengthY = bWidthLongerThanHeight ? 4 : 6;
        }
        iLengthX = Math.min(iLengthX, rectBounds.width / 3);
        iLengthY = Math.min(iLengthY, rectBounds.height / 3);
        int iWidth = 2;
        if (this._bSelected) {
            iWidth = 3;
        } else if (this._bMouseOver) {
            iWidth = 3;
        }
        Color color = this.BLACK;
        int i = 0;
        while (i < iWidth) {
            if (i == 1) {
                color = this.GRAY;
            } else if (i == 2) {
                color = this._bSelected ? this.BLACK : this.GRAY;
            }
            gc.setForeground(color);
            gc.drawLine(rectBounds.x, rectBounds.y, rectBounds.x + iLengthX, rectBounds.y);
            gc.drawLine(rectBounds.x, rectBounds.y, rectBounds.x, rectBounds.y + iLengthY);
            gc.drawLine(rectBounds.x + rectBounds.width - 1 - iLengthX, rectBounds.y, rectBounds.x + rectBounds.width - 1, rectBounds.y);
            gc.drawLine(rectBounds.x + rectBounds.width - 1, rectBounds.y, rectBounds.x + rectBounds.width - 1, rectBounds.y + iLengthY);
            gc.drawLine(rectBounds.x, rectBounds.y + rectBounds.height - 1, rectBounds.x + iLengthX, rectBounds.y + rectBounds.height - 1);
            gc.drawLine(rectBounds.x, rectBounds.y + rectBounds.height - 1 - iLengthY, rectBounds.x, rectBounds.y + rectBounds.height - 1);
            gc.drawLine(rectBounds.x + rectBounds.width - 1 - iLengthX, rectBounds.y + rectBounds.height - 1, rectBounds.x + rectBounds.width - 1, rectBounds.y + rectBounds.height - 1);
            gc.drawLine(rectBounds.x + rectBounds.width - 1, rectBounds.y + rectBounds.height - 1 - iLengthY, rectBounds.x + rectBounds.width - 1, rectBounds.y + rectBounds.height - 1);
            ++rectBounds.x;
            ++rectBounds.y;
            rectBounds.width -= 2;
            rectBounds.height -= 2;
            --iLengthX;
            --iLengthY;
            ++i;
        }
    }

    protected void paintRectangleDotted(GC gc, int iWidth, Color color, Rectangle rectB) {
        Rectangle rectBounds = new Rectangle(rectB.x, rectB.y, rectB.width, rectB.height);
        --rectBounds.width;
        --rectBounds.height;
        gc.setForeground(color);
        gc.setLineWidth(iWidth);
        gc.setLineStyle(3);
        gc.drawRectangle(rectBounds);
        gc.setLineStyle(1);
    }

    protected void paintRectangleSelected(GC gc, Rectangle rectBounds) {
        gc.setLineStyle(1);
        gc.setLineWidth(1);
        if (!this._bPatternSelection) {
            gc.setForeground(this._colorSelected);
            Rectangle rect = new Rectangle(rectBounds.x, rectBounds.y, rectBounds.width - 1, rectBounds.height - 1);
            gc.drawRectangle(rect);
            rect = new Rectangle(rectBounds.x + 1, rectBounds.y + 1, rectBounds.width - 3, rectBounds.height - 3);
            gc.drawRectangle(rect);
            return;
        }
        if (this._bFocus && !this._bDragging) {
            gc.setLineStyle(6);
            gc.setLineDash(new int[]{4});
            gc.setLineWidth(2);
            Rectangle rect = new Rectangle(rectBounds.x + 1, rectBounds.y + 1, rectBounds.width - 2, rectBounds.height - 2);
            gc.setForeground(this._colorSelected);
            gc.drawRectangle(rect);
            gc.setLineDash(new int[0]);
        }
    }

    protected void paintRectangleSolid(GC gc, int iWidth, Color color, Rectangle rectB) {
        gc.setLineStyle(1);
        gc.setLineWidth(1);
        Rectangle rectBounds = new Rectangle(rectB.x, rectB.y, rectB.width, rectB.height);
        --rectBounds.width;
        --rectBounds.height;
        gc.setForeground(color);
        int i = 0;
        while (i < iWidth) {
            gc.drawRectangle(rectBounds);
            ++rectBounds.x;
            ++rectBounds.y;
            rectBounds.width -= 2;
            rectBounds.height -= 2;
            ++i;
        }
    }

    public void paintWidget(GC gc) {
        Rectangle rectBounds = this.getBounds();
        if (rectBounds.isEmpty()) {
            return;
        }
        boolean selectInnerRec = false;
        if (this._innerRectangles != null) {
            int i = 0;
            while (i < this._innerRectangles.size()) {
                Rectangle rectangle = (Rectangle)this._innerRectangles.get(i);
                if (this._mouseDownPoint != null && this._bIsSelectedWidget && rectangle.contains(this._mouseDownPoint)) {
                    if (this._bFocus) {
                        this.paintRectangleSelected(gc, rectangle);
                    } else {
                        this.paintRectangleSolid(gc, 2, this._colorSelected, rectangle);
                        Rectangle rectOffset2 = new Rectangle(rectangle.x + 2, rectangle.y + 2, rectangle.width - 4, rectangle.height - 4);
                        this.paintRectangleSolid(gc, 1, this._bPatternSelectionWhite ? this.WHITE : this.BLACK, rectOffset2);
                    }
                    selectInnerRec = true;
                } else {
                    this.paintRectangleDotted(gc, 1, this._colorLogicalArea, rectangle);
                }
                ++i;
            }
        }
        if (this._bSelected) {
            if (this._bFocus && !this._bDragging) {
                if (!selectInnerRec) {
                    this.paintRectangleSelected(gc, rectBounds);
                }
            } else if (!selectInnerRec) {
                this.paintRectangleSolid(gc, 2, this._colorSelected, rectBounds);
                Rectangle rectOffset2 = new Rectangle(rectBounds.x + 2, rectBounds.y + 2, rectBounds.width - 4, rectBounds.height - 4);
                this.paintRectangleSolid(gc, 1, this._bPatternSelectionWhite ? this.WHITE : this.BLACK, rectOffset2);
            }
        } else if (this._bOutline || this._bMouseOver) {
            this.paintRectangleSolid(gc, 2, this.GRAY, rectBounds);
        }
        if (this._bIsContainer) {
            this.paintCorners(gc);
        }
    }

    public void paintWidgetDragging(GC gc) {
        this.paintRectangleDotted(gc, 2, this._colorSelected, this._rectDragging);
    }

    public void setBounds(Rectangle rectBounds) {
        this._rectBounds.x = rectBounds.x;
        this._rectBounds.y = rectBounds.y;
        this._rectBounds.width = rectBounds.width;
        this._rectBounds.height = rectBounds.height;
    }

    public void setBoundsDragging(Rectangle rectDragging) {
        this._rectDragging.x = rectDragging.x;
        this._rectDragging.y = rectDragging.y;
        this._rectDragging.width = rectDragging.width;
        this._rectDragging.height = rectDragging.height;
    }

    public void setDragging(boolean bDragging) {
        this._bDragging = bDragging;
    }

    public void setIsContainer(boolean bIsContainer) {
        this._bIsContainer = bIsContainer;
    }

    public void setDrawOutline(boolean bOutline) {
        this._bOutline = bOutline;
    }

    public void setFocus(boolean bFocus) {
        this._bFocus = bFocus;
    }

    public void setMouseOver(boolean bMouseOver) {
        this._bMouseOver = bMouseOver;
    }

    public void setSelected(boolean bSelected) {
        this._bSelected = bSelected;
    }

    public void setInnerRectangles(List innerRectangles) {
        this._innerRectangles = innerRectangles;
    }

    public void updateColors() {
        int iBlu;
        int iGrn;
        String strColorSelection = EvPreferences.getString("org.eclipse.edt.ide.rui.visualeditor.ColorSelection");
        this._bPatternSelection = EvPreferences.getBoolean("org.eclipse.edt.ide.rui.visualeditor.PatternSelection");
        Color color = ColorUtil.getColorFromRGBString(Display.getCurrent(), strColorSelection);
        if (color == null) {
            return;
        }
        if (this._colorSelected != null && !this._colorSelected.isDisposed()) {
            this._colorSelected.dispose();
        }
        this._colorSelected = color;
        int iRed = this._colorSelected.getRed();
        double dLuminance = 0.3 * (double)iRed + 0.59 * (double)(iGrn = this._colorSelected.getGreen()) + 0.11 * (double)(iBlu = this._colorSelected.getBlue());
        this._bPatternSelectionWhite = dLuminance < 150.0;
    }

    public void widgetDisposed(DisposeEvent e) {
        if (this._colorSelected != null && !this._colorSelected.isDisposed()) {
            this._colorSelected.dispose();
            this._colorSelected = null;
        }
        if (this._colorLogicalArea != null && !this._colorLogicalArea.isDisposed()) {
            this._colorLogicalArea.dispose();
            this._colorLogicalArea = null;
        }
    }
}

