/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.properties;

import java.util.ArrayList;
import org.eclipse.edt.ide.rui.visualeditor.internal.properties.PropertyEditorAbstract;
import org.eclipse.edt.ide.rui.visualeditor.internal.properties.PropertyPage;
import org.eclipse.edt.ide.rui.visualeditor.internal.properties.PropertySheetPage;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetPropertyDescriptor;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetPropertyValue;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class PropertyEditorInteger
extends PropertyEditorAbstract
implements FocusListener,
SelectionListener {
    protected PropertySheetPage _page = null;
    protected WidgetPropertyValue _propertyValueOriginal = null;
    protected String _strName = null;
    protected Text _text = null;

    public PropertyEditorInteger(PropertyPage page, WidgetPropertyDescriptor descriptor) {
        super(page, descriptor);
    }

    @Override
    public void createControl(Composite compositeParent) {
        this._text = new Text(compositeParent, 2048);
        GridData gridData = new GridData(768);
        gridData.widthHint = 100;
        this._text.setLayoutData((Object)gridData);
        this._text.setData((Object)this._descriptor);
        this._text.addFocusListener((FocusListener)this);
        this._text.addSelectionListener((SelectionListener)this);
    }

    @Override
    public void initialize() {
        this._propertyValueOriginal = this.getPropertyValue(this.getPropertyDescriptor().getID(), this.getPropertyDescriptor().getType());
        if (this._propertyValueOriginal == null || this._propertyValueOriginal.getValues() == null || this._propertyValueOriginal.getValues().size() == 0) {
            this._text.setText("");
            this.setTooltipText();
            return;
        }
        ArrayList listValues = this._propertyValueOriginal.getValues();
        if (!(listValues.get(0) instanceof String)) {
            this._text.setText("");
            this.setTooltipText();
            return;
        }
        String strValue = (String)listValues.get(0);
        this._text.setText(strValue);
        this.setTooltipText();
        this._text.setEnabled(this._propertyValueOriginal.isEditable());
        if (strValue.length() > 0) {
            this._text.setSelection(strValue.length());
        }
    }

    public void focusGained(FocusEvent e) {
        String strText = this._text.getText();
        if (strText.length() > 0) {
            this._text.setSelection(strText.length());
        }
    }

    public void focusLost(FocusEvent e) {
        this.valueChanged();
    }

    protected void setTooltipText() {
        if (this._text == null || this._text.isDisposed()) {
            return;
        }
        String strDefault = "";
        if (this._text.getText().length() == 0) {
            strDefault = this.getPropertyDescriptor().getDefault();
        }
        this._text.setToolTipText(strDefault != null ? strDefault : "");
    }

    protected void valueChanged() {
        if (this._text.isDisposed()) {
            return;
        }
        if (this._text.getText().length() > 0) {
            try {
                new Integer(this._text.getText());
                this._text.setBackground(null);
            }
            catch (NumberFormatException numberFormatException) {
                this._text.setBackground(this._text.getDisplay().getSystemColor(7));
                return;
            }
        }
        WidgetPropertyValue propertyValueNew = new WidgetPropertyValue(this._text.getText());
        super.propertyValueChanged(this.getPropertyDescriptor(), this._propertyValueOriginal, propertyValueNew);
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
        this.valueChanged();
    }

    public void widgetSelected(SelectionEvent arg0) {
    }
}

