/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.wizards;

import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.FunctionParameter;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IFunction;
import org.eclipse.edt.ide.ui.wizards.EGLFileConfiguration;
import org.eclipse.edt.ide.ui.wizards.EGLFileOperation;
import org.eclipse.edt.ide.ui.wizards.ExtractInterfaceConfiguration;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.Type;

public class ExtractInterfaceOperation
extends EGLFileOperation {
    private ExtractInterfaceConfiguration configuration;

    public ExtractInterfaceOperation(ExtractInterfaceConfiguration configuration) {
        super(configuration);
        this.configuration = configuration;
    }

    public ExtractInterfaceOperation(ExtractInterfaceConfiguration configuration, ISchedulingRule rule) {
        super(configuration, rule);
        this.configuration = configuration;
    }

    public static String getFunctionFullSignature(NestedFunction eglfunc, String currFilePkg) {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append("function");
        strbuf.append(" ");
        strbuf.append(ExtractInterfaceConfiguration.getFunctionSimpleSignature(eglfunc, true, currFilePkg));
        final int[] outparamCnt = new int[1];
        if (eglfunc.hasReturnType()) {
            strbuf.append(" ");
            strbuf.append("returns");
            strbuf.append(" ");
            strbuf.append("(");
            org.eclipse.edt.compiler.core.ast.Type returnType = eglfunc.getReturnType();
            String qualifiedReturnTypeString = ExtractInterfaceConfiguration.getQualifiedTypeString(returnType, currFilePkg, true);
            strbuf.append(qualifiedReturnTypeString);
            strbuf.append(")");
        } else {
            eglfunc.accept((IASTVisitor)new DefaultASTVisitor(){

                public boolean visit(NestedFunction nestedFunction) {
                    return true;
                }

                public boolean visit(FunctionParameter functionParameter) {
                    if (functionParameter.getUseType() == FunctionParameter.UseType.OUT) {
                        outparamCnt[0] = outparamCnt[0] + 1;
                    }
                    return false;
                }
            });
        }
        Member nestedFuncBinding = eglfunc.getName().resolveMember();
        if (nestedFuncBinding != null) {
            StringBuffer nameVal = new StringBuffer();
            StringBuffer namespaceVal = new StringBuffer();
            EGLFileConfiguration.getXMLAnnotationValueFromBinding((Element)nestedFuncBinding, nameVal, namespaceVal);
            strbuf.append(ExtractInterfaceOperation.getXMLAnnotationString(namespaceVal.toString(), nameVal.toString()));
        } else if (outparamCnt[0] == 1) {
            strbuf.append(ExtractInterfaceOperation.getXMLAnnotationString(null, null));
        }
        return strbuf.toString();
    }

    public static String getFunctionFullSignature(IFunction func, String currFilePkg) throws EGLModelException {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append("function");
        strbuf.append(" ");
        strbuf.append(ExtractInterfaceConfiguration.getFunctionSimpleSignature(func, true, currFilePkg));
        int[] cfr_ignored_0 = new int[1];
        if (func.getReturnTypeName() != null) {
            strbuf.append(" ");
            strbuf.append("returns");
            strbuf.append(" ");
            strbuf.append("(");
            String returnTypeString = func.getReturnTypeName();
            String returnTypePkg = func.getReturnTypePackage();
            String qualifiedReturnTypeString = ExtractInterfaceConfiguration.getQualifiedTypeString(returnTypeString, returnTypePkg, currFilePkg);
            strbuf.append(qualifiedReturnTypeString);
            strbuf.append(")");
        }
        return strbuf.toString();
    }

    private String getAbstractFunctionDefinitionString(NestedFunction eglfunc, String currFilePkg) {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append(ExtractInterfaceOperation.getFunctionFullSignature(eglfunc, currFilePkg));
        strbuf.append(";");
        strbuf.append(newLine);
        return strbuf.toString();
    }

    private StringBuffer getInterfaceString() {
        StringBuffer strInterface = new StringBuffer("interface");
        strInterface.append(" ");
        strInterface.append(this.configuration.getInterfaceName());
        Part boundServicePart = this.configuration.getTheBoundPart();
        Type serviceNameBinding = boundServicePart.getName().resolveType();
        if (serviceNameBinding != null) {
            StringBuffer nameVal = new StringBuffer();
            StringBuffer namespaceVal = new StringBuffer();
            EGLFileConfiguration.getXMLAnnotationValueFromBinding((Element)serviceNameBinding, nameVal, namespaceVal);
            strInterface.append(ExtractInterfaceOperation.getXMLAnnotationString(namespaceVal.toString(), nameVal.toString()));
        } else {
            String serviceSimpleName = this.configuration.getTheBoundPart().getIdentifier();
            String servicePackage = this.configuration.getOriginalServicePackage();
            strInterface.append(ExtractInterfaceOperation.getXMLAnnotationString(this.createNamespace(servicePackage), serviceSimpleName));
        }
        strInterface.append(newLine);
        strInterface.append(newLine);
        List funcstates = this.configuration.getFFunctionsSelectionState();
        List funcs = this.configuration.getFFunctions();
        int i = 0;
        while (i < funcstates.size()) {
            if (this.configuration.getFunctionSelectionState(i)) {
                strInterface.append("\t");
                strInterface.append(this.getAbstractFunctionDefinitionString((NestedFunction)funcs.get(i), this.configuration.getFPackage()));
            }
            ++i;
        }
        strInterface.append("end");
        strInterface.append(newLine);
        strInterface.append(newLine);
        return strInterface;
    }

    @Override
    protected String getFileContents() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getInterfaceString());
        return buf.toString();
    }

    private String createNamespace(String ePackage) {
        StringBuffer sbuffer;
        if (ePackage == null || ePackage.length() < 1) {
            sbuffer = new StringBuffer("http://default");
        } else {
            StringTokenizer tokenizer = new StringTokenizer(ePackage, ".", true);
            sbuffer = new StringBuffer();
            while (tokenizer.countTokens() > 0) {
                sbuffer.insert(0, tokenizer.nextToken());
            }
            sbuffer.insert(0, "http://");
        }
        return sbuffer.toString();
    }
}

