/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.edt.compiler.internal.EGLBasePlugin;
import org.eclipse.edt.ide.core.EDTCoreIDEPlugin;
import org.eclipse.edt.ide.core.Logger;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.core.utils.ProjectSettingsUtility;
import org.eclipse.edt.ide.ui.internal.deployment.ui.EGLDDRootHelper;
import org.eclipse.edt.ide.ui.internal.project.features.operations.EGLProjectFeatureOperation;
import org.eclipse.edt.ide.ui.internal.util.CoreUtility;
import org.osgi.service.prefs.BackingStoreException;

public class EGLProjectEGLDDGenerationOperation
extends EGLProjectFeatureOperation {
    public EGLProjectEGLDDGenerationOperation(IProject project, ISchedulingRule rule, boolean isWebProject) {
        super(project, rule, isWebProject);
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        EGLProjectEGLDDGenerationOperation.executeOperation(this.getProj());
    }

    public static void executeOperation(IProject project) throws CoreException {
        IEGLProject thisProject = EGLCore.create((IProject)project);
        IPath srcPath = thisProject.getPath().append(EDTCoreIDEPlugin.getPlugin().getPreferenceStore().getString("eglSourceFolder"));
        IPackageFragmentRoot eglSrcFolder = thisProject.getPackageFragmentRoot(srcPath);
        IFolder container = (IFolder)eglSrcFolder.getUnderlyingResource();
        Path filePath = new Path(CoreUtility.getValidProjectName(project.getName()));
        filePath = filePath.addFileExtension("egldd");
        IFile eglddFile = container.getFile((IPath)filePath);
        String encodingName = EGLBasePlugin.getPlugin().getPreferenceStore().getString("outputCodeset");
        EGLDDRootHelper.createNewEGLDDFile(eglddFile, encodingName);
        try {
            ProjectSettingsUtility.setDefaultDeploymentDescriptor((IProject)project, (String)eglddFile.getFullPath().toPortableString().toString());
        }
        catch (BackingStoreException e) {
            Logger.log(EGLProjectEGLDDGenerationOperation.class, (String)"EGLProjectEGLDDGenerationOperation.executeOperation() - BackingStoreException", (Throwable)e);
        }
    }
}

