/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.search;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IFunction;
import org.eclipse.edt.ide.core.search.IEGLSearchScope;
import org.eclipse.edt.ide.ui.internal.PluginImages;
import org.eclipse.edt.ide.ui.internal.search.EGLSearchMessages;
import org.eclipse.edt.ide.ui.internal.search.EGLSearchResultCollector;
import org.eclipse.edt.ide.ui.internal.search.PrettySignature;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class EGLSearchOperation
extends WorkspaceModifyOperation {
    private IEGLElement fElementPattern;
    private int fLimitTo;
    private String fStringPattern;
    private String fScopeDescription;
    private EGLSearchResultCollector fCollector;

    protected EGLSearchOperation(IWorkspace workspace, int limitTo, IEGLSearchScope scope, String scopeDescription, EGLSearchResultCollector collector) {
        this.fLimitTo = limitTo;
        this.fScopeDescription = scopeDescription;
        this.fCollector = collector;
    }

    public EGLSearchOperation(IWorkspace workspace, IEGLElement pattern, int limitTo, IEGLSearchScope scope, String scopeDescription, EGLSearchResultCollector collector) {
        this(workspace, limitTo, scope, scopeDescription, collector);
        this.fElementPattern = pattern;
    }

    public EGLSearchOperation(IWorkspace workspace, String pattern, boolean caseSensitive, int searchFor, int limitTo, IEGLSearchScope scope, String scopeDescription, EGLSearchResultCollector collector) {
        this(workspace, limitTo, scope, scopeDescription, collector);
        this.fStringPattern = pattern;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException {
        this.fCollector.setProgressMonitor(monitor);
    }

    String getSingularLabel() {
        String desc = null;
        if (this.fElementPattern != null) {
            desc = this.fLimitTo == 1 && this.fElementPattern.getElementType() == 10 ? PrettySignature.getUnqualifiedFunctionSignature((IFunction)this.fElementPattern) : this.fElementPattern.getElementName();
            if ("".equals(desc) && this.fElementPattern.getElementType() == 4) {
                desc = EGLSearchMessages.EGLSearchOperationDefault_package;
            }
        } else {
            desc = this.fStringPattern;
        }
        Object[] args = new String[]{desc, this.fScopeDescription};
        switch (this.fLimitTo) {
            case 0: {
                return EGLSearchMessages.bind((String)EGLSearchMessages.EGLSearchOperation_singularDeclarationsPostfix, (Object[])args);
            }
            case 1: {
                return EGLSearchMessages.bind((String)EGLSearchMessages.EGLSearchOperation_singularReferencesPostfix, (Object[])args);
            }
            case 2: {
                return EGLSearchMessages.bind((String)EGLSearchMessages.EGLSearchOperation_singularOccurrencesPostfix, (Object[])args);
            }
        }
        return EGLSearchMessages.bind((String)EGLSearchMessages.EGLSearchOperation_singularOccurrencesPostfix, (Object[])args);
    }

    String getPluralLabelPattern() {
        String desc = null;
        if (this.fElementPattern != null) {
            desc = this.fLimitTo == 1 && this.fElementPattern.getElementType() == 10 ? PrettySignature.getUnqualifiedFunctionSignature((IFunction)this.fElementPattern) : this.fElementPattern.getElementName();
            if ("".equals(desc) && this.fElementPattern.getElementType() == 4) {
                desc = EGLSearchMessages.EGLSearchOperationDefault_package;
            }
        } else {
            desc = this.fStringPattern;
        }
        Object[] args = new String[]{desc, "{0}", this.fScopeDescription};
        switch (this.fLimitTo) {
            case 0: {
                return EGLSearchMessages.bind((String)EGLSearchMessages.EGLSearchOperation_pluralDeclarationsPostfix, (Object[])args);
            }
            case 1: {
                return EGLSearchMessages.bind((String)EGLSearchMessages.EGLSearchOperation_pluralReferencesPostfix, (Object[])args);
            }
            case 2: {
                return EGLSearchMessages.bind((String)EGLSearchMessages.EGLSearchOperation_pluralOccurrencesPostfix, (Object[])args);
            }
        }
        return EGLSearchMessages.bind((String)EGLSearchMessages.EGLSearchOperation_pluralOccurrencesPostfix, (Object[])args);
    }

    ImageDescriptor getImageDescriptor() {
        if (this.fLimitTo == 0) {
            return PluginImages.DESC_OBJS_SEARCH_DECL;
        }
        return PluginImages.DESC_OBJS_SEARCH_REF;
    }
}

