/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.project.wizard.pages;

import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.edt.ide.ui.project.templates.IProjectTemplate;
import org.eclipse.edt.ide.ui.project.templates.ProjectTemplateManager;
import org.eclipse.edt.ide.ui.project.templates.ProjectTemplateWizardNode;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer2;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardSelectionPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledFormText;

public class ProjectTemplateSelectionPage
extends WizardSelectionPage
implements ISelectionChangedListener,
IDoubleClickListener {
    protected TableViewer templateViewer;
    protected ScrolledFormText descriptionText;

    public ProjectTemplateSelectionPage(String pageName) {
        super(pageName);
        this.setTitle(NewWizardMessages.ProjectTemplateSelectionPage_title);
        this.setDescription(NewWizardMessages.ProjectTemplateSelectionPage_description);
    }

    protected void setLabel(Composite container) {
        Label label = new Label(container, 0);
        label.setText(NewWizardMessages.ProjectTemplateSelectionPage_templatesLabel);
        label = new Label(container, 0);
        label.setText(NewWizardMessages.ProjectTemplateSelectionPage_descriptionLabel);
    }

    protected IProjectTemplate[] getTemplates() {
        return ProjectTemplateManager.getInstance().getTemplates("org.eclipse.edt.ide.ui.projects");
    }

    protected void setHelp(Composite container) {
    }

    public void createControl(Composite parent) {
        int borderStyle;
        Composite container = new Composite(parent, 0);
        this.setHelp(container);
        container.setLayout((Layout)new GridLayout(2, true));
        this.setLabel(container);
        this.templateViewer = new TableViewer(container, 2048);
        Table control = this.templateViewer.getTable();
        GridData data = new GridData(1808);
        data.heightHint = 350;
        data.widthHint = 250;
        control.setLayoutData((Object)data);
        IProjectTemplate[] templates = this.getTemplates();
        this.templateViewer.setContentProvider((IContentProvider)new TreeContentProvider());
        this.templateViewer.setLabelProvider((IBaseLabelProvider)new TreeLabelProvider());
        this.templateViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.templateViewer.setInput((Object)templates);
        this.templateViewer.addDoubleClickListener((IDoubleClickListener)this);
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        this.descriptionText = new ScrolledFormText(container, 768, false);
        int n = borderStyle = toolkit.getBorderStyle() == 2048 ? 0 : 2048;
        if (borderStyle == 0) {
            this.descriptionText.setData("FormWidgetFactory.drawBorder", (Object)"treeBorder");
            toolkit.paintBordersFor(container);
        }
        FormText ftext = toolkit.createFormText((Composite)this.descriptionText, false);
        this.descriptionText.setFormText(ftext);
        this.descriptionText.setExpandHorizontal(false);
        this.descriptionText.setExpandVertical(false);
        this.descriptionText.setBackground(toolkit.getColors().getBackground());
        this.descriptionText.setForeground(toolkit.getColors().getForeground());
        ftext.marginWidth = 2;
        ftext.marginHeight = 2;
        this.descriptionText.setLayoutData((Object)new GridData(1808));
        if (templates != null) {
            IPreferenceStore store = EDTUIPlugin.getDefault().getPreferenceStore();
            String selectedId = store.getString("newProjectWizard_SelectedTemplate");
            int selectedIndex = -1;
            int defaultIndex = -1;
            int i = 0;
            while (i < templates.length) {
                if (templates[i].getId().equals(selectedId)) {
                    selectedIndex = i;
                }
                if (templates[i].isDefault()) {
                    defaultIndex = i;
                }
                ++i;
            }
            if (selectedIndex < 0) {
                selectedIndex = defaultIndex;
            }
            if (selectedIndex < 0) {
                selectedIndex = 0;
            }
            this.templateViewer.setSelection((ISelection)new StructuredSelection(new Object[]{templates[selectedIndex]}), true);
        }
        this.setControl((Control)container);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object o = ((IStructuredSelection)event.getSelection()).getFirstElement();
        if (o instanceof IProjectTemplate) {
            this.handleSelectedTemplate();
            this.setTemplateDescription(((IProjectTemplate)o).getDescription());
        }
        this.validatePage();
    }

    protected void validatePage() {
        Object o = ((IStructuredSelection)this.templateViewer.getSelection()).getFirstElement();
        if (o instanceof IProjectTemplate) {
            IProjectTemplate template = (IProjectTemplate)o;
            ProjectTemplateWizardNode wizNode = (ProjectTemplateWizardNode)template.getWizardNode();
            this.handleSelectedTemplate();
            boolean b = wizNode != null && (wizNode.getTemplate().canFinish() || wizNode.isContentCreated() && wizNode.getWizard() != null && wizNode.getWizard().canFinish());
            this.setPageComplete(b);
        } else {
            this.setPageComplete(false);
        }
    }

    protected void handleSelectedTemplate() {
        Object o = ((IStructuredSelection)this.templateViewer.getSelection()).getFirstElement();
        if (o instanceof IProjectTemplate) {
            IProjectTemplate template = (IProjectTemplate)o;
            ProjectTemplateWizardNode wizNode = (ProjectTemplateWizardNode)template.getWizardNode();
            if (wizNode != null) {
                wizNode.setParentWizard(this.getWizard());
                this.setSelectedNode(wizNode);
            } else {
                this.setSelectedNode(null);
            }
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.validatePage();
        }
    }

    private void setTemplateDescription(String text) {
        try {
            this.descriptionText.setText(text != null ? text : "");
        }
        catch (Exception exception) {
            this.descriptionText.setText("");
        }
    }

    public void doubleClick(DoubleClickEvent event) {
        if (event.getSource() == this.templateViewer) {
            if (this.getSelectedNode() != null) {
                IWizard wiz = this.getWizard();
                IWizardContainer2 cfr_ignored_0 = (IWizardContainer2)wiz.getContainer();
                WizardDialog d = (WizardDialog)wiz.getContainer();
                d.showPage(this.getNextPage());
            } else if (this.getWizard().canFinish() && this.getWizard().performFinish()) {
                this.getWizard().getContainer().getShell().close();
            }
        }
    }

    private class TreeContentProvider
    implements IStructuredContentProvider {
        private TreeContentProvider() {
        }

        public Object[] getElements(Object input) {
            return (IProjectTemplate[])input;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class TreeLabelProvider
    implements ILabelProvider {
        public Image getImage(Object element) {
            if (element instanceof IProjectTemplate && ((IProjectTemplate)element).getIcon() != null) {
                return ((IProjectTemplate)element).getIcon().createImage();
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof IProjectTemplate) {
                return ((IProjectTemplate)element).getName();
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

