/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.handlers.wizards;

import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.handlers.wizards.HandlerConfiguration;
import org.eclipse.edt.ide.ui.internal.handlers.wizards.NewHandlerSummaryPage;
import org.eclipse.edt.ide.ui.internal.handlers.wizards.NewHandlerWizard;
import org.eclipse.edt.ide.ui.internal.handlers.wizards.RUIWidgetOperation;
import org.eclipse.edt.ide.ui.templates.wizards.TemplateWizard;
import org.eclipse.jface.dialogs.IPageChangingListener;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;

public class RUIWidgetWizard
extends TemplateWizard
implements IPageChangingListener {
    private static final String WIZPAGENAME_RUIWidgetWizardPage = "WIZPAGENAME_RUIWidgetWizardPage";
    protected NewHandlerSummaryPage summaryPage;
    protected HandlerConfiguration configuration;
    protected String part;

    public RUIWidgetWizard() {
        this.setNeedsProgressMonitor(true);
        this.setDialogSettings(EDTUIPlugin.getDefault().getDialogSettings());
    }

    public HandlerConfiguration getConfiguration() {
        return (HandlerConfiguration)((NewHandlerWizard)this.getParentWizard()).getConfiguration();
    }

    public void addPages() {
        this.summaryPage = new NewHandlerSummaryPage();
        this.addPage((IWizardPage)this.summaryPage);
    }

    public void setContainer(IWizardContainer wizardContainer) {
        super.setContainer(wizardContainer);
        if (wizardContainer != null) {
            ((WizardDialog)wizardContainer).addPageChangingListener((IPageChangingListener)this);
        }
        this.processInput();
    }

    @Override
    public boolean performFinish() {
        this.processInput();
        this.getConfiguration().setHandlerType(2);
        if (this.part == null) {
            return false;
        }
        ((NewHandlerWizard)this.getParentWizard()).setContentObj(this.part);
        return true;
    }

    private void processInput() {
        RUIWidgetOperation op = new RUIWidgetOperation(this.getConfiguration(), this.getConfiguration().getFileName());
        try {
            this.part = op.getFileContents();
            if (this.summaryPage != null) {
                this.summaryPage.setContent(this.part);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void handlePageChanging(PageChangingEvent event) {
        if (event.getTargetPage() == this.summaryPage) {
            this.processInput();
        }
    }
}

