/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.formatting.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.IUIHelpConstants;
import org.eclipse.edt.ide.ui.internal.formatting.profile.Category;
import org.eclipse.edt.ide.ui.internal.formatting.profile.DefaultProfile;
import org.eclipse.edt.ide.ui.internal.formatting.profile.EGLFormatProfileRoot;
import org.eclipse.edt.ide.ui.internal.formatting.profile.FormatProfiles;
import org.eclipse.edt.ide.ui.internal.formatting.profile.Profile;
import org.eclipse.edt.ide.ui.internal.formatting.ui.FormatProfileRootHelper;
import org.eclipse.edt.ide.ui.internal.formatting.ui.LineWrappingTabPage;
import org.eclipse.edt.ide.ui.internal.formatting.ui.ModifyDialogTabPage;
import org.eclipse.edt.ide.ui.internal.formatting.ui.ProfileManager;
import org.eclipse.edt.ide.ui.internal.formatting.ui.RenameProfileDialog;
import org.eclipse.edt.ide.ui.internal.formatting.ui.WhiteSpaceTabPage;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.PlatformUI;

public class ModifyDialog
extends StatusDialog {
    private static final String DS_KEY_LAST_FOCUS = "org.eclipse.edt.ide.uiformatter_page.modify_dialog.last_focus";
    private static final String DS_KEY_PREFERRED_WIDTH = "org.eclipse.edt.ide.uiformatter_page.modify_dialog.preferred_width";
    private static final String DS_KEY_PREFERRED_HEIGHT = "org.eclipse.edt.ide.uiformatter_page.modify_dialog.preferred_height";
    private static final String DS_KEY_PREFERRED_X = "org.eclipse.edt.ide.uiformatter_page.modify_dialog.preferred_x";
    private static final String DS_KEY_PREFERRED_Y = "org.eclipse.edt.ide.uiformatter_page.modify_dialog.preferred_y";
    private Map fAllPreferenceSettings;
    private ProfileManager fProfileManager;
    private final boolean fIsNewProfile;
    private EObject fProfile;
    private IStatus fStandardStatus;
    private final String fTitle;
    final IDialogSettings fDialogSettings;
    protected final List fTabPages;
    private TabFolder fTabFolder;
    private Button fApplyButton;

    protected ModifyDialog(Shell parentShell, EObject profileOrDefaultProfile, ProfileManager profileManager, boolean isNewProfile) {
        super(parentShell);
        this.fProfileManager = profileManager;
        this.fIsNewProfile = isNewProfile;
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.fProfile = profileOrDefaultProfile;
        if (this.fProfileManager.isProfileBuildIn(this.fProfile)) {
            this.fStandardStatus = new Status(1, EDTUIPlugin.getPluginId(), 0, NewWizardMessages.INFO_EnterNewProfileName, null);
            this.fTitle = NewWizardMessages.bind((String)NewWizardMessages.ShowProfile, (Object)this.fProfileManager.getProfileDisplayName(this.fProfile));
        } else {
            this.fStandardStatus = new Status(0, EDTUIPlugin.getPluginId(), 0, "", null);
            this.fTitle = NewWizardMessages.bind((String)NewWizardMessages.EditProfile, (Object)this.fProfileManager.getProfileDisplayName(this.fProfile));
        }
        this.fAllPreferenceSettings = this.fProfileManager.getCurrentPreferenceSettingMap();
        this.updateStatus(this.fStandardStatus);
        this.fTabPages = new ArrayList();
        this.fDialogSettings = EDTUIPlugin.getDefault().getDialogSettings();
    }

    public void create() {
        super.create();
        int lastFocusNr = 0;
        try {
            lastFocusNr = this.fDialogSettings.getInt(DS_KEY_LAST_FOCUS);
            if (lastFocusNr < 0) {
                lastFocusNr = 0;
            }
            if (lastFocusNr > this.fTabPages.size() - 1) {
                lastFocusNr = this.fTabPages.size() - 1;
            }
        }
        catch (NumberFormatException numberFormatException) {
            lastFocusNr = 0;
        }
        if (!this.fIsNewProfile) {
            this.fTabFolder.setSelection(lastFocusNr);
            ((ModifyDialogTabPage)this.fTabFolder.getSelection()[0].getData()).setInitialFocus();
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.fTitle);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.fTabFolder = new TabFolder(composite, 0);
        this.fTabFolder.setFont(composite.getFont());
        this.fTabFolder.setLayoutData((Object)new GridData(1808));
        this.createCategoryTabPages();
        ModifyDialog.applyDialogFont((Control)composite);
        this.fTabFolder.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TabItem tabItem = (TabItem)e.item;
                ModifyDialogTabPage page = (ModifyDialogTabPage)tabItem.getData();
                ModifyDialog.this.fDialogSettings.put(ModifyDialog.DS_KEY_LAST_FOCUS, ModifyDialog.this.fTabPages.indexOf(page));
                page.makeVisible();
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, IUIHelpConstants.FORMATTER_MODIFY_PROFILE_PAGE);
        return composite;
    }

    private void createCategoryTabPages() {
        EGLFormatProfileRoot Root = this.fProfileManager.getBuildInFormatProfileRoot();
        FormatProfiles profilesRoot = Root.getFormatProfiles();
        DefaultProfile defaultProfile = profilesRoot.getDefaultProfile();
        if (defaultProfile != null) {
            EList categories = defaultProfile.getCategory();
            for (Category category : categories) {
                String tabTitle = FormatProfileRootHelper.getFormattingProfileNLSString(category.getDisplay());
                this.addTabPage(this.fTabFolder, tabTitle, defaultProfile, category);
            }
        }
    }

    private final void addTabPage(TabFolder tabFolder, String title, DefaultProfile defaultProfile, Category category) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        ModifyDialog.applyDialogFont((Control)tabItem.getControl());
        tabItem.setText(title);
        String categoryId = category.getId();
        ModifyDialogTabPage tabPage = null;
        tabPage = categoryId.equals("whiteSpace") ? new WhiteSpaceTabPage(this, defaultProfile, category, this.fAllPreferenceSettings) : (categoryId.equals("lineWrapping") ? new LineWrappingTabPage(this, defaultProfile, category, this.fAllPreferenceSettings) : new ModifyDialogTabPage(this, defaultProfile, category, this.fAllPreferenceSettings));
        tabItem.setData((Object)tabPage);
        tabItem.setControl((Control)tabPage.createContents((Composite)tabFolder));
        this.fTabPages.add(tabPage);
    }

    public void updateStatus(IStatus status) {
        IStatus statusArg = status != null ? status : this.fStandardStatus;
        super.updateStatus(statusArg);
        if (this.fApplyButton != null && !this.fApplyButton.isDisposed()) {
            this.fApplyButton.setEnabled(this.hasChanges() && !statusArg.matches(4));
        }
    }

    protected Point getInitialSize() {
        Point initialSize = super.getInitialSize();
        try {
            int lastHeight;
            int lastWidth = this.fDialogSettings.getInt(DS_KEY_PREFERRED_WIDTH);
            if (initialSize.x > lastWidth) {
                lastWidth = initialSize.x;
            }
            if (initialSize.y > (lastHeight = this.fDialogSettings.getInt(DS_KEY_PREFERRED_HEIGHT))) {
                lastHeight = initialSize.x;
            }
            return new Point(lastWidth, lastHeight);
        }
        catch (NumberFormatException numberFormatException) {
            return initialSize;
        }
    }

    protected Point getInitialLocation(Point initialSize) {
        try {
            return new Point(this.fDialogSettings.getInt(DS_KEY_PREFERRED_X), this.fDialogSettings.getInt(DS_KEY_PREFERRED_Y));
        }
        catch (NumberFormatException numberFormatException) {
            return super.getInitialLocation(initialSize);
        }
    }

    private void disposePages() {
        for (Object obj : this.fTabPages) {
            if (!(obj instanceof ModifyDialogTabPage)) continue;
            ModifyDialogTabPage page = (ModifyDialogTabPage)obj;
            page.dispose();
        }
    }

    public boolean close() {
        Rectangle shell = this.getShell().getBounds();
        this.fDialogSettings.put(DS_KEY_PREFERRED_WIDTH, shell.width);
        this.fDialogSettings.put(DS_KEY_PREFERRED_HEIGHT, shell.height);
        this.fDialogSettings.put(DS_KEY_PREFERRED_X, shell.x);
        this.fDialogSettings.put(DS_KEY_PREFERRED_Y, shell.y);
        this.disposePages();
        return super.close();
    }

    protected void okPressed() {
        if (this.hasChanges() && !this.applyPressed()) {
            return;
        }
        super.okPressed();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1024) {
            this.applyPressed();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected void cancelPressed() {
        this.fProfileManager.undoPreferenceSettings(this.fAllPreferenceSettings);
        super.cancelPressed();
    }

    private boolean applyPressed() {
        if (this.fProfileManager.isProfileBuildIn(this.fProfile)) {
            RenameProfileDialog dialog = new RenameProfileDialog(this.getShell(), NewWizardMessages.SaveAsProfile, this.fProfile, this.fProfileManager);
            if (dialog.open() != 0) {
                return false;
            }
            this.fProfile = dialog.getRenamedProfile();
            this.fStandardStatus = new Status(0, EDTUIPlugin.getPluginId(), 0, "", null);
            this.updateStatus(this.fStandardStatus);
        }
        this.fProfileManager.updateProfileSettings((Profile)this.fProfile, this.fAllPreferenceSettings);
        this.fProfileManager.setSelectedProfile(this.fProfile);
        this.fApplyButton.setEnabled(false);
        return true;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.fApplyButton = this.createButton(parent, 1024, NewWizardMessages.Apply, false);
        this.fApplyButton.setEnabled(false);
        GridLayout layout = (GridLayout)parent.getLayout();
        ++layout.numColumns;
        layout.makeColumnsEqualWidth = false;
        Label label = new Label(parent, 0);
        GridData data = new GridData();
        data.widthHint = layout.horizontalSpacing;
        label.setLayoutData((Object)data);
        super.createButtonsForButtonBar(parent);
    }

    public void valuesModified() {
        if (this.fApplyButton != null && !this.fApplyButton.isDisposed()) {
            this.fApplyButton.setEnabled(this.hasChanges());
        }
    }

    private boolean hasChanges() {
        for (Object key : this.fAllPreferenceSettings.keySet()) {
            ProfileManager.PreferenceSettingValue settingValue = (ProfileManager.PreferenceSettingValue)this.fAllPreferenceSettings.get(key);
            if (!settingValue.hasSettingValueChanged()) continue;
            return true;
        }
        return false;
    }
}

