/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.editor;

import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class HTMLPrinter {
    private static RGB BG_COLOR_RGB;

    static {
        block3: {
            BG_COLOR_RGB = null;
            final Display display = Display.getDefault();
            if (display != null && !display.isDisposed()) {
                try {
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            BG_COLOR_RGB = display.getSystemColor(29).getRGB();
                        }
                    });
                }
                catch (SWTError err) {
                    if (err.code == 45) break block3;
                    throw err;
                }
            }
        }
    }

    private HTMLPrinter() {
    }

    private static String replace(String text, char c, String s) {
        int previous = 0;
        int current = text.indexOf(c, previous);
        if (current == -1) {
            return text;
        }
        StringBuffer buffer = new StringBuffer();
        while (current > -1) {
            buffer.append(text.substring(previous, current));
            buffer.append(s);
            previous = current + 1;
            current = text.indexOf(c, previous);
        }
        buffer.append(text.substring(previous));
        return buffer.toString();
    }

    public static String convertToHTMLContent(String content) {
        content = HTMLPrinter.replace(content, '&', "&amp;");
        content = HTMLPrinter.replace(content, '\"', "&quot;");
        content = HTMLPrinter.replace(content, '<', "&lt;");
        return HTMLPrinter.replace(content, '>', "&gt;");
    }

    public static String read(Reader rd) {
        StringBuffer buffer = new StringBuffer();
        char[] readBuffer = new char[2048];
        try {
            int n = rd.read(readBuffer);
            while (n > 0) {
                buffer.append(readBuffer, 0, n);
                n = rd.read(readBuffer);
            }
            return buffer.toString();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static void insertPageProlog(StringBuffer buffer, int position, RGB bgRGB, URL styleSheetURL) {
        if (bgRGB == null) {
            HTMLPrinter.insertPageProlog(buffer, position, styleSheetURL);
        } else {
            StringBuffer pageProlog = new StringBuffer(300);
            pageProlog.append("<html>");
            HTMLPrinter.appendStyleSheetURL(pageProlog, styleSheetURL);
            pageProlog.append("<body text=\"#000000\" bgcolor=\"");
            HTMLPrinter.appendColor(pageProlog, bgRGB);
            pageProlog.append("\"><font size=-1>");
            buffer.insert(position, pageProlog.toString());
        }
    }

    public static void insertPageProlog(StringBuffer buffer, int position, RGB bgRGB, String styleSheet) {
        if (bgRGB == null) {
            HTMLPrinter.insertPageProlog(buffer, position, styleSheet);
        } else {
            StringBuffer pageProlog = new StringBuffer(300);
            pageProlog.append("<html>");
            HTMLPrinter.appendStyleSheetURL(pageProlog, styleSheet);
            pageProlog.append("<body text=\"#000000\" bgcolor=\"");
            HTMLPrinter.appendColor(pageProlog, bgRGB);
            pageProlog.append("\">");
            buffer.insert(position, pageProlog.toString());
        }
    }

    public static void insertStyles(StringBuffer buffer, String[] styles) {
        if (styles == null || styles.length == 0) {
            return;
        }
        StringBuffer styleBuf = new StringBuffer(10 * styles.length);
        int i = 0;
        while (styles != null && i < styles.length) {
            styleBuf.append(" style=\"");
            styleBuf.append(styles[i]);
            styleBuf.append('\"');
            ++i;
        }
        int index = buffer.indexOf("<body ");
        if (index == -1) {
            return;
        }
        buffer.insert(index + 5, styleBuf);
    }

    public static void insertPageProlog(StringBuffer buffer, int position, RGB bgRGB) {
        if (bgRGB == null) {
            HTMLPrinter.insertPageProlog(buffer, position);
        } else {
            StringBuffer pageProlog = new StringBuffer(60);
            pageProlog.append("<html><body text=\"#000000\" bgcolor=\"");
            HTMLPrinter.appendColor(pageProlog, bgRGB);
            pageProlog.append("\"><font size=-1>");
            buffer.insert(position, pageProlog.toString());
        }
    }

    private static void appendStyleSheetURL(StringBuffer buffer, String styleSheet) {
        if (styleSheet == null) {
            return;
        }
        buffer.append("<head><style CHARSET=\"ISO-8859-1\" TYPE=\"text/css\">");
        buffer.append(styleSheet);
        buffer.append("</style></head>");
    }

    private static void appendStyleSheetURL(StringBuffer buffer, URL styleSheetURL) {
        if (styleSheetURL == null) {
            return;
        }
        buffer.append("<head>");
        buffer.append("<LINK REL=\"stylesheet\" HREF= \"");
        buffer.append(styleSheetURL);
        buffer.append("\" CHARSET=\"ISO-8859-1\" TYPE=\"text/css\">");
        buffer.append("</head>");
    }

    private static void appendColor(StringBuffer buffer, RGB rgb) {
        buffer.append('#');
        buffer.append(Integer.toHexString(rgb.red));
        buffer.append(Integer.toHexString(rgb.green));
        buffer.append(Integer.toHexString(rgb.blue));
    }

    public static void insertPageProlog(StringBuffer buffer, int position) {
        HTMLPrinter.insertPageProlog(buffer, position, HTMLPrinter.getBgColor());
    }

    public static void insertPageProlog(StringBuffer buffer, int position, URL styleSheetURL) {
        HTMLPrinter.insertPageProlog(buffer, position, HTMLPrinter.getBgColor(), styleSheetURL);
    }

    public static void insertPageProlog(StringBuffer buffer, int position, String styleSheet) {
        HTMLPrinter.insertPageProlog(buffer, position, HTMLPrinter.getBgColor(), styleSheet);
    }

    private static RGB getBgColor() {
        if (BG_COLOR_RGB != null) {
            return BG_COLOR_RGB;
        }
        return new RGB(255, 255, 225);
    }

    public static void addPageProlog(StringBuffer buffer) {
        HTMLPrinter.insertPageProlog(buffer, buffer.length());
    }

    public static void addPageEpilog(StringBuffer buffer) {
        buffer.append("</font></body></html>");
    }

    public static void startBulletList(StringBuffer buffer) {
        buffer.append("<ul>");
    }

    public static void endBulletList(StringBuffer buffer) {
        buffer.append("</ul>");
    }

    public static void addBullet(StringBuffer buffer, String bullet) {
        if (bullet != null) {
            buffer.append("<li>");
            buffer.append(bullet);
            buffer.append("</li>");
        }
    }

    public static void addSmallHeader(StringBuffer buffer, String header) {
        if (header != null) {
            buffer.append("<h5>");
            buffer.append(header);
            buffer.append("</h5>");
        }
    }

    public static void addParagraph(StringBuffer buffer, String paragraph) {
        if (paragraph != null) {
            buffer.append("<p>");
            buffer.append(paragraph);
        }
    }

    public static void addParagraph(StringBuffer buffer, Reader paragraphReader) {
        if (paragraphReader != null) {
            HTMLPrinter.addParagraph(buffer, HTMLPrinter.read(paragraphReader));
        }
    }
}

