/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.deployment.ui.project.artifacts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.edt.compiler.internal.eglar.EglarFile;
import org.eclipse.edt.compiler.internal.eglar.EglarFileCache;
import org.eclipse.edt.compiler.internal.eglar.EglarManifest;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.utils.EGLProjectInfoUtility;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.deployment.ui.DeploymentUtilities;
import org.eclipse.edt.ide.ui.internal.deployment.ui.SOAMessages;
import org.eclipse.edt.ide.ui.internal.deployment.ui.project.artifacts.TreeNode;
import org.eclipse.edt.ide.ui.internal.deployment.ui.project.artifacts.TreeNodeFolder;
import org.eclipse.edt.ide.ui.internal.deployment.ui.project.artifacts.TreeNodeJavaScriptFolder;
import org.eclipse.edt.ide.ui.internal.deployment.ui.project.artifacts.TreeNodeJavaSourceFolder;

public class TreeNodeProject
extends TreeNodeFolder {
    private static final String WEB_CONTENT = "WebContent";

    public TreeNodeProject(TreeNode parent, IResource resource) {
        super(parent, resource);
    }

    @Override
    public boolean hasChildren() {
        return !this.getChildren().isEmpty();
    }

    @Override
    protected void generateChildren() {
        this.children = new ArrayList();
        this.children.addAll(this.generateJavaScriptChildren());
        this.children.addAll(this.generateJavaChildren());
        this.children.addAll(this.generateEglarChildren());
    }

    private List<TreeNodeFolder> generateJavaScriptChildren() {
        ArrayList<IResource> results = new ArrayList<IResource>();
        ArrayList<TreeNodeFolder> children = new ArrayList<TreeNodeFolder>();
        try {
            DeploymentUtilities.findFolder((IProject)this.resource, results, WEB_CONTENT);
            DeploymentUtilities.findFolder((IProject)this.resource, results, EGLProjectInfoUtility.getGeneratedJavaScriptFolder((IProject)((IProject)this.resource)));
        }
        catch (CoreException e) {
            DeploymentUtilities.displayErrorDialog(SOAMessages.TreeNode_0, SOAMessages.TreeNode_1);
            EDTUIPlugin.log(e);
        }
        for (IFolder iFolder : results) {
            TreeNodeJavaScriptFolder node = new TreeNodeJavaScriptFolder(this, (IResource)iFolder);
            node.setDeployable(false);
            children.add(node);
        }
        return children;
    }

    private List<TreeNodeFolder> generateJavaChildren() {
        ArrayList<IResource> results = new ArrayList<IResource>();
        ArrayList<TreeNodeFolder> children = new ArrayList<TreeNodeFolder>();
        try {
            DeploymentUtilities.getJavaSourceFolders((IProject)this.resource, results);
        }
        catch (CoreException e) {
            DeploymentUtilities.displayErrorDialog(SOAMessages.TreeNode_0, SOAMessages.TreeNode_1);
            EDTUIPlugin.log(e);
        }
        for (IFolder iFolder : results) {
            TreeNodeJavaSourceFolder node = new TreeNodeJavaSourceFolder(this, (IResource)iFolder, iFolder.getProjectRelativePath().toString());
            node.setDeployable(false);
            children.add(node);
        }
        return children;
    }

    private List<TreeNodeFolder> generateEglarChildren() {
        new ArrayList();
        ArrayList<TreeNodeFolder> children = new ArrayList<TreeNodeFolder>();
        IEGLProject eglProject = EGLCore.create((IProject)((IProject)this.resource));
        try {
            IEGLPathEntry[] entries = eglProject.getRawEGLPath();
            int j = 0;
            while (j < entries.length) {
                IEGLPathEntry entry = entries[j];
                if (entry.getEntryKind() == 1 && "eglar".equalsIgnoreCase(entry.getPath().getFileExtension())) {
                    EglarFile eglar = null;
                    eglar = entry.getPath().toFile().exists() ? EglarFileCache.instance.getEglarFile(entry.getPath().toFile()) : EglarFileCache.instance.getEglarFile(ResourcesPlugin.getWorkspace().getRoot().findMember(entry.getPath()).getRawLocation().toFile());
                    EglarManifest manifest = eglar.getManifest();
                    if (manifest != null) {
                        eglar.getEntry("WebContent/");
                    }
                }
                ++j;
            }
        }
        catch (Exception e) {
            DeploymentUtilities.displayErrorDialog(SOAMessages.TreeNode_0, SOAMessages.TreeNode_1);
            EDTUIPlugin.log(e);
        }
        return children;
    }
}

