/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.document.utils;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.compiler.core.ast.ArrayLiteral;
import org.eclipse.edt.compiler.core.ast.Assignment;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.Handler;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.ide.core.ast.rewrite.ASTRewrite;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.rui.document.utils.SettingsBlockLocator;
import org.eclipse.edt.ide.rui.internal.Activator;
import org.eclipse.edt.mof.utils.NameUtile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class EGLRUIHandlerUpdateStrategy {
    private File fileAST;
    private boolean foundInitialUI = false;
    private IEGLDocument currentDocument;
    private Handler handler;
    private int theCharactersAdded = 0;

    public EGLRUIHandlerUpdateStrategy(Handler handler, IEGLDocument document) {
        this.currentDocument = document;
        this.fileAST = this.currentDocument.getNewModelEGLFile();
        this.handler = handler;
    }

    public int updateHandler(final String insertText, final int index) {
        SettingsBlockLocator locator = new SettingsBlockLocator();
        this.handler.accept((IASTVisitor)locator);
        if (locator.getSettingsBlock() != null) {
            locator.getSettingsBlock().accept((IASTVisitor)new DefaultASTVisitor(){

                public boolean visit(SettingsBlock settingsBlock) {
                    return true;
                }

                public void endVisit(SettingsBlock settingsBlock) {
                    if (!EGLRUIHandlerUpdateStrategy.this.foundInitialUI) {
                        try {
                            ASTRewrite rewrite = ASTRewrite.create((File)EGLRUIHandlerUpdateStrategy.this.fileAST);
                            String childrenString = "{ initialUI = [ " + insertText + " ] }";
                            rewrite.setText((Node)settingsBlock, childrenString);
                            rewrite.rewriteAST((IDocument)EGLRUIHandlerUpdateStrategy.this.currentDocument).apply((IDocument)EGLRUIHandlerUpdateStrategy.this.currentDocument);
                            EGLRUIHandlerUpdateStrategy.this.theCharactersAdded = childrenString.length();
                        }
                        catch (BadLocationException e) {
                            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Handler Update: Error creating initialUI field", (Throwable)e));
                        }
                    }
                }

                public boolean visit(final Assignment assignment) {
                    try {
                        if (assignment.getLeftHandSide().isName() && NameUtile.equals((String)NameUtile.getAsName((String)"initialUI"), (String)((Name)assignment.getLeftHandSide()).getIdentifier())) {
                            EGLRUIHandlerUpdateStrategy.this.foundInitialUI = true;
                            assignment.getRightHandSide().accept((IASTVisitor)new DefaultASTVisitor(){

                                public boolean visit(ArrayLiteral array) {
                                    try {
                                        if (array.getExpressions().size() == 0) {
                                            String childrenString = "initialUI = [ " + insertText + " ]";
                                            ASTRewrite rewrite = ASTRewrite.create((File)EGLRUIHandlerUpdateStrategy.this.fileAST);
                                            rewrite.setText((Node)assignment, childrenString);
                                            rewrite.rewriteAST((IDocument)EGLRUIHandlerUpdateStrategy.this.currentDocument).apply((IDocument)EGLRUIHandlerUpdateStrategy.this.currentDocument);
                                            EGLRUIHandlerUpdateStrategy.this.theCharactersAdded = childrenString.length();
                                        } else {
                                            String nodeText;
                                            Node insertNode;
                                            if (index < array.getExpressions().size()) {
                                                insertNode = (Node)array.getExpressions().get(index);
                                                nodeText = EGLRUIHandlerUpdateStrategy.this.currentDocument.get(insertNode.getOffset(), insertNode.getLength());
                                                nodeText = String.valueOf(insertText) + ", " + nodeText;
                                            } else {
                                                insertNode = (Node)array.getExpressions().get(index - 1);
                                                nodeText = EGLRUIHandlerUpdateStrategy.this.currentDocument.get(insertNode.getOffset(), insertNode.getLength());
                                                nodeText = String.valueOf(nodeText) + ", " + insertText;
                                            }
                                            ASTRewrite rewrite = ASTRewrite.create((File)EGLRUIHandlerUpdateStrategy.this.fileAST);
                                            rewrite.setText(insertNode, nodeText);
                                            rewrite.rewriteAST((IDocument)EGLRUIHandlerUpdateStrategy.this.currentDocument).apply((IDocument)EGLRUIHandlerUpdateStrategy.this.currentDocument);
                                            EGLRUIHandlerUpdateStrategy.this.theCharactersAdded = nodeText.length();
                                        }
                                    }
                                    catch (BadLocationException e) {
                                        Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Handler Update: Error updating initialUI field", (Throwable)e));
                                    }
                                    return false;
                                }
                            });
                        }
                    }
                    catch (Exception e) {
                        Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Handler Update: Error updating initialUI field", (Throwable)e));
                    }
                    return false;
                }
            });
        } else {
            try {
                ASTRewrite rewrite = ASTRewrite.create((File)this.fileAST);
                String subTypeText = this.currentDocument.get(this.handler.getSubType().getOffset(), this.handler.getSubType().getLength());
                String childrenString = String.valueOf(subTypeText) + " { initialUI = [ " + insertText + " ] } ";
                rewrite.setText((Node)this.handler.getSubType(), childrenString);
                rewrite.rewriteAST((IDocument)this.currentDocument).apply((IDocument)this.currentDocument);
                this.theCharactersAdded = childrenString.length();
            }
            catch (BadLocationException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Handler Update: Error creating settings block", (Throwable)e));
            }
        }
        return this.theCharactersAdded;
    }
}

