/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.internal.core.java;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceLookupParticipant;
import org.eclipse.edt.debug.core.java.IEGLJavaDebugElement;
import org.eclipse.edt.debug.core.java.IEGLJavaStackFrame;
import org.eclipse.edt.debug.internal.core.java.EGLJavaSourceLookupParticipant;

public class EGLJavaSourceLookupDirector
extends AbstractSourceLookupDirector {
    private final ISourceLocator originalLocator;
    private final ISourceLookupDirector originalDirector;

    public EGLJavaSourceLookupDirector() {
        this(null);
    }

    public EGLJavaSourceLookupDirector(ISourceLocator locator) {
        this.originalLocator = locator;
        this.originalDirector = locator instanceof ISourceLookupDirector ? (ISourceLookupDirector)locator : null;
    }

    public void initializeParticipants() {
        this.addParticipants(new ISourceLookupParticipant[]{new EGLJavaSourceLookupParticipant()});
        if (this.originalDirector != null) {
            this.originalDirector.initializeParticipants();
        }
    }

    public Object getSourceElement(IStackFrame stackFrame) {
        Object element = super.getSourceElement(stackFrame);
        if (element != null) {
            return element;
        }
        if (this.originalLocator != null) {
            if (stackFrame instanceof IEGLJavaStackFrame) {
                stackFrame = ((IEGLJavaStackFrame)stackFrame).getJavaStackFrame();
            }
            return this.originalLocator.getSourceElement(stackFrame);
        }
        return null;
    }

    public Object getSourceElement(Object element) {
        Object result = super.getSourceElement(element);
        if (result != null) {
            return result;
        }
        if (this.originalDirector != null) {
            if (element instanceof IEGLJavaDebugElement) {
                element = ((IEGLJavaDebugElement)element).getJavaDebugElement();
            }
            return this.originalDirector.getSourceElement(element);
        }
        return null;
    }

    public Object[] findSourceElements(Object object) throws CoreException {
        Object[] elements = super.findSourceElements(object);
        if (elements.length > 0) {
            return elements;
        }
        if (this.originalDirector != null) {
            if (object instanceof IEGLJavaDebugElement) {
                object = ((IEGLJavaDebugElement)object).getJavaDebugElement();
            }
            return this.originalDirector.findSourceElements(object);
        }
        return new Object[0];
    }

    public boolean isFindDuplicates() {
        return super.isFindDuplicates() || this.originalDirector != null && this.originalDirector.isFindDuplicates();
    }

    public boolean supportsSourceContainerType(ISourceContainerType type) {
        return type.getId().equals("org.eclipse.edt.debug.core.sourceContainer.packageFragmentRoot") || !(this.originalDirector == null ? !super.supportsSourceContainerType(type) : !this.originalDirector.supportsSourceContainerType(type));
    }

    public void initializeDefaults(ILaunchConfiguration configuration) throws CoreException {
        super.initializeDefaults(configuration);
        if (this.originalDirector != null) {
            this.originalDirector.initializeDefaults(configuration);
        }
    }

    public void initializeFromMemento(String memento) throws CoreException {
        super.initializeFromMemento(memento);
        if (this.originalDirector != null) {
            this.originalDirector.initializeFromMemento(memento);
        }
    }

    public void initializeFromMemento(String memento, ILaunchConfiguration configuration) throws CoreException {
        super.initializeFromMemento(memento, configuration);
        if (this.originalDirector != null) {
            this.originalDirector.initializeFromMemento(memento, configuration);
        }
    }

    public void clearSourceElements(Object element) {
        super.clearSourceElements(element);
        if (this.originalDirector != null) {
            if (element instanceof IEGLJavaDebugElement) {
                element = ((IEGLJavaDebugElement)element).getJavaDebugElement();
            }
            this.originalDirector.clearSourceElements(element);
        }
    }

    public synchronized void dispose() {
        super.dispose();
        if (this.originalDirector != null) {
            this.originalDirector.dispose();
        }
    }
}

