/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.core.java;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;
import org.eclipse.debug.core.sourcelookup.containers.ZipEntryStorage;
import org.eclipse.edt.debug.core.EDTDebugCorePlugin;
import org.eclipse.edt.debug.core.java.IEGLJavaDebugTarget;
import org.eclipse.edt.debug.core.java.IEGLJavaStackFrame;
import org.eclipse.edt.debug.core.java.SMAPFileCache;
import org.eclipse.edt.debug.core.java.SMAPFunctionInfo;
import org.eclipse.edt.debug.core.java.SMAPLineInfo;
import org.eclipse.edt.debug.core.java.SMAPVariableInfo;
import org.eclipse.edt.debug.internal.core.java.SMAPLineParser;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.debug.core.IJavaReferenceType;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.core.model.JDIReferenceType;

public class SMAPUtil {
    private static final SMAPVariableInfo[] EMPTY_VARIABLE_INFOS = new SMAPVariableInfo[0];

    private SMAPUtil() {
    }

    public static SMAPVariableInfo[] parseVariables(String smap, IEGLJavaStackFrame frame) {
        if (smap == null || smap.trim().length() == 0) {
            return EMPTY_VARIABLE_INFOS;
        }
        ArrayList<SMAPVariableInfo> vars = new ArrayList<SMAPVariableInfo>();
        int idx = smap.indexOf("*E");
        if (idx != -1) {
            String variableSection = smap.substring(idx + 2).trim();
            StringTokenizer tok = new StringTokenizer(variableSection, "\n");
            String javaFrameSignature = null;
            if (frame != null) {
                try {
                    javaFrameSignature = String.valueOf(frame.getJavaStackFrame().getMethodName()) + ";" + frame.getJavaStackFrame().getSignature();
                }
                catch (DebugException debugException) {}
            }
            String currentFunction = null;
            while (tok.hasMoreTokens()) {
                String next = tok.nextToken().trim();
                int tokenLen = next.length();
                if (tokenLen == 0) continue;
                if ("*X".equals(next)) break;
                boolean specialGlobalType = next.charAt(0) == '*';
                try {
                    String eglName;
                    StringTokenizer semiTok;
                    int semicolon;
                    int line;
                    if (specialGlobalType) {
                        line = -1;
                        semicolon = next.indexOf(59);
                    } else {
                        int pound = next.indexOf(35);
                        if (pound == -1) continue;
                        line = Integer.parseInt(next.substring(0, pound));
                        semicolon = next.indexOf(59, pound);
                    }
                    if (semicolon == -1) continue;
                    if (specialGlobalType) {
                        semiTok = new StringTokenizer(next.substring(semicolon + 1), ";");
                        int tokenCount = semiTok.countTokens();
                        if (tokenCount <= 0) continue;
                        eglName = semiTok.nextToken();
                        String javaName = tokenCount > 1 ? semiTok.nextToken() : eglName;
                        String type = tokenCount > 2 ? semiTok.nextToken() : eglName;
                        vars.add(new SMAPVariableInfo(eglName, javaName, type, line, next));
                        continue;
                    }
                    if (tokenLen > semicolon + 2 && next.charAt(semicolon + 1) == 'F' && next.charAt(semicolon + 2) == ':') {
                        int semicolon2 = next.indexOf(59, semicolon + 1);
                        if (semicolon2 == -1) continue;
                        eglName = next.substring(semicolon + 3, semicolon2);
                        currentFunction = next.substring(semicolon2 + 1);
                        if (frame == null || currentFunction == null || !currentFunction.equals(javaFrameSignature)) continue;
                        frame.setSMAPFunctionInfo(new SMAPFunctionInfo(eglName, currentFunction, line, next));
                        continue;
                    }
                    semiTok = new StringTokenizer(next.substring(semicolon + 1), ";");
                    if (semiTok.countTokens() != 3) continue;
                    vars.add(new SMAPVariableInfo(semiTok.nextToken(), semiTok.nextToken(), semiTok.nextToken(), line, currentFunction, next));
                }
                catch (NumberFormatException nfe) {
                    EDTDebugCorePlugin.log(nfe);
                }
            }
        }
        return vars.toArray(new SMAPVariableInfo[vars.size()]);
    }

    public static String getSMAP(IEGLJavaDebugTarget target, IJavaType type) {
        String smap = null;
        if (type instanceof IJavaReferenceType) {
            Type underlyingType;
            if (target.supportsSourceDebugExtension() && type instanceof JDIReferenceType && (underlyingType = ((JDIReferenceType)type).getUnderlyingType()) instanceof ReferenceType) {
                try {
                    smap = ((ReferenceType)underlyingType).sourceDebugExtension();
                }
                catch (AbsentInformationException absentInformationException) {
                }
                catch (UnsupportedOperationException unsupportedOperationException) {}
            }
            if (smap == null) {
                try {
                    smap = SMAPUtil.getSMAP(target, ((IJavaReferenceType)type).getName());
                }
                catch (Throwable throwable) {}
            }
        }
        return smap == null ? "" : smap.trim();
    }

    public static String getSMAP(IEGLJavaDebugTarget target, String className) {
        SMAPFileCache smapFileCache = target.getSMAPFileCache();
        if (smapFileCache == null) {
            return "";
        }
        String smap = null;
        if (smapFileCache.containsSMAP(className)) {
            smap = smapFileCache.getSMAP(className);
        } else {
            String workspacePath;
            block40: {
                int inner = className.indexOf(36);
                if (inner != -1) {
                    className = className.substring(0, inner);
                }
                workspacePath = null;
                ISourceLocator locator = target.getLaunch().getSourceLocator();
                if (locator instanceof ISourceLookupDirector) {
                    File smapFile;
                    IPath smapPath;
                    InputStream is = null;
                    Object src = ((ISourceLookupDirector)locator).getSourceElement((Object)(String.valueOf(className.replace('.', '/')) + ".java"));
                    if (src instanceof IJavaElement) {
                        IJavaElement parent = ((IJavaElement)src).getParent();
                        if (parent instanceof IPackageFragment) {
                            int lastDot = className.lastIndexOf(46);
                            String simpleSMAPName = lastDot == -1 ? String.valueOf(className) + "." + "eglsmap" : String.valueOf(className.substring(lastDot + 1)) + "." + "eglsmap";
                            try {
                                Object[] kids;
                                Object[] objectArray = kids = ((IPackageFragment)parent).getNonJavaResources();
                                int n = kids.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    Object kid = objectArray[n2];
                                    if (kid instanceof IStorage && ((IStorage)kid).getName().equals(simpleSMAPName)) {
                                        is = ((IStorage)kid).getContents();
                                        workspacePath = ((IStorage)kid).getFullPath().toString();
                                        break;
                                    }
                                    ++n2;
                                }
                            }
                            catch (CoreException ce) {
                                EDTDebugCorePlugin.log(ce);
                            }
                        }
                    } else if (src instanceof ZipEntryStorage) {
                        ZipEntryStorage storage = (ZipEntryStorage)src;
                        ZipFile zipFile = storage.getArchive();
                        ZipEntry zipEntry = storage.getZipEntry();
                        String name = zipEntry.getName();
                        if (name.endsWith(".java") && (zipEntry = zipFile.getEntry(String.valueOf(name.substring(0, name.length() - 4)) + "eglsmap")) != null) {
                            try {
                                is = zipFile.getInputStream(zipEntry);
                            }
                            catch (IOException ioe) {
                                EDTDebugCorePlugin.log(ioe);
                            }
                        }
                    } else if (src instanceof LocalFileStorage) {
                        smapPath = ((IStorage)src).getFullPath().removeFileExtension().addFileExtension("eglsmap");
                        smapFile = smapPath.toFile();
                        if (smapFile.exists()) {
                            try {
                                is = new FileInputStream(smapFile);
                                IPath workspaceRoot = ResourcesPlugin.getWorkspace().getRoot().getLocation();
                                if (workspaceRoot.isPrefixOf(smapPath)) {
                                    workspacePath = "/" + smapPath.removeFirstSegments(workspaceRoot.segmentCount()).toString();
                                }
                            }
                            catch (FileNotFoundException fnfe) {
                                EDTDebugCorePlugin.log(fnfe);
                            }
                        }
                    } else if (src instanceof IStorage) {
                        smapPath = ((IStorage)src).getFullPath().removeFileExtension().addFileExtension("eglsmap");
                        smapFile = ResourcesPlugin.getWorkspace().getRoot().getFile(smapPath);
                        if (smapFile.exists()) {
                            try {
                                is = smapFile.getContents(true);
                                workspacePath = smapPath.toString();
                            }
                            catch (CoreException ce) {
                                EDTDebugCorePlugin.log(ce);
                            }
                        }
                    }
                    if (is != null) {
                        try {
                            try {
                                BufferedInputStream bis = new BufferedInputStream(is);
                                byte[] b = new byte[bis.available()];
                                bis.read(b, 0, b.length);
                                smap = new String(b, "UTF-8");
                            }
                            catch (Exception e) {
                                EDTDebugCorePlugin.log(e);
                                try {
                                    is.close();
                                }
                                catch (IOException iOException) {}
                                break block40;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                is.close();
                            }
                            catch (IOException iOException) {}
                            throw throwable;
                        }
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            smapFileCache.addEntry(className, smap, workspacePath);
        }
        return smap == null ? "" : smap;
    }

    public static boolean isEGLStratum(IJavaValue value) {
        try {
            IJavaType type = value.getJavaType();
            return type instanceof IJavaReferenceType && "egl".equals(((IJavaReferenceType)type).getDefaultStratum());
        }
        catch (DebugException debugException) {
            return false;
        }
    }

    public static boolean isEGLStratum(IJavaVariable variable) {
        try {
            IJavaType type = variable.getJavaType();
            return type instanceof IJavaReferenceType && "egl".equals(((IJavaReferenceType)type).getDefaultStratum());
        }
        catch (DebugException debugException) {
            return false;
        }
    }

    public static boolean isEGLStratum(IJavaStackFrame frame, IEGLJavaDebugTarget target) {
        if (target.supportsSourceDebugExtension()) {
            try {
                IJavaReferenceType refType = frame.getReferenceType();
                return refType != null && "egl".equals(refType.getDefaultStratum());
            }
            catch (DebugException debugException) {}
        } else {
            try {
                String smap = SMAPUtil.getSMAP(target, frame.getReferenceType().getName());
                return SMAPUtil.isEGLStratum(smap);
            }
            catch (DebugException debugException) {}
        }
        return false;
    }

    public static boolean isEGLStratum(String smap) {
        int end;
        int index;
        if (smap.length() > 0 && (index = smap.indexOf(10)) != -1 && (index = smap.indexOf(10, index + 1)) != -1 && (end = smap.indexOf(10, index + 1)) != -1) {
            return "egl".equals(smap.substring(index + 1, end));
        }
        return false;
    }

    public static String getFilePath(String smap) {
        int index;
        if (smap.length() > 0 && (index = smap.indexOf("*F")) != -1 && (index = smap.indexOf(10, index)) != -1) {
            int end;
            if (smap.charAt(index + 1) == '+') {
                int end2;
                if ((index = smap.indexOf(10, index + 1)) != -1 && (end2 = smap.indexOf(10, index + 1)) != -1) {
                    return smap.substring(index + 1, end2);
                }
            } else if ((index = smap.indexOf(32, index + 1)) != -1 && (end = smap.indexOf(10, index + 1)) != -1) {
                return smap.substring(index + 1, end).trim();
            }
        }
        return null;
    }

    public static String getFileName(String smap) {
        String path = SMAPUtil.getFilePath(smap);
        if (path != null) {
            int index = path.lastIndexOf(47);
            if (index == -1) {
                return path;
            }
            return path.substring(index + 1);
        }
        return null;
    }

    public static SMAPLineInfo getSMAPLineInfo(String smap, Map<String, SMAPLineInfo> lineMappingCache) {
        if (lineMappingCache != null && smap.length() > 0) {
            SMAPLineInfo info;
            if (!lineMappingCache.containsKey(smap)) {
                info = SMAPLineParser.parse(smap);
                lineMappingCache.put(smap, info);
            } else {
                info = lineMappingCache.get(smap);
            }
            return info;
        }
        return null;
    }
}

