/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.eunit.internal.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.edt.gen.eunit.IEUnitGenerationNotifier;

public class EUnitGenerationNotifier
implements IEUnitGenerationNotifier {
    private IProgressMonitor monitor;
    protected int workDone;
    protected int totalWork;
    protected String previousSubtask;
    protected float percentComplete;

    public EUnitGenerationNotifier(IProgressMonitor monitor) {
        this(monitor, 1000000);
    }

    public EUnitGenerationNotifier(IProgressMonitor monitor, int totalWork) {
        this.monitor = monitor;
        this.workDone = 0;
        this.totalWork = totalWork;
    }

    public boolean isAborted() {
        if (this.monitor != null) {
            return this.monitor.isCanceled();
        }
        return false;
    }

    public void setAborted(boolean aborted) {
        if (this.monitor != null) {
            this.monitor.setCanceled(aborted);
        }
    }

    public void begin() {
        if (this.monitor != null) {
            this.monitor.beginTask("", this.totalWork);
        }
        this.previousSubtask = null;
    }

    public void begin(int totalWork) {
        this.totalWork = totalWork;
        this.begin();
    }

    public void done() {
        if (this.monitor != null) {
            this.monitor.done();
        }
    }

    public void setTaskName(String message) {
        this.monitor.setTaskName(message);
    }

    public void updateProgress(int workCount) {
        this.monitor.worked(workCount);
    }
}

