/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.java;

import java.io.IOException;
import java.util.Map;
import org.eclipse.edt.compiler.internal.interfaces.IGenerationMessageRequestor;
import org.eclipse.edt.compiler.internal.util.IGenerationResultsMessage;
import org.eclipse.edt.gen.AbstractGeneratorCommand;
import org.eclipse.edt.gen.CommonUtilities;
import org.eclipse.edt.gen.EGLMessages.EGLMessage;
import org.eclipse.edt.gen.EglContext;
import org.eclipse.edt.gen.GenerationException;
import org.eclipse.edt.gen.Generator;
import org.eclipse.edt.gen.java.Context;
import org.eclipse.edt.javart.util.JavaAliaser;
import org.eclipse.edt.mof.codegen.api.TabbedReportWriter;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;
import org.eclipse.edt.mof.codegen.api.TemplateException;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.Type;

public class JavaCoreGenerator
extends Generator {
    protected Context context;
    protected TabbedWriter out;
    protected AbstractGeneratorCommand generator;

    public JavaCoreGenerator(AbstractGeneratorCommand processor) {
        this(processor, null);
    }

    public JavaCoreGenerator(AbstractGeneratorCommand processor, IGenerationMessageRequestor requestor) {
        super(processor, requestor);
        this.generator = processor;
    }

    public String getResult() {
        if (this.out == null) {
            return "";
        }
        return this.out.getWriter().toString();
    }

    public TabbedReportWriter getReport() {
        return this.out instanceof TabbedReportWriter ? (TabbedReportWriter)this.out : null;
    }

    public Context makeContext(AbstractGeneratorCommand processor) {
        this.context = new Context(processor);
        return this.context;
    }

    public void generate(Object part) throws GenerationException {
        this.makeWriter();
        if (!this.verifyPartSupported(part, "Java")) {
            return;
        }
        try {
            this.context.putAttribute(((Object)((Object)this.context)).getClass(), "partBeingGenerated", part);
            this.context.invoke("preGenPart", part, new Object[]{this.context});
            if (!this.context.getMessageRequestor().isError()) {
                String fileName;
                this.out.getWriter().flush();
                boolean autoIndent = this.out.getAutoIndent();
                this.out.setAutoIndent(false);
                if (this.getHeader() != null && this.getHeader().length() > 0) {
                    this.out.println(this.getHeader());
                }
                this.out.setAutoIndent(autoIndent);
                String eglFileName = ((Part)part).getFileName();
                if (eglFileName.indexOf(92) >= 0) {
                    eglFileName = eglFileName.substring(eglFileName.lastIndexOf(92) + 1);
                }
                if (eglFileName.indexOf(47) >= 0) {
                    eglFileName = eglFileName.substring(eglFileName.lastIndexOf(47) + 1);
                }
                if ((fileName = eglFileName).indexOf(46) >= 0) {
                    fileName = fileName.substring(0, fileName.lastIndexOf(46));
                }
                this.context.getSmapData().append(String.valueOf(JavaAliaser.getAlias((String)fileName)) + this.getFileExtension() + "\negl\n*S egl\n*F\n");
                this.context.getSmapData().append("*L\n");
                this.context.invoke("genPart", part, new Object[]{this.context, this.out});
                this.context.writeSmapLine();
                int index = 0;
                String fileList = "";
                for (String eglFile : this.context.getSmapFiles()) {
                    fileList = String.valueOf(fileList) + "+ " + ++index + " " + this.unqualifyFileName(eglFile) + "\n" + eglFile + "\n";
                }
                this.context.getSmapData().insert(this.context.getSmapData().indexOf("\negl\n*S egl\n*F\n") + "\negl\n*S egl\n*F\n".length(), fileList);
                this.context.getSmapData().append("*E\n");
                this.context.getSmapData().append(this.context.getSmapExtension());
                this.context.getSmapData().append("*X\n");
                this.out.flush();
            }
        }
        catch (IOException e) {
            throw new GenerationException((Throwable)e);
        }
        catch (TemplateException e) {
            Annotation locAnn = this.context.getLastStatementLocation();
            String partName = "";
            if (part instanceof Part) {
                partName = ((Part)part).getCaseSensitiveName();
                if (locAnn == null) {
                    locAnn = ((Part)part).getAnnotation("EGL_Location");
                }
            }
            String[] details1 = new String[]{partName, e.getLocalizedMessage()};
            EGLMessage message1 = EGLMessage.createEGLMessage((Map)this.context.getMessageMapping(), (int)1, (String)"9998", (Object)((Object)e), (String[])details1, (Annotation)CommonUtilities.includeEndOffset((Annotation)locAnn, (EglContext)this.context));
            this.context.getMessageRequestor().addMessage((IGenerationResultsMessage)message1);
            if (e.getCause() != null) {
                String[] details2 = new String[]{e.getCause().toString()};
                EGLMessage message2 = EGLMessage.createEGLStackTraceMessage((Map)this.context.getMessageMapping(), (int)1, (String)"9999", (Throwable)e, (String[])details2, (Annotation)CommonUtilities.includeEndOffset((Annotation)locAnn, (EglContext)this.context));
                this.context.getMessageRequestor().addMessage((IGenerationResultsMessage)message2);
            }
            int startLine = 0;
            Annotation annotation = locAnn;
            if (annotation != null && annotation.getValue("line") != null) {
                startLine = (Integer)annotation.getValue("line");
            }
            System.err.println("generating:" + ((Part)part).getFullyQualifiedName() + "[" + ((Part)part).getFileName() + "]:(" + startLine + ")");
            e.printStackTrace();
        }
        this.out.close();
    }

    private void makeWriter() {
        if (this.out == null) {
            this.out = this.context.getTabbedWriter();
        }
    }

    private String unqualifyFileName(String fileName) {
        int lastSlash = fileName.lastIndexOf(47);
        if (lastSlash != -1) {
            return fileName.substring(lastSlash + 1);
        }
        return fileName;
    }

    public void dumpErrorMessages() {
        for (IGenerationResultsMessage message : this.context.getMessageRequestor().getMessages()) {
            System.out.println(message.getBuiltMessage());
        }
    }

    public void processFile(String fileName) {
        JavaCoreGenerator.writeReport((EglContext)this.context, (String)fileName, (TabbedReportWriter)this.getReport(), (String)"8000", (String)"9992");
    }

    public String getRelativeFileName(Part part) {
        if (this.context == null) {
            this.makeContext(this.generator);
        }
        StringBuilder buf = new StringBuilder(50);
        if (this.context.mapsToNativeType((Type)part)) {
            String name = this.context.getRawNativeImplementationMapping((Type)part);
            int lastDot = name.lastIndexOf(46);
            if (lastDot != -1) {
                buf.append(JavaAliaser.packageNameAlias((String[])name.substring(0, lastDot).split("[.]"), (char)'/'));
                buf.append('/');
                buf.append(JavaAliaser.getAlias((String)name.substring(lastDot + 1)));
            } else {
                buf.append(JavaAliaser.getAlias((String)name));
            }
        } else {
            String pkg = part.getCaseSensitivePackageName();
            if (pkg.length() > 0) {
                buf.append(JavaAliaser.packageNameAlias((String[])pkg.split("[.]"), (char)'/'));
                buf.append('/');
            }
            buf.append(JavaAliaser.getAlias((String)part.getCaseSensitiveName()));
        }
        buf.append(this.getFileExtension());
        return buf.toString();
    }

    public String getFileExtension() {
        return ".java";
    }
}

