/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.deployment.services.operation;

import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.edt.ide.deployment.core.model.DeploymentDesc;
import org.eclipse.edt.ide.deployment.core.model.DeploymentTarget;
import org.eclipse.edt.ide.deployment.internal.web.WebXML;
import org.eclipse.edt.ide.deployment.internal.web.WebXMLManager;
import org.eclipse.edt.ide.deployment.operation.AbstractDeploymentOperation;
import org.eclipse.edt.ide.deployment.results.IDeploymentResultsCollector;
import org.eclipse.edt.ide.deployment.services.internal.nls.Messages;
import org.eclipse.edt.ide.deployment.solution.DeploymentContext;
import org.eclipse.edt.ide.deployment.utilities.DeploymentUtilities;

public class UpdateWebXMLServiceOperation
extends AbstractDeploymentOperation {
    private String targetProjectName;
    private DeploymentDesc model;
    private DeploymentContext context;

    public void execute(DeploymentContext context, IDeploymentResultsCollector resultsCollector, IProgressMonitor monitor) throws CoreException {
        monitor.subTask(Messages.J2EEDeploymentOperation_1);
        this.context = context;
        this.model = context.getDeploymentDesc();
        this.targetProjectName = DeploymentUtilities.getDeploymentTargetId((DeploymentTarget)this.model.getDeploymentTarget(), null, (String)this.model.getName());
        IProject targetProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.targetProjectName);
        this.deployProxy(targetProject);
        WebXMLManager.instance.updateModel(targetProject);
        monitor.worked(1);
    }

    private void deployProxy(IProject project) {
        WebXML util;
        String servletName = "EglRestRpcServlet";
        String servletClassName = "org.eclipse.edt.javart.services.servlet.rest.rpc.ServiceServlet";
        String mapping = "/restservices/*";
        HashMap<String, String> parameterList = new HashMap<String, String>();
        boolean isWebsphere = false;
        if (isWebsphere) {
            parameterList.put("isOnWebSphere", "true");
        }
        if ((util = WebXMLManager.instance.getWebXMLUtil(project)) != null) {
            util.addServlet(servletName, servletClassName, mapping, parameterList);
        }
    }
}

