/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.search;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.ui.internal.search.NameSorter;
import org.eclipse.jface.viewers.Viewer;

public class PathSorter
extends NameSorter {
    @Override
    public int compare(Viewer viewer, Object e1, Object e2) {
        IPath path1 = this.getPath(e1);
        IPath path2 = this.getPath(e2);
        return this.compare(path1, path2);
    }

    private IPath getPath(Object element) {
        if (element instanceof IEGLElement) {
            return ((IEGLElement)element).getPath();
        }
        if (element instanceof IResource) {
            return ((IResource)element).getFullPath();
        }
        return new Path("");
    }

    protected int compare(IPath path1, IPath path2) {
        int segmentCount = Math.min(path1.segmentCount(), path2.segmentCount());
        int i = 0;
        while (i < segmentCount) {
            int value = this.collator.compare(path1.segment(i), path2.segment(i));
            if (value != 0) {
                return value;
            }
            ++i;
        }
        return path1.segmentCount() - path2.segmentCount();
    }
}

