/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.property.pages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLModel;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.PPListElement;
import org.eclipse.edt.ide.core.model.PPListElementAttribute;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.property.pages.BuildPathDialogAccess;
import org.eclipse.edt.ide.ui.internal.property.pages.SourceAttachmentDialog;
import org.eclipse.edt.ide.ui.internal.util.PixelConverter;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.edt.ide.ui.internal.wizards.buildpaths.BuildPathBasePage;
import org.eclipse.edt.ide.ui.internal.wizards.buildpaths.PPListElementSorter;
import org.eclipse.edt.ide.ui.internal.wizards.buildpaths.PPListLabelProvider;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.CheckedListDialogField;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.ITreeListAdapter;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.LayoutUtil;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.ListDialogField;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.TreeListDialogField;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class EGLLibrariesWorkbookPage
extends BuildPathBasePage {
    private final ListDialogField fClassPathList;
    private IEGLProject fCurrProject;
    private final TreeListDialogField fLibrariesList;
    private Control fSWTControl;
    private final int IDX_ADDJAR = 0;
    private final int IDX_ADDEXT = 1;
    private final int IDX_EDIT = 2;
    private final int IDX_REMOVE = 3;

    public EGLLibrariesWorkbookPage(CheckedListDialogField classPathList) {
        this.fClassPathList = classPathList;
        this.fSWTControl = null;
        String[] buttonLabels = new String[]{NewWizardMessages.LibrariesWorkbookPage_libraries_addeglar_button, NewWizardMessages.LibrariesWorkbookPage_libraries_addexteglar_button, NewWizardMessages.LibrariesWorkbookPage_libraries_edit_button, NewWizardMessages.LibrariesWorkbookPage_libraries_remove_button};
        LibrariesAdapter adapter = new LibrariesAdapter();
        this.fLibrariesList = new TreeListDialogField(adapter, buttonLabels, (ILabelProvider)new PPListLabelProvider());
        this.fLibrariesList.setDialogFieldListener(adapter);
        this.fLibrariesList.setLabelText(NewWizardMessages.LibrariesWorkbookPage_libraries_label);
        this.fLibrariesList.enableButton(3, false);
        this.fLibrariesList.enableButton(2, false);
        this.fLibrariesList.setViewerSorter(new PPListElementSorter());
    }

    public void init(IEGLProject project) {
        this.fCurrProject = project;
        if (Display.getCurrent() != null) {
            this.updateLibrariesList();
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    EGLLibrariesWorkbookPage.this.updateLibrariesList();
                }
            });
        }
        this.updateEnabledState();
    }

    private void updateLibrariesList() {
        List elements = this.fClassPathList.getElements();
        ArrayList<PPListElement> libelements = new ArrayList<PPListElement>(elements.size());
        int nElements = elements.size();
        int i = 0;
        while (i < nElements) {
            PPListElement ppe = (PPListElement)elements.get(i);
            if (this.isEntryKind(ppe.getEntryKind())) {
                libelements.add(ppe);
            }
            ++i;
        }
        this.fLibrariesList.setElements(libelements);
    }

    public Control getControl(Composite parent) {
        PixelConverter converter = new PixelConverter((Control)parent);
        Composite composite = new Composite(parent, 0);
        LayoutUtil.doDefaultLayout(composite, new DialogField[]{this.fLibrariesList}, true, -1, -1);
        LayoutUtil.setHorizontalGrabbing(this.fLibrariesList.getTreeControl(null));
        int buttonBarWidth = converter.convertWidthInCharsToPixels(24);
        this.fLibrariesList.setButtonsMinWidth(buttonBarWidth);
        this.fLibrariesList.setViewerSorter(new PPListElementSorter());
        this.fSWTControl = composite;
        return composite;
    }

    private void libaryPageCustomButtonPressed(DialogField field, int index) {
        Object[] libentries = null;
        switch (index) {
            case 0: {
                libentries = this.openJarFileDialog(null);
                break;
            }
            case 1: {
                libentries = this.openExtJarFileDialog(null);
                break;
            }
            case 2: {
                this.editEntry();
                return;
            }
            case 3: {
                this.removeEntry();
                return;
            }
        }
        if (libentries != null) {
            int nElementsChosen = libentries.length;
            List cplist = this.fLibrariesList.getElements();
            ArrayList<PPListElement> elementsToAdd = new ArrayList<PPListElement>(nElementsChosen);
            int i = 0;
            while (i < nElementsChosen) {
                PPListElement curr = libentries[i];
                if (!cplist.contains(curr) && !elementsToAdd.contains(curr)) {
                    elementsToAdd.add(curr);
                    curr.setAttribute("sourcepath", (Object)EGLLibrariesWorkbookPage.guessSourceAttachment(curr));
                }
                ++i;
            }
            this.fLibrariesList.addElements(elementsToAdd);
            this.fLibrariesList.postSetSelection((ISelection)new StructuredSelection(libentries));
        }
    }

    private static IPath guessSourceAttachment(PPListElement elem) {
        if (elem.getEntryKind() == 5) {
            return null;
        }
        IEGLProject currProject = elem.getEGLProject();
        try {
            IEGLModel model = EGLCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
            IEGLProject[] projects = model.getEGLProjects();
            int i = 0;
            while (i < projects.length) {
                IEGLProject curr = projects[i];
                if (!curr.equals(currProject)) {
                    IEGLPathEntry[] entries = curr.getRawEGLPath();
                    int k = 0;
                    while (k < entries.length) {
                        IPath attachPath;
                        IEGLPathEntry entry = entries[k];
                        if (entry.getEntryKind() == elem.getEntryKind() && entry.getPath().equals((Object)elem.getPath()) && (attachPath = entry.getSourceAttachmentPath()) != null && !attachPath.isEmpty()) {
                            return attachPath;
                        }
                        ++k;
                    }
                }
                ++i;
            }
        }
        catch (EGLModelException eGLModelException) {}
        return null;
    }

    public void addElement(PPListElement element) {
        this.fLibrariesList.addElement(element);
        this.fLibrariesList.postSetSelection((ISelection)new StructuredSelection((Object)element));
    }

    protected void libaryPageDoubleClicked(TreeListDialogField field) {
        List selection = field.getSelectedElements();
        if (this.canEdit(selection)) {
            this.editEntry();
        }
    }

    protected void libaryPageKeyPressed(TreeListDialogField field, KeyEvent event) {
        List selection;
        if (field == this.fLibrariesList && event.character == '\u007f' && event.stateMask == 0 && this.canRemove(selection = field.getSelectedElements())) {
            this.removeEntry();
        }
    }

    private void removeEntry() {
        List selElements = this.fLibrariesList.getSelectedElements();
        HashMap<PPListElement, HashSet<String>> containerEntriesToUpdate = new HashMap<PPListElement, HashSet<String>>();
        int i = selElements.size() - 1;
        while (i >= 0) {
            Object elem = selElements.get(i);
            if (elem instanceof PPListElementAttribute) {
                PPListElementAttribute attrib = (PPListElementAttribute)elem;
                String key = attrib.getKey();
                PPListElement selElement = attrib.getParent();
                if ("sourcepath".equals(key)) {
                    selElement.setAttribute("sourcepath", (Object)"");
                    String[] changedAttributes = new String[]{"sourcepath"};
                    this.attributeUpdated(selElement, changedAttributes);
                }
                attrib.setValue(null);
                selElements.remove(i);
                if (attrib.getParent().getParentContainer() instanceof PPListElement) {
                    PPListElement containerEntry = attrib.getParent();
                    HashSet<String> changedAttributes = (HashSet<String>)containerEntriesToUpdate.get(containerEntry);
                    if (changedAttributes == null) {
                        changedAttributes = new HashSet<String>();
                        containerEntriesToUpdate.put(containerEntry, changedAttributes);
                    }
                    changedAttributes.add(key);
                }
            }
            --i;
        }
        if (selElements.isEmpty()) {
            this.fLibrariesList.refresh();
            this.fClassPathList.dialogFieldChanged();
        } else {
            this.fLibrariesList.removeElements(selElements);
        }
        for (Map.Entry entry : containerEntriesToUpdate.entrySet()) {
            PPListElement curr = (PPListElement)entry.getKey();
            HashSet attribs = (HashSet)entry.getValue();
            String[] changedAttributes = attribs.toArray(new String[attribs.size()]);
            IEGLPathEntry changedEntry = curr.getEGLPathEntry();
            this.updateContainerEntry(changedEntry, changedAttributes, this.fCurrProject, curr.getParentContainer().getPath());
        }
    }

    private boolean canRemove(List selElements) {
        if (selElements.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < selElements.size()) {
            Object elem = selElements.get(i);
            if (elem instanceof PPListElementAttribute) {
                PPListElementAttribute attrib = (PPListElementAttribute)elem;
                if (attrib.getValue() == null) {
                    return false;
                }
            } else if (elem instanceof PPListElement) {
                PPListElement curr = (PPListElement)elem;
                if (curr.getEGLPathEntry().isBinaryProject()) {
                    return false;
                }
                if (curr.getParentContainer() != null) {
                    return false;
                }
            } else {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void editEntry() {
        List selElements = this.fLibrariesList.getSelectedElements();
        if (selElements.size() != 1) {
            return;
        }
        Object elem = selElements.get(0);
        if (this.fLibrariesList.getIndexOfElement(elem) != -1) {
            this.editElementEntry((PPListElement)elem);
        } else if (elem instanceof PPListElementAttribute) {
            this.editAttributeEntry((PPListElementAttribute)elem);
        }
    }

    private void editAttributeEntry(PPListElementAttribute elem) {
        IEGLPathEntry result;
        String key = elem.getKey();
        PPListElement selElement = elem.getParent();
        if (key.equals("sourcepath") && (result = this.configureSourceAttachment(this.getShell(), selElement.getEGLPathEntry())) != null) {
            selElement.setAttribute("sourcepath", (Object)result.getSourceAttachmentPath());
            String[] changedAttributes = new String[]{"sourcepath"};
            this.attributeUpdated(selElement, changedAttributes);
            this.fLibrariesList.refresh(elem);
            this.fLibrariesList.refresh(selElement);
            this.fClassPathList.refresh();
            this.updateEnabledState();
        }
    }

    private IEGLPathEntry configureSourceAttachment(Shell shell, IEGLPathEntry initialEntry) {
        if (initialEntry == null) {
            throw new IllegalArgumentException();
        }
        int entryKind = initialEntry.getEntryKind();
        if (entryKind != 1 && entryKind != 4) {
            throw new IllegalArgumentException();
        }
        SourceAttachmentDialog dialog = new SourceAttachmentDialog(shell, initialEntry);
        if (dialog.open() == 0) {
            return dialog.getResult();
        }
        return null;
    }

    private void attributeUpdated(PPListElement selElement, String[] changedAttributes) {
        PPListElement parentContainer = selElement.getParentContainer();
        if (parentContainer instanceof PPListElement) {
            IEGLPathEntry updatedEntry = selElement.getEGLPathEntry();
            this.updateContainerEntry(updatedEntry, changedAttributes, this.fCurrProject, parentContainer.getPath());
        }
    }

    private void updateContainerEntry(IEGLPathEntry newEntry, String[] changedAttributes, IEGLProject jproject, IPath containerPath) {
    }

    private void editElementEntry(PPListElement elem) {
        PPListElement[] res = null;
        switch (elem.getEntryKind()) {
            case 5: {
                res = this.openContainerSelectionDialog(elem);
                break;
            }
            case 1: {
                IResource resource = elem.getResource();
                if (resource == null) {
                    elem.getPath().toFile();
                    res = this.openExtJarFileDialog(elem);
                    break;
                }
                if (resource.getType() != 1) break;
                res = this.openJarFileDialog(elem);
                break;
            }
            case 4: {
                res = this.openVariableSelectionDialog(elem);
            }
        }
        if (res != null && res.length > 0) {
            PPListElement curr = res[0];
            curr.setExported(elem.isExported());
            curr.setAttributesFromExisting(elem);
            this.fLibrariesList.replaceElement(elem, curr);
            if (elem.getEntryKind() == 4) {
                this.fLibrariesList.refresh();
            }
        }
    }

    private void libaryPageSelectionChanged(DialogField field) {
        this.updateEnabledState();
    }

    private void disableAllButtons() {
        this.fLibrariesList.enableButton(0, false);
        this.fLibrariesList.enableButton(1, false);
        this.fLibrariesList.enableButton(2, false);
        this.fLibrariesList.enableButton(3, false);
    }

    private void updateEnabledState() {
        if (this.fCurrProject != null && this.fCurrProject.isBinary()) {
            this.disableAllButtons();
            return;
        }
        List selElements = this.fLibrariesList.getSelectedElements();
        this.fLibrariesList.enableButton(2, this.canEdit(selElements));
        this.fLibrariesList.enableButton(3, this.canRemove(selElements));
        boolean noAttributes = this.containsOnlyTopLevelEntries(selElements);
        this.fLibrariesList.enableButton(1, noAttributes);
        this.fLibrariesList.enableButton(0, noAttributes);
    }

    private boolean containsOnlyTopLevelEntries(List selElements) {
        if (selElements.size() == 0) {
            return true;
        }
        int i = 0;
        while (i < selElements.size()) {
            Object elem = selElements.get(i);
            if (elem instanceof PPListElement) {
                if (((PPListElement)elem).getParentContainer() != null) {
                    return false;
                }
            } else {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean canEdit(List selElements) {
        if (selElements.size() != 1) {
            return false;
        }
        Object elem = selElements.get(0);
        if (elem instanceof PPListElement) {
            PPListElement curr = (PPListElement)elem;
            if (curr.getEGLPathEntry().isBinaryProject()) {
                return false;
            }
            return !(curr.getResource() instanceof IFolder) && curr.getParentContainer() == null;
        }
        if (elem instanceof PPListElementAttribute) {
            PPListElementAttribute cfr_ignored_0 = (PPListElementAttribute)elem;
            return true;
        }
        return false;
    }

    private void libaryPageDialogFieldChanged(DialogField field) {
        if (this.fCurrProject != null) {
            this.updateClasspathList();
        }
    }

    private void updateClasspathList() {
        int nEntries;
        List projelements = this.fLibrariesList.getElements();
        List cpelements = this.fClassPathList.getElements();
        int lastRemovePos = nEntries = cpelements.size();
        int i = nEntries - 1;
        while (i >= 0) {
            PPListElement cpe = (PPListElement)cpelements.get(i);
            int kind = cpe.getEntryKind();
            if (this.isEntryKind(kind) && !projelements.remove(cpe)) {
                cpelements.remove(i);
                lastRemovePos = i;
            }
            --i;
        }
        cpelements.addAll(lastRemovePos, projelements);
        if (lastRemovePos != nEntries || !projelements.isEmpty()) {
            this.fClassPathList.setElements(cpelements);
        }
    }

    private PPListElement[] openJarFileDialog(PPListElement existing) {
        IWorkspaceRoot root = this.fCurrProject.getProject().getWorkspace().getRoot();
        if (existing == null) {
            IPath[] selected = BuildPathDialogAccess.chooseJAREntries(this.getShell(), this.fCurrProject.getPath(), this.getUsedEGLARFiles(existing));
            if (selected != null) {
                ArrayList<PPListElement> res = new ArrayList<PPListElement>();
                int i = 0;
                while (i < selected.length) {
                    IPath curr = selected[i];
                    IResource resource = root.findMember(curr);
                    if (resource instanceof IFile) {
                        res.add(this.newPPLibraryElement(resource));
                    }
                    ++i;
                }
                return res.toArray(new PPListElement[res.size()]);
            }
        } else {
            IResource resource;
            IPath configured = BuildPathDialogAccess.configureJAREntry(this.getShell(), existing.getPath(), this.getUsedEGLARFiles(existing));
            if (configured != null && (resource = root.findMember(configured)) instanceof IFile) {
                return new PPListElement[]{this.newPPLibraryElement(resource)};
            }
        }
        return null;
    }

    private IPath[] getUsedContainers(PPListElement existing) {
        ArrayList<IPath> res = new ArrayList<IPath>();
        if (this.fCurrProject.exists()) {
            try {
                IPath outputLocation = this.fCurrProject.getOutputLocation();
                if (outputLocation != null && outputLocation.segmentCount() > 1) {
                    res.add(outputLocation);
                }
            }
            catch (EGLModelException eGLModelException) {}
        }
        List cplist = this.fLibrariesList.getElements();
        int i = 0;
        while (i < cplist.size()) {
            IResource resource;
            PPListElement elem = (PPListElement)cplist.get(i);
            if (elem.getEntryKind() == 1 && elem != existing && (resource = elem.getResource()) instanceof IContainer && !resource.equals((Object)existing)) {
                res.add(resource.getFullPath());
            }
            ++i;
        }
        return res.toArray(new IPath[res.size()]);
    }

    private IPath[] getUsedEGLARFiles(PPListElement existing) {
        ArrayList<IPath> res = new ArrayList<IPath>();
        List cplist = this.fLibrariesList.getElements();
        int i = 0;
        while (i < cplist.size()) {
            IResource resource;
            PPListElement elem = (PPListElement)cplist.get(i);
            if (elem.getEntryKind() == 1 && elem != existing && (resource = elem.getResource()) instanceof IFile) {
                res.add(resource.getFullPath());
            }
            ++i;
        }
        return res.toArray(new IPath[res.size()]);
    }

    private PPListElement newPPLibraryElement(IResource res) {
        return new PPListElement(this.fCurrProject, 1, res.getFullPath(), res);
    }

    private PPListElement[] openExtJarFileDialog(PPListElement existing) {
        if (existing == null) {
            IPath[] selected = BuildPathDialogAccess.chooseExternalJAREntries(this.getShell());
            if (selected != null) {
                ArrayList<PPListElement> res = new ArrayList<PPListElement>();
                int i = 0;
                while (i < selected.length) {
                    res.add(new PPListElement(this.fCurrProject, 1, selected[i], null));
                    ++i;
                }
                return res.toArray(new PPListElement[res.size()]);
            }
        } else {
            IPath configured = BuildPathDialogAccess.configureExternalJAREntry(this.getShell(), existing.getPath());
            if (configured != null) {
                return new PPListElement[]{new PPListElement(this.fCurrProject, 1, configured, null)};
            }
        }
        return null;
    }

    private PPListElement[] openVariableSelectionDialog(PPListElement existing) {
        List existingElements = this.fLibrariesList.getElements();
        ArrayList<IPath> existingPaths = new ArrayList<IPath>(existingElements.size());
        int i = 0;
        while (i < existingElements.size()) {
            PPListElement elem = (PPListElement)existingElements.get(i);
            if (elem.getEntryKind() == 4) {
                existingPaths.add(elem.getPath());
            }
            ++i;
        }
        IPath[] existingPathsArray = existingPaths.toArray(new IPath[existingPaths.size()]);
        if (existing == null) {
            IPath[] paths = BuildPathDialogAccess.chooseVariableEntries(this.getShell(), existingPathsArray);
            if (paths != null) {
                ArrayList<PPListElement> result = new ArrayList<PPListElement>();
                int i2 = 0;
                while (i2 < paths.length) {
                    IPath path = paths[i2];
                    PPListElement elem = this.createCPVariableElement(path);
                    if (!existingElements.contains(elem)) {
                        result.add(elem);
                    }
                    ++i2;
                }
                return result.toArray(new PPListElement[result.size()]);
            }
        } else {
            IPath path = BuildPathDialogAccess.configureVariableEntry(this.getShell(), existing.getPath(), existingPathsArray);
            if (path != null) {
                return new PPListElement[]{this.createCPVariableElement(path)};
            }
        }
        return null;
    }

    private PPListElement createCPVariableElement(IPath path) {
        PPListElement elem = new PPListElement(this.fCurrProject, 4, path, null);
        IPath resolvedPath = EGLCore.getResolvedVariablePath((IPath)path);
        elem.setIsMissing(resolvedPath == null || !resolvedPath.toFile().exists());
        return elem;
    }

    private PPListElement[] openContainerSelectionDialog(PPListElement existing) {
        if (existing == null) {
            IEGLPathEntry[] created = BuildPathDialogAccess.chooseContainerEntries(this.getShell(), this.fCurrProject, this.getRawClasspath());
            if (created != null) {
                PPListElement[] res = new PPListElement[created.length];
                int i = 0;
                while (i < res.length) {
                    res[i] = PPListElement.createFromExisting((IEGLPathEntry)created[i], (IEGLProject)this.fCurrProject);
                    ++i;
                }
                return res;
            }
        } else {
            IEGLPathEntry created = BuildPathDialogAccess.configureContainerEntry(this.getShell(), existing.getEGLPathEntry(), this.fCurrProject, this.getRawClasspath());
            if (created != null) {
                PPListElement elem = new PPListElement(this.fCurrProject, 5, created.getPath(), null);
                return new PPListElement[]{elem};
            }
        }
        return null;
    }

    private IEGLPathEntry[] getRawClasspath() {
        IEGLPathEntry[] currEntries = new IEGLPathEntry[this.fClassPathList.getSize()];
        int i = 0;
        while (i < currEntries.length) {
            PPListElement curr = (PPListElement)this.fClassPathList.getElement(i);
            currEntries[i] = curr.getEGLPathEntry();
            ++i;
        }
        return currEntries;
    }

    @Override
    public boolean isEntryKind(int kind) {
        return kind == 1 || kind == 4 || kind == 5;
    }

    @Override
    public List getSelection() {
        return this.fLibrariesList.getSelectedElements();
    }

    public void setSelection(List selElements, boolean expand) {
        this.fLibrariesList.selectElements((ISelection)new StructuredSelection(selElements));
        if (expand) {
            int i = 0;
            while (i < selElements.size()) {
                this.fLibrariesList.expandElement(selElements.get(i), 1);
                ++i;
            }
        }
    }

    @Override
    public void setSelection(List selElements) {
        this.setSelection(selElements, false);
    }

    public void setFocus() {
        this.fLibrariesList.setFocus();
    }

    private Shell getShell() {
        if (this.fSWTControl != null) {
            return this.fSWTControl.getShell();
        }
        return EDTUIPlugin.getActiveWorkbenchShell();
    }

    private class LibrariesAdapter
    implements IDialogFieldListener,
    ITreeListAdapter {
        private final Object[] EMPTY_ARR = new Object[0];

        private LibrariesAdapter() {
        }

        @Override
        public void customButtonPressed(TreeListDialogField field, int index) {
            EGLLibrariesWorkbookPage.this.libaryPageCustomButtonPressed(field, index);
        }

        @Override
        public void selectionChanged(TreeListDialogField field) {
            EGLLibrariesWorkbookPage.this.libaryPageSelectionChanged(field);
        }

        @Override
        public void doubleClicked(TreeListDialogField field) {
            EGLLibrariesWorkbookPage.this.libaryPageDoubleClicked(field);
        }

        @Override
        public void keyPressed(TreeListDialogField field, KeyEvent event) {
            EGLLibrariesWorkbookPage.this.libaryPageKeyPressed(field, event);
        }

        @Override
        public Object[] getChildren(TreeListDialogField field, Object element) {
            return this.EMPTY_ARR;
        }

        @Override
        public Object getParent(TreeListDialogField field, Object element) {
            if (element instanceof PPListElementAttribute) {
                return ((PPListElementAttribute)element).getParent();
            }
            return null;
        }

        @Override
        public boolean hasChildren(TreeListDialogField field, Object element) {
            return this.getChildren(field, element).length > 0;
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            EGLLibrariesWorkbookPage.this.libaryPageDialogFieldChanged(field);
        }
    }
}

