/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.handlers.wizards;

import org.eclipse.core.runtime.Path;
import org.eclipse.edt.ide.ui.internal.handlers.wizards.HandlerConfiguration;
import org.eclipse.edt.ide.ui.internal.templates.TemplateEngine;
import org.eclipse.edt.ide.ui.wizards.EGLFileConfiguration;
import org.eclipse.edt.ide.ui.wizards.PartOperation;
import org.eclipse.edt.ide.ui.wizards.PartTemplateException;

public class RUIHandlerOperation
extends PartOperation {
    private String handlerTitle;

    public RUIHandlerOperation(HandlerConfiguration configuration, String handlerTitle) {
        super(configuration);
        this.handlerTitle = handlerTitle;
    }

    @Override
    public String getFileContents() throws PartTemplateException {
        String outputString = "";
        this.templateName = "handler";
        String templateid = "org.eclipse.edt.ide.ui.templates.rui_handler";
        HandlerConfiguration configuration = (HandlerConfiguration)this.configuration;
        String partName = configuration.getHandlerName();
        String title = this.handlerTitle;
        String relativeCSSFile = new Path("css/" + configuration.getProjectName() + ".css").toString();
        if (configuration.getChosenTemplateSelection() == 1) {
            outputString = TemplateEngine.getCustomizedTemplateString(this.templateName, templateid);
        } else if (configuration.getChosenTemplateSelection() == 0) {
            outputString = TemplateEngine.getDefaultTemplateString(this.templateName, templateid);
        }
        if (outputString.compareTo("") != 0) {
            String[] templateVariablesToReplace = new String[]{"${handlerName}", "${cssFile}", "${handlerTitle}"};
            String[] valuesToReplaceWith = new String[]{partName, relativeCSSFile, title};
            int i = 0;
            while (i < templateVariablesToReplace.length) {
                String oldString = outputString;
                if ((outputString = this.replaceTemplateWithString(outputString, templateVariablesToReplace[i], valuesToReplaceWith[i])) == null) {
                    if (i == 2) {
                        outputString = oldString;
                    } else {
                        throw new PartTemplateException(this.templateName, templateid, EGLFileConfiguration.TEMPLATE_CORRUPTED);
                    }
                }
                ++i;
            }
            while (outputString.indexOf("${") != -1) {
                int tagStart = outputString.indexOf("${");
                int tagEnd = outputString.indexOf("}", tagStart);
                String firstHalfOutputString = outputString.substring(0, tagStart);
                String secondHalfOutputString = outputString.substring(tagStart + 2, outputString.length());
                outputString = String.valueOf(firstHalfOutputString) + secondHalfOutputString;
                firstHalfOutputString = outputString.substring(0, tagEnd - 2);
                secondHalfOutputString = outputString.substring(tagEnd - 1, outputString.length());
                if (firstHalfOutputString.endsWith("cursor")) {
                    firstHalfOutputString = firstHalfOutputString.substring(0, firstHalfOutputString.length() - "cursor".length());
                }
                outputString = String.valueOf(firstHalfOutputString) + secondHalfOutputString;
            }
            return outputString;
        }
        throw new PartTemplateException(this.templateName, templateid, EGLFileConfiguration.TEMPLATE_NOT_FOUND);
    }
}

