/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.editor.folding;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.edt.ide.ui.editor.IFoldingPreferenceBlock;
import org.eclipse.edt.ide.ui.editor.IFoldingStructureProvider;
import org.eclipse.edt.ide.ui.internal.editor.folding.EmptyFoldingPreferenceBlock;
import org.eclipse.jface.text.Assert;

public final class FoldingStructureProviderDescriptor {
    private static final String PREFERENCES_CLASS = "preferencesClass";
    private static final String CLASS = "class";
    private static final String NAME = "name";
    private static final String ID = "id";
    private String fId;
    private String fName;
    private String fClass;
    private boolean fHasPreferences;
    private IConfigurationElement fElement;

    FoldingStructureProviderDescriptor(IConfigurationElement element) {
        this.fElement = element;
        this.fId = element.getAttributeAsIs(ID);
        Assert.isLegal((this.fId != null ? 1 : 0) != 0);
        this.fName = element.getAttribute(NAME);
        if (this.fName == null) {
            this.fName = this.fId;
        }
        this.fClass = element.getAttributeAsIs(CLASS);
        Assert.isLegal((this.fClass != null ? 1 : 0) != 0);
        this.fHasPreferences = element.getAttributeAsIs(PREFERENCES_CLASS) != null;
    }

    public IFoldingStructureProvider createProvider() throws CoreException {
        IFoldingStructureProvider prov = (IFoldingStructureProvider)this.fElement.createExecutableExtension(CLASS);
        return prov;
    }

    public IFoldingPreferenceBlock createPreferences() throws CoreException {
        if (this.fHasPreferences) {
            IFoldingPreferenceBlock prefs = (IFoldingPreferenceBlock)this.fElement.createExecutableExtension(PREFERENCES_CLASS);
            return prefs;
        }
        return new EmptyFoldingPreferenceBlock();
    }

    public String getId() {
        return this.fId;
    }

    public String getName() {
        return this.fName;
    }
}

