/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.editor;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.edt.ide.core.utils.BinaryReadOnlyFile;
import org.eclipse.edt.ide.ui.internal.editor.BinaryEditorInput;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;

public class BinaryEditorInputFactory
implements IElementFactory {
    private static final String ID_FACTORY = "org.eclipse.edt.ide.ui.BinaryEditorInputFactory";
    private static String TAG_PATH_EGLAR = "eglarpath";
    private static String TAG_PATH_SOURCE = "sourcepath";
    private static String TAG_PATH_IRNAME = "irname";
    private static String TAG_PATH_PRJ = "prjname";

    public IAdaptable createElement(IMemento memento) {
        String eglarPath = memento.getString(TAG_PATH_EGLAR);
        String sourcePath = memento.getString(TAG_PATH_SOURCE);
        String irName = memento.getString(TAG_PATH_IRNAME);
        String prjName = memento.getString(TAG_PATH_PRJ);
        IProject prj = ResourcesPlugin.getWorkspace().getRoot().getProject(prjName);
        if (prj != null) {
            return new BinaryEditorInput(new BinaryReadOnlyFile(eglarPath, sourcePath, irName, prj, false));
        }
        return null;
    }

    public static String getFactoryId() {
        return ID_FACTORY;
    }

    public static void saveState(IMemento memento, BinaryEditorInput input) {
        BinaryReadOnlyFile file = input.getBinaryReadOnlyFile();
        memento.putString(TAG_PATH_EGLAR, file.getEglarPathStr());
        memento.putString(TAG_PATH_SOURCE, file.getEglarSourcePath());
        memento.putString(TAG_PATH_IRNAME, file.getIrName());
        memento.putString(TAG_PATH_PRJ, file.getProject().getName());
    }
}

