/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.wizards.insertwidget;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.edt.ide.rui.visualeditor.internal.wizards.insertwidget.InsertDataNode;
import org.eclipse.ui.IEditorInput;

public class InsertDataModel {
    private IProject project;
    private List<InsertDataNode> rootDataNodes;
    private Context context;
    private IEditorInput editorInput;
    private boolean isAddController;
    private boolean isAddPublishMessageHelper;
    private boolean isAddFormattingAndValidation;
    private boolean isAddErrorMessage;
    private String purpose;

    public InsertDataModel(IProject project, IEditorInput editorInput) {
        this.project = project;
        this.isAddController = true;
        this.isAddFormattingAndValidation = true;
        this.isAddPublishMessageHelper = true;
        this.isAddErrorMessage = false;
        this.editorInput = editorInput;
        this.rootDataNodes = new ArrayList<InsertDataNode>();
        this.context = new Context();
    }

    public IProject getProject() {
        return this.project;
    }

    public IEditorInput getEditorInput() {
        return this.editorInput;
    }

    public List<InsertDataNode> getRootDataNodes() {
        return this.rootDataNodes;
    }

    public void addRootDataNode(InsertDataNode insertDataNode) {
        this.rootDataNodes.add(insertDataNode);
    }

    public Context getContext() {
        return this.context;
    }

    public void updatePurpose(String purpose) {
        for (InsertDataNode insertDataNode : this.rootDataNodes) {
            this.updatePurpose(insertDataNode, purpose);
        }
    }

    private void updatePurpose(InsertDataNode parent, String purpose) {
        parent.setPurpose(purpose);
        parent.update();
        List<InsertDataNode> children = parent.getChildren();
        for (InsertDataNode child : children) {
            this.updatePurpose(child, purpose);
        }
    }

    public boolean isAddFormattingAndValidation() {
        return this.isAddFormattingAndValidation;
    }

    public void setAddFormattingAndValidation(boolean isAddFormattingAndValidation) {
        this.isAddFormattingAndValidation = isAddFormattingAndValidation;
    }

    public boolean isAddErrorMessage() {
        return this.isAddErrorMessage;
    }

    public void setAddErrorMessage(boolean isAddErrorMessage) {
        this.isAddErrorMessage = isAddErrorMessage;
    }

    public boolean isAddController() {
        return this.isAddController;
    }

    public void setAddController(boolean isAddController) {
        this.isAddController = isAddController;
    }

    public boolean isAddPublishMessageHelper() {
        return this.isAddPublishMessageHelper;
    }

    public void setAddPublishMessageHelper(boolean isAddPublishMessageHelper) {
        this.isAddPublishMessageHelper = isAddPublishMessageHelper;
    }

    public String getPurpose() {
        return this.purpose;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public class Context {
        public static final String BINDING_NAME = "BINDING_NAME";
        public static final String PARENT_INSERT_DATA_NODE = "PARENT_INSERT_DATA_NODE";
        private Map<String, Object> context = new HashMap<String, Object>();

        public void set(String key, Object value) {
            this.context.put(key, value);
        }

        public Object get(String key) {
            return this.context.get(key);
        }
    }
}

