/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.util;

import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvConstants;
import org.eclipse.edt.ide.rui.visualeditor.internal.nl.Messages;
import org.eclipse.edt.ide.rui.visualeditor.internal.preferences.EvPreferences;
import org.eclipse.edt.ide.rui.visualeditor.internal.util.BidiFormat;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class BidiUtils {
    private static Combo _comboWidgetOrientation = null;
    private static Combo _comboTextLayout = null;
    private static Combo _comboTextDirection = null;
    private static Combo _comboSymSwapping = null;
    private static Combo _comboNumSwapping = null;

    public static BidiFormat createBidiControls(Composite parentComposite, BidiFormat bidiFormat) {
        GridData gridData = new GridData(768);
        parentComposite.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        parentComposite.setLayout((Layout)gridLayout);
        if (parentComposite instanceof Group) {
            ((Group)parentComposite).setText(Messages.NL_Bidirectional_options);
        }
        parentComposite.setFocus();
        Label label = new Label(parentComposite, 0);
        label.setText(Messages.NL_BIDI_Widget_OrientationXcolonX);
        label.setLayoutData((Object)new GridData());
        _comboWidgetOrientation = new Combo(parentComposite, 8);
        gridData = new GridData(768);
        _comboWidgetOrientation.setLayoutData((Object)gridData);
        _comboWidgetOrientation.add(Messages.NL_BIDI_LTR);
        _comboWidgetOrientation.add(Messages.NL_BIDI_RTL);
        _comboWidgetOrientation.setText(bidiFormat.getWidgetOrientation());
        label = new Label(parentComposite, 0);
        label.setText(Messages.NL_BIDI_Text_LayoutXcolonX);
        label.setLayoutData((Object)new GridData());
        _comboTextLayout = new Combo(parentComposite, 8);
        gridData = new GridData(768);
        _comboTextLayout.setLayoutData((Object)gridData);
        _comboTextLayout.add(Messages.NL_BIDI_Logical);
        _comboTextLayout.add(Messages.NL_BIDI_Visual);
        _comboTextLayout.setText(bidiFormat.getTextLayout());
        label = new Label(parentComposite, 0);
        label.setText(Messages.NL_BIDI_Reverse_Text_DirectionXcolonX);
        label.setLayoutData((Object)new GridData());
        _comboTextDirection = new Combo(parentComposite, 8);
        gridData = new GridData(768);
        _comboTextDirection.setLayoutData((Object)gridData);
        _comboTextDirection.add(Messages.NL_BIDI_Yes);
        _comboTextDirection.add(Messages.NL_BIDI_No);
        _comboTextDirection.setText(bidiFormat.getReverseTextDirection());
        return new BidiFormat(_comboWidgetOrientation.getText(), _comboTextLayout.getText(), _comboTextDirection.getText(), "Yes", "Yes");
    }

    public static void updateBidiPropertiesEnablement() {
        boolean isBidi = BidiUtils.isBidi();
        _comboWidgetOrientation.setEnabled(isBidi);
        _comboTextLayout.setEnabled(isBidi);
        _comboTextDirection.setEnabled(isBidi);
        if (!isBidi) {
            BidiUtils.performDefaults();
        }
    }

    public static BidiFormat getDefaultBidiFormat() {
        return new BidiFormat(EvConstants.PREFERENCE_DEFAULT_BIDI_WIDGET_ORIENTATION, EvConstants.PREFERENCE_DEFAULT_BIDI_TEXT_LAYOUT, EvConstants.PREFERENCE_DEFAULT_BIDI_REVERSE_TEXT_DIRECTION, EvConstants.PREFERENCE_DEFAULT_BIDI_SYM_SWAPPING, EvConstants.PREFERENCE_DEFAULT_BIDI_NUM_SWAPPING);
    }

    public static void performDefaults() {
        BidiFormat bidiFormat = BidiUtils.getDefaultBidiFormat();
        _comboWidgetOrientation.setText(bidiFormat.getWidgetOrientation());
        _comboTextLayout.setText(bidiFormat.getTextLayout());
        _comboTextDirection.setText(bidiFormat.getReverseTextDirection());
    }

    public static void performOk() {
        BidiFormat bidiFormat = BidiUtils.getBidiFormat();
        String currentProp = EvPreferences.getString("org.eclipse.edt.ide.rui.visualeditor.BidiWidgetOrientation");
        if (!bidiFormat.getWidgetOrientation().equals(currentProp)) {
            EvPreferences.setString("org.eclipse.edt.ide.rui.visualeditor.BidiWidgetOrientation", bidiFormat.getWidgetOrientation());
        }
        currentProp = EvPreferences.getString("org.eclipse.edt.ide.rui.visualeditor.BidiTextLayout");
        if (!bidiFormat.getTextLayout().equals(currentProp)) {
            EvPreferences.setString("org.eclipse.edt.ide.rui.visualeditor.BidiTextLayout", bidiFormat.getTextLayout());
        }
        currentProp = EvPreferences.getString("org.eclipse.edt.ide.rui.visualeditor.BidiReverseTextDirection");
        if (!bidiFormat.getReverseTextDirection().equals(currentProp)) {
            EvPreferences.setString("org.eclipse.edt.ide.rui.visualeditor.BidiReverseTextDirection", bidiFormat.getReverseTextDirection());
        }
        currentProp = EvPreferences.getString("org.eclipse.edt.ide.rui.visualeditor.BidiSymSwap");
        if (!bidiFormat.getSymmetricSwapping().equals(currentProp)) {
            EvPreferences.setString("org.eclipse.edt.ide.rui.visualeditor.BidiSymSwap", bidiFormat.getSymmetricSwapping());
        }
        currentProp = EvPreferences.getString("org.eclipse.edt.ide.rui.visualeditor.BidiNumSwap");
        if (!bidiFormat.getNumericSwapping().equals(currentProp)) {
            EvPreferences.setString("org.eclipse.edt.ide.rui.visualeditor.BidiNumSwap", bidiFormat.getNumericSwapping());
        }
    }

    public static BidiFormat getBidiFormatFromPreferences() {
        return new BidiFormat(EvPreferences.getString("org.eclipse.edt.ide.rui.visualeditor.BidiWidgetOrientation"), EvPreferences.getString("org.eclipse.edt.ide.rui.visualeditor.BidiTextLayout"), EvPreferences.getString("org.eclipse.edt.ide.rui.visualeditor.BidiReverseTextDirection"), EvPreferences.getString("org.eclipse.edt.ide.rui.visualeditor.BidiSymSwap"), EvPreferences.getString("org.eclipse.edt.ide.rui.visualeditor.BidiNumSwap"));
    }

    public static BidiFormat getBidiFormat() {
        return new BidiFormat(_comboWidgetOrientation.getText(), _comboTextLayout.getText(), _comboTextDirection.getText(), "Yes", "Yes");
    }

    public static String updateTemplateWithBidi(String strWidgetCreationTemplate, BidiFormat bidiFormat) {
        String resultTemplate = strWidgetCreationTemplate.substring(0, strWidgetCreationTemplate.lastIndexOf(125));
        if (!bidiFormat.isDefaultBidiFormat()) {
            if (!resultTemplate.trim().endsWith("{")) {
                resultTemplate = String.valueOf(resultTemplate) + ", ";
            }
            if (!bidiFormat.isDefaultWidgetOrientation()) {
                resultTemplate = String.valueOf(resultTemplate) + BidiUtils.addWidgetOrientation(bidiFormat.getWidgetOrientation());
            }
            if (!bidiFormat.isDefaultTextLayout()) {
                resultTemplate = String.valueOf(resultTemplate) + BidiUtils.addTextLayout(bidiFormat.getTextLayout());
            }
            if (!bidiFormat.isDefaultReverseTextDirection()) {
                resultTemplate = String.valueOf(resultTemplate) + BidiUtils.addReverseTextDirection(bidiFormat.getReverseTextDirection());
            }
            if (resultTemplate.trim().endsWith(",")) {
                resultTemplate = resultTemplate.trim().substring(0, resultTemplate.lastIndexOf(","));
            }
        }
        resultTemplate = String.valueOf(resultTemplate) + strWidgetCreationTemplate.substring(strWidgetCreationTemplate.lastIndexOf(125));
        return resultTemplate;
    }

    private static String addNumericSwapping(String numericSwapping) {
        return "numericSwap = \"" + numericSwapping + "\"" + ", ";
    }

    private static String addSymmetricSwapping(String symmetricSwapping) {
        return "symmetricSwap = \"" + symmetricSwapping + "\"" + ", ";
    }

    private static String addReverseTextDirection(String reverseTextDirection) {
        return "reverseTextDirection = \"" + reverseTextDirection + "\"" + ", ";
    }

    private static String addTextLayout(String textLayout) {
        return "textLayout = \"" + textLayout + "\"" + ", ";
    }

    private static String addWidgetOrientation(String widgetOrientation) {
        return "widgetOrientation = \"" + widgetOrientation + "\"" + ", ";
    }

    public static boolean isBidi() {
        return false;
    }

    public static boolean isRtlOrientation() {
        int orientation = Window.getDefaultOrientation();
        return orientation == 0x4000000;
    }
}

