/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.model;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLPathContainer;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.PPListElementAttribute;

public class PPListElement {
    public static final String SOURCEATTACHMENT = "sourcepath";
    public static final String SOURCEATTACHMENTROOT = "rootpath";
    public static final String JAVADOC = "javadoc";
    public static final String OUTPUT = "output";
    public static final String EXCLUSION = "exclusion";
    private IEGLProject fProject;
    private int fEntryKind;
    private IPath fPath;
    private IResource fResource;
    private boolean fIsExported;
    private boolean fIsMissing;
    private PPListElement fParentContainer;
    private IEGLPathEntry fCachedEntry;
    private ArrayList fChildren;

    public PPListElement(IEGLProject project, int entryKind, IPath path, IResource res) {
        this.fProject = project;
        this.fEntryKind = entryKind;
        this.fPath = path;
        this.fResource = res;
        this.initial();
    }

    private void initial() {
        this.fChildren = new ArrayList();
        this.fIsExported = false;
        this.fIsMissing = false;
        this.fCachedEntry = null;
        this.fParentContainer = null;
        switch (this.fEntryKind) {
            case 3: {
                this.createAttributeElement(OUTPUT, null);
                this.createAttributeElement(EXCLUSION, new Path[0]);
                break;
            }
            case 1: 
            case 4: {
                this.createAttributeElement(SOURCEATTACHMENT, null);
                break;
            }
            case 2: {
                break;
            }
            case 5: {
                try {
                    IEGLPathContainer container = EGLCore.getEGLPathContainer(this.fPath, this.fProject);
                    if (container == null) break;
                    IEGLPathEntry[] entries = container.getEGLPathEntries();
                    int i = 0;
                    while (i < entries.length) {
                        PPListElement curr = PPListElement.createFromExisting(entries[i], this.fProject);
                        curr.setParentContainer(this);
                        this.fChildren.add(curr);
                        ++i;
                    }
                    break;
                }
                catch (EGLModelException eGLModelException) {}
            }
        }
    }

    public IEGLPathEntry getEGLPathEntry() {
        if (this.fCachedEntry == null) {
            this.fCachedEntry = this.newEGLPathEntry();
        }
        return this.fCachedEntry;
    }

    private IEGLPathEntry newEGLPathEntry() {
        switch (this.fEntryKind) {
            case 3: {
                IPath outputLocation = (IPath)this.getAttribute(OUTPUT);
                IPath[] exclusionPattern = (IPath[])this.getAttribute(EXCLUSION);
                return EGLCore.newSourceEntry(this.fPath, exclusionPattern, outputLocation);
            }
            case 1: {
                IPath attach = (IPath)this.getAttribute(SOURCEATTACHMENT);
                IEGLPathEntry entry = EGLCore.newLibraryEntry(this.fPath, attach, null, this.isExported());
                return entry;
            }
            case 2: {
                IEGLPathEntry entryTemp = EGLCore.newProjectEntry(this.fPath, this.isExported());
                if (this.fResource != null && this.fResource instanceof IProject) {
                    IEGLProject proj = EGLCore.create((IProject)this.fResource);
                    entryTemp.setBinaryProject(proj.isBinary());
                }
                return entryTemp;
            }
            case 5: {
                return EGLCore.newContainerEntry(this.fPath, this.isExported());
            }
            case 4: {
                IPath varAttach = (IPath)this.getAttribute(SOURCEATTACHMENT);
                return EGLCore.newVariableEntry(this.fPath, varAttach, null, this.isExported());
            }
        }
        return null;
    }

    public IPath getPath() {
        return this.fPath;
    }

    public int getEntryKind() {
        return this.fEntryKind;
    }

    public IResource getResource() {
        return this.fResource;
    }

    public PPListElementAttribute setAttribute(String key, Object value) {
        PPListElementAttribute attribute = this.findAttributeElement(key);
        if (attribute == null) {
            return null;
        }
        attribute.setValue(value);
        this.attributeChanged(key);
        return attribute;
    }

    private PPListElementAttribute findAttributeElement(String key) {
        int i = 0;
        while (i < this.fChildren.size()) {
            PPListElementAttribute elem;
            Object curr = this.fChildren.get(i);
            if (curr instanceof PPListElementAttribute && key.equals((elem = (PPListElementAttribute)curr).getKey())) {
                return elem;
            }
            ++i;
        }
        return null;
    }

    public Object getAttribute(String key) {
        PPListElementAttribute attrib = this.findAttributeElement(key);
        if (attrib != null) {
            return attrib.getValue();
        }
        return null;
    }

    private void createAttributeElement(String key, Object value) {
        this.fChildren.add(new PPListElementAttribute(this, key, value));
    }

    public Object[] getChildren(boolean hideOutputFolder) {
        if (hideOutputFolder && this.fEntryKind == 3) {
            return new Object[]{this.findAttributeElement(EXCLUSION)};
        }
        return this.fChildren.toArray();
    }

    private void setParentContainer(PPListElement element) {
        this.fParentContainer = element;
    }

    public PPListElement getParentContainer() {
        return this.fParentContainer;
    }

    private void attributeChanged(String key) {
        this.fCachedEntry = null;
    }

    public boolean equals(Object other) {
        if (other != null && other.getClass().equals(this.getClass())) {
            PPListElement elem = (PPListElement)other;
            return elem.fEntryKind == this.fEntryKind && elem.fPath.equals((Object)this.fPath);
        }
        return false;
    }

    public int hashCode() {
        return this.fPath.hashCode() + this.fEntryKind;
    }

    public boolean isMissing() {
        return this.fIsMissing;
    }

    public void setIsMissing(boolean isMissing) {
        this.fIsMissing = isMissing;
    }

    public boolean isExported() {
        return this.fIsExported;
    }

    public void setExported(boolean isExported) {
        if (isExported != this.fIsExported) {
            this.fIsExported = isExported;
            this.attributeChanged(null);
        }
    }

    public IEGLProject getEGLProject() {
        return this.fProject;
    }

    public static PPListElement createFromExisting(IEGLPathEntry curr, IEGLProject project) {
        IPath path = curr.getPath();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource res = null;
        boolean isMissing = false;
        Object javaDocLocation = null;
        switch (curr.getEntryKind()) {
            case 5: {
                res = null;
                try {
                    isMissing = EGLCore.getEGLPathContainer(path, project) == null;
                }
                catch (EGLModelException eGLModelException) {
                    isMissing = true;
                }
                break;
            }
            case 4: {
                IPath resolvedPath = EGLCore.getResolvedVariablePath(path);
                res = null;
                isMissing = root.findMember(resolvedPath) == null && !resolvedPath.toFile().isFile();
                break;
            }
            case 1: {
                res = root.findMember(path);
                if (res != null) break;
                if ("eglar".equalsIgnoreCase(path.getFileExtension()) && root.getWorkspace().validatePath(path.toString(), 2).isOK()) {
                    res = root.getFolder(path);
                }
                isMissing = !path.toFile().isFile();
                break;
            }
            case 3: {
                res = root.findMember(path);
                if (res != null) break;
                if (root.getWorkspace().validatePath(path.toString(), 2).isOK()) {
                    res = root.getFolder(path);
                }
                isMissing = true;
                break;
            }
            case 2: {
                res = root.findMember(path);
                isMissing = res == null;
            }
        }
        PPListElement elem = new PPListElement(project, curr.getEntryKind(), path, res);
        elem.setExported(curr.isExported());
        elem.setAttribute(SOURCEATTACHMENT, curr.getSourceAttachmentPath());
        elem.setAttribute(JAVADOC, javaDocLocation);
        elem.setAttribute(OUTPUT, curr.getOutputLocation());
        elem.setAttribute(EXCLUSION, curr.getExclusionPatterns());
        elem.setIsMissing(isMissing);
        return elem;
    }

    public void setAttributesFromExisting(PPListElement existing) {
        Assert.isTrue((existing.getEntryKind() == this.getEntryKind() ? 1 : 0) != 0);
        PPListElementAttribute[] attributes = existing.getAllAttributes();
        int i = 0;
        while (i < attributes.length) {
            PPListElementAttribute curr = attributes[i];
            PPListElementAttribute elem = this.findAttributeElement(curr.getKey());
            if (elem == null) {
                this.createAttributeElement(curr.getKey(), curr.getValue());
            } else {
                elem.setValue(curr.getValue());
            }
            ++i;
        }
    }

    public PPListElementAttribute[] getAllAttributes() {
        ArrayList res = new ArrayList();
        int i = 0;
        while (i < this.fChildren.size()) {
            Object curr = this.fChildren.get(i);
            if (curr instanceof PPListElementAttribute) {
                res.add(curr);
            }
            ++i;
        }
        return res.toArray(new PPListElementAttribute[res.size()]);
    }
}

