/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.edt.ide.core.internal.model.EGLElement;
import org.eclipse.edt.ide.core.internal.model.EGLModelResources;
import org.eclipse.edt.ide.core.internal.model.SourceRefElementInfo;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IBuffer;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IOpenable;
import org.eclipse.edt.ide.core.model.ISourceRange;
import org.eclipse.edt.ide.core.model.ISourceReference;

abstract class SourceRefElement
extends EGLElement
implements ISourceReference {
    protected SourceRefElement(int type, IEGLElement parent, String name) {
        super(type, parent, name);
    }

    public void copy(IEGLElement container, IEGLElement sibling, String rename, boolean force, IProgressMonitor monitor) throws EGLModelException {
        if (container == null) {
            throw new IllegalArgumentException(EGLModelResources.operationNullContainer);
        }
        IEGLElement[] elements = new IEGLElement[]{this};
        IEGLElement[] containers = new IEGLElement[]{container};
        IEGLElement[] siblings = null;
        if (sibling != null) {
            siblings = new IEGLElement[]{sibling};
        }
        String[] renamings = null;
        if (rename != null) {
            renamings = new String[]{rename};
        }
        this.getEGLModel().copy(elements, containers, siblings, renamings, force, monitor);
    }

    public void delete(boolean force, IProgressMonitor monitor) throws EGLModelException {
        IEGLElement[] elements = new IEGLElement[]{this};
        this.getEGLModel().delete(elements, force, monitor);
    }

    @Override
    public IEGLFile getEGLFile() {
        return ((EGLElement)this.getParent()).getEGLFile();
    }

    @Override
    public IResource getCorrespondingResource() throws EGLModelException {
        if (!this.exists()) {
            throw this.newNotPresentException();
        }
        return null;
    }

    @Override
    public IOpenable getOpenableParent() {
        IEGLElement current = this.getParent();
        while (current != null) {
            if (current instanceof IOpenable) {
                return (IOpenable)((Object)current);
            }
            current = current.getParent();
        }
        return null;
    }

    @Override
    public IPath getPath() {
        return this.getParent().getPath();
    }

    @Override
    public IResource getResource() {
        return this.getParent().getResource();
    }

    @Override
    public String getSource() throws EGLModelException {
        IOpenable openable = this.getOpenableParent();
        IBuffer buffer = openable.getBuffer();
        if (buffer == null) {
            return null;
        }
        ISourceRange range = this.getSourceRange();
        int offset = range.getOffset();
        int length = range.getLength();
        if (offset == -1 || length == 0) {
            return null;
        }
        return buffer.getText(offset, length);
    }

    @Override
    public ISourceRange getSourceRange() throws EGLModelException {
        SourceRefElementInfo info = (SourceRefElementInfo)this.getElementInfo();
        return info.getSourceRange();
    }

    @Override
    public IResource getUnderlyingResource() throws EGLModelException {
        if (!this.exists()) {
            throw this.newNotPresentException();
        }
        return this.getParent().getUnderlyingResource();
    }

    public void move(IEGLElement container, IEGLElement sibling, String rename, boolean force, IProgressMonitor monitor) throws EGLModelException {
        if (container == null) {
            throw new IllegalArgumentException(EGLModelResources.operationNullContainer);
        }
        IEGLElement[] elements = new IEGLElement[]{this};
        IEGLElement[] containers = new IEGLElement[]{container};
        IEGLElement[] siblings = null;
        if (sibling != null) {
            siblings = new IEGLElement[]{sibling};
        }
        String[] renamings = null;
        if (rename != null) {
            renamings = new String[]{rename};
        }
        this.getEGLModel().move(elements, containers, siblings, renamings, force, monitor);
    }

    public void rename(String name, boolean force, IProgressMonitor monitor) throws EGLModelException {
        if (name == null) {
            throw new IllegalArgumentException(EGLModelResources.elementNullName);
        }
        IEGLElement[] elements = new IEGLElement[]{this};
        IEGLElement[] dests = new IEGLElement[]{this.getParent()};
        String[] renamings = new String[]{name};
        this.getEGLModel().rename(elements, dests, renamings, force, monitor);
    }

    @Override
    public IEGLElement rootedAt(IEGLProject project) {
        return null;
    }
}

