/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.lookup;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Set;
import org.eclipse.edt.ide.core.internal.lookup.IFileInfo;
import org.eclipse.edt.ide.core.internal.lookup.ISourceRange;
import org.eclipse.edt.ide.core.internal.lookup.SourceRange;

public class FileInfo
implements IFileInfo {
    private LinkedHashMap partEntries = new LinkedHashMap();
    private int[] lineOffsets = null;
    private String caseSensitivePackageName;

    public void addPart(String partName, int partType, int sourceStart, int sourceLength, String caseSensitivePartName, byte[] md5Key) {
        this.partEntries.put(partName, new FileInfoEntry(partType, new SourceRange(sourceStart, sourceLength), caseSensitivePartName, md5Key));
    }

    public void setLineOffsets(int[] offsets) {
        this.lineOffsets = offsets;
    }

    public void setCaseSensitivePackageName(String pkg) {
        this.caseSensitivePackageName = pkg;
    }

    @Override
    public String getCaseSensitivePackageName() {
        return this.caseSensitivePackageName;
    }

    @Override
    public ISourceRange getPartRange(String partName) {
        return ((FileInfoEntry)this.partEntries.get(partName)).getSourceRange();
    }

    @Override
    public int getPartType(String partName) {
        return ((FileInfoEntry)this.partEntries.get(partName)).getPartType();
    }

    @Override
    public String getCaseSensitivePartName(String partName) {
        return ((FileInfoEntry)this.partEntries.get(partName)).getCaseSensitivePartName();
    }

    @Override
    public byte[] getMD5Key(String partName) {
        return ((FileInfoEntry)this.partEntries.get(partName)).getMD5Key();
    }

    @Override
    public Set getPartNames() {
        return Collections.unmodifiableSet(this.partEntries.keySet());
    }

    @Override
    public int getLineNumberForOffset(int offset) {
        int index = Arrays.binarySearch(this.lineOffsets, offset);
        if (index >= 0) {
            return index;
        }
        return -index - 2;
    }

    @Override
    public int getNumberOfLines() {
        return this.lineOffsets.length;
    }

    @Override
    public int getOffsetForLine(int line) {
        return this.lineOffsets[line];
    }

    private class FileInfoEntry {
        private int partType;
        private String caseSensitivePartName;
        private ISourceRange sourceRange;
        private byte[] md5Key;

        public FileInfoEntry(int partType, ISourceRange sourceRange, String caseSensitivePartName, byte[] md5Key) {
            this.partType = partType;
            this.sourceRange = sourceRange;
            this.caseSensitivePartName = caseSensitivePartName;
            this.md5Key = md5Key;
        }

        public int getPartType() {
            return this.partType;
        }

        public ISourceRange getSourceRange() {
            return this.sourceRange;
        }

        public String getCaseSensitivePartName() {
            return this.caseSensitivePartName;
        }

        public byte[] getMD5Key() {
            return this.md5Key;
        }
    }
}

