/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core;

import java.io.PrintStream;
import java.util.logging.Level;
import org.eclipse.edt.ide.core.EDTCoreIDEPlugin;

public class Logger {
    private static java.util.logging.Logger msgLogger;
    private static boolean displayToConsole;

    static {
        displayToConsole = false;
    }

    private Logger() {
    }

    public static void log(Object source, String message) {
        Logger.doLog(source, message, null);
    }

    public static void log(Object source, String message, Throwable throwable) {
        Logger.doLog(source, message, throwable);
    }

    public static void log(Object source, Throwable throwable) {
        Logger.doLog(source, null, throwable);
    }

    public static void trace(Object source, String message) {
        Logger.doTrace(Level.FINE, source, message);
    }

    public static void traceFiner(Object source, String message) {
        Logger.doTrace(Level.FINER, source, message);
    }

    public static void traceFinest(Object source, String message) {
        Logger.doTrace(Level.FINEST, source, message);
    }

    private static void doLog(Object source, String message, Throwable throwable) {
        Level level = Logger.getLevelFor(throwable);
        message = Logger.getMessageFor(source, message);
        try {
            try {
                Logger.getLog().log(level, message, throwable);
            }
            catch (Exception exception) {
                if (displayToConsole) {
                    PrintStream out = Logger.getPrintStreamFor(level);
                    out.println(message);
                    if (throwable != null) {
                        throwable.printStackTrace(out);
                    }
                }
            }
        }
        finally {
            if (displayToConsole) {
                PrintStream out = Logger.getPrintStreamFor(level);
                out.println(message);
                if (throwable != null) {
                    throwable.printStackTrace(out);
                }
            }
        }
    }

    private static void doTrace(Level level, Object source, String message) {
        String bigMessage = String.valueOf(source.toString()) + ": " + " time: " + System.currentTimeMillis() + " " + Thread.currentThread().toString() + " " + message;
        try {
            try {
                Logger.getLog().log(level, bigMessage);
            }
            catch (Exception exception) {
                if (displayToConsole) {
                    System.out.println(Logger.getMessageFor(source, message));
                }
            }
        }
        finally {
            if (displayToConsole) {
                System.out.println(Logger.getMessageFor(source, message));
            }
        }
    }

    private static java.util.logging.Logger getLog() {
        if (msgLogger == null) {
            msgLogger = EDTCoreIDEPlugin.getPlugin().getLogger();
        }
        return msgLogger;
    }

    private static String getMessageFor(Object source, String message) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(source);
        if (message != null) {
            buffer.append(": ");
            buffer.append(message);
        }
        return buffer.toString();
    }

    private static PrintStream getPrintStreamFor(Level level) {
        if (level == Level.WARNING || level == Level.SEVERE) {
            return System.err;
        }
        return System.out;
    }

    private static Level getLevelFor(Throwable throwable) {
        return throwable == null ? Level.WARNING : Level.SEVERE;
    }
}

