/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.releng.p2.to.maven;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IVersionFormat;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.scada.releng.p2.to.maven.MavenMapping;
import org.eclipse.scada.releng.p2.to.maven.MavenReference;

public class DefaultMavenMapping
implements MavenMapping {
    private static boolean IGNORE_TYCHO = !Boolean.getBoolean("useTychoVersion");
    private final Properties properties;
    private final Set<String> defaultIgnores = new HashSet<String>();

    public DefaultMavenMapping(Properties properties) {
        this.properties = properties;
        this.defaultIgnores.add("a.jre.javase");
    }

    @Override
    public MavenReference makeReference(IInstallableUnit iu) throws Exception {
        if (this.defaultIgnores.contains(iu.getId())) {
            return null;
        }
        String value = this.properties.getProperty("mapping." + iu.getId());
        if (value != null) {
            if (value.isEmpty()) {
                return null;
            }
            return this.fromValue(iu, value);
        }
        value = this.properties.getProperty("external." + iu.getId());
        if (value != null) {
            if (value.isEmpty()) {
                return null;
            }
            return this.fromValue(iu, value);
        }
        MavenReference result = new MavenReference();
        result.setGroupId(this.makeGroupId(iu));
        result.setArtifactId(this.makeArtifactId(iu));
        result.setVersion(this.makeVersion(iu, true));
        result.setClassifier(this.makeClassifier(iu));
        return result;
    }

    private String makeClassifier(IInstallableUnit iu) {
        return iu.getProperty("maven-classifier");
    }

    private MavenReference fromValue(IInstallableUnit iu, String value) throws Exception {
        String[] toks = value.split("\\:");
        if (toks.length == 3) {
            String version = MessageFormat.format(toks[2], this.getSegments(iu.getVersion()));
            return new MavenReference(toks[0], toks[1], version);
        }
        if (toks.length == 2) {
            return new MavenReference(toks[0], toks[1], this.makeVersion(iu, false));
        }
        throw new IllegalArgumentException(String.format("Maven reference has invalid syntax: %s", value));
    }

    private Object[] getSegments(Version version) {
        Object[] result = new Object[version.getSegmentCount()];
        int i = 0;
        while (i < version.getSegmentCount()) {
            result[i] = version.getSegment(i);
            ++i;
        }
        return result;
    }

    private String getName(IInstallableUnit iu) {
        return iu.getId();
    }

    public String makeGroupId(IInstallableUnit iu) {
        String groupId = this.makeGroupIdFromTycho(iu);
        if (groupId != null) {
            return groupId;
        }
        return this.makeGroupIdFromIU(iu);
    }

    private String makeGroupIdFromTycho(IInstallableUnit iu) {
        return iu.getProperty("maven-groupId");
    }

    private String makeGroupIdFromIU(IInstallableUnit iu) {
        String name = this.getName(iu);
        String[] toks = name.split("\\.", 3);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < toks.length) {
            if (i > 0) {
                sb.append('.');
            }
            sb.append(toks[i]);
            ++i;
        }
        return sb.toString();
    }

    public String makeArtifactId(IInstallableUnit iu) {
        String name = iu.getProperty("maven-artifactId");
        if (name != null) {
            return name;
        }
        return this.getName(iu);
    }

    public String makeVersion(IInstallableUnit iu, boolean withQualifier) throws Exception {
        Version version;
        String tychoVersion = iu.getProperty("maven-version");
        if (!IGNORE_TYCHO && tychoVersion != null) {
            IVersionFormat format = Version.compile((String)"n[.n=0;[.n=0;[.n=0;]]][[-.]S='';]");
            version = format.parse(tychoVersion);
        } else {
            version = iu.getVersion();
        }
        if (withQualifier) {
            return this.toString(version);
        }
        return this.withoutQualifier(version);
    }

    protected String withoutQualifier(Version version) {
        if (version.getSegmentCount() >= 4) {
            return String.format("%s.%s.%s", version.getSegment(0), version.getSegment(1), version.getSegment(2));
        }
        return this.toString(version);
    }

    private String toString(Version version) {
        return version.getOriginal();
    }
}

