/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.dynapp;

import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.eclipse.ebpm.dynapp.ApplicationHandler;
import org.eclipse.ebpm.dynapp.FileWatcher;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicApplicationWatcherService {
    protected Logger logger = LoggerFactory.getLogger(DynamicApplicationWatcherService.class);
    protected File spagicApplicationsFile = null;
    protected Timer timer = null;
    protected ConcurrentHashMap<String, ApplicationHandler> applications = new ConcurrentHashMap();

    protected Map<String, ApplicationHandler> loadApplications(BundleContext context) {
        String spagicHome = System.getProperty("spagic.home");
        HashMap<String, ApplicationHandler> apps = new HashMap<String, ApplicationHandler>();
        try {
            try {
                SAXReader reader = new SAXReader();
                Document doc = reader.read(this.spagicApplicationsFile);
                Element rootAppEl = doc.getRootElement();
                List applicationsElements = rootAppEl.elements("spagic-application");
                for (Element appEl : applicationsElements) {
                    ApplicationHandler appHandler = new ApplicationHandler(context, spagicHome, appEl);
                    apps.put(appHandler.getApplicationId(), appHandler);
                }
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        catch (Throwable throwable) {}
        return apps;
    }

    protected void activate(ComponentContext componentContext) {
        this.logger.debug("DynamicApplicationWatcherService -> activate ");
        String spagicHome = System.getProperty("spagic.home");
        if (spagicHome == null) {
            this.logger.warn(" Spagic HOME NOT SETTED ");
            return;
        }
        final String spagicApplicationFileName = String.valueOf(spagicHome) + File.separator + "spagic-applications.xml";
        this.logger.debug("DynamicApplicationWatcherService ->  Spagic Applications File Name [" + spagicApplicationFileName + "]");
        this.spagicApplicationsFile = new File(spagicApplicationFileName);
        final BundleContext bundleContext = componentContext.getBundleContext();
        this.logger.debug("DynamicApplicationWatcherService ->  Initial Load of Spagic Applications from [" + spagicApplicationFileName + "]");
        Map<String, ApplicationHandler> newApps = this.loadApplications(bundleContext);
        for (String key : newApps.keySet()) {
            this.logger.debug("DynamicApplicationWatcherService ->  Initial Load :: Found Spagic Application [" + key + "]");
            this.applications.put(key, newApps.get(key));
            this.logger.debug("DynamicApplicationWatcherService ->   Initial Load :: Start Spagic Application [" + key + "]");
            this.applications.get(key).start();
            this.logger.debug("DynamicApplicationWatcherService ->  Initial Load :: Started Spagic Application [" + key + "]");
        }
        FileWatcher task = new FileWatcher(this.spagicApplicationsFile){

            @Override
            protected void onChange(File file) {
                DynamicApplicationWatcherService.this.logger.debug("DynamicApplicationWatcherService ->  Spagic App Thread [" + spagicApplicationFileName + "] Changed Reload Applications");
                Map<String, ApplicationHandler> newApps = DynamicApplicationWatcherService.this.loadApplications(bundleContext);
                DynamicApplicationWatcherService.this.logger.debug("DynamicApplicationWatcherService ->  Spagic App Thread [" + spagicApplicationFileName + "] Applications Reloaded");
                for (String key : DynamicApplicationWatcherService.this.applications.keySet()) {
                    if (newApps.containsKey(key)) continue;
                    DynamicApplicationWatcherService.this.logger.debug("DynamicApplicationWatcherService ->  Application [" + key + "] HAVE BEEN REMOVED from new list");
                    DynamicApplicationWatcherService.this.applications.get(key).stop();
                    DynamicApplicationWatcherService.this.applications.remove(key);
                }
                for (String key : newApps.keySet()) {
                    if (DynamicApplicationWatcherService.this.applications.containsKey(key)) continue;
                    DynamicApplicationWatcherService.this.logger.debug("DynamicApplicationWatcherService ->  Application [" + key + "] is NEW APPLICATION Initialize and start it ");
                    ApplicationHandler appH = newApps.get(key);
                    DynamicApplicationWatcherService.this.applications.put(key, appH);
                    appH.start();
                }
            }
        };
        this.logger.debug("DynamicApplicationWatcherService ->  Scheduling Thread For Polling Spagic-Applications");
        this.timer = new Timer();
        this.timer.schedule((TimerTask)task, new Date(), 5000L);
        this.logger.debug("DynamicApplicationWatcherService ->  Thread Scheduled");
    }

    protected void deactivate(ComponentContext componentContext) {
        this.timer.cancel();
        for (String key : this.applications.keySet()) {
            this.applications.get(key).stop();
        }
        this.applications.clear();
    }
}

