/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.osgi.services.discovery.local;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.ecf.osgi.services.discovery.local.BundleTrackerImpl;
import org.eclipse.ecf.osgi.services.discovery.local.DSTTracker;
import org.eclipse.ecf.osgi.services.discovery.local.DiscoveredServiceNotificationImpl;
import org.eclipse.ecf.osgi.services.discovery.local.ServiceEndpointDescriptionImpl;
import org.eclipse.ecf.osgi.services.discovery.local.ServicePublicationTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.discovery.DiscoveredServiceNotification;
import org.osgi.service.discovery.DiscoveredServiceTracker;
import org.osgi.service.discovery.Discovery;
import org.osgi.service.discovery.ServiceEndpointDescription;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class FileBasedDiscoveryImpl
implements Discovery {
    public static final String PROP_KEY_PUBLISH_STRATEGY = "osgi.discovery.strategy.publication";
    public static final String PROP_VAL_PUBLISH_STRATEGY_PUSH = "push";
    public static final String PROP_VAL_PUBLISH_STRATEGY_PULL = "pull";
    private static BundleContext context;
    private static LogService logService;
    private static Map inMemoryCache;
    private ServiceTracker spTracker = null;
    private DSTTracker discoTrackerCustomizer = null;
    private ServiceTracker discoTracker = null;
    private BundleTracker bt = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        inMemoryCache = Collections.synchronizedMap(new HashMap());
    }

    public FileBasedDiscoveryImpl(BundleContext bc, LogService logger) {
        logService = logger;
        context = bc;
    }

    public void init() {
        FileBasedDiscoveryImpl.log(4, "init");
        this.discoTrackerCustomizer = new DSTTracker(context);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.discovery.DiscoveredServiceTracker");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.discoTracker = new ServiceTracker(context, clazz.getName(), (ServiceTrackerCustomizer)this.discoTrackerCustomizer);
        this.discoTracker.open();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.osgi.service.discovery.ServicePublication");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.spTracker = new ServiceTracker(context, clazz2.getName(), (ServiceTrackerCustomizer)new ServicePublicationTracker(context, this));
        this.spTracker.open();
        this.bt = new BundleTracker(context, 36, (BundleTrackerCustomizer)new BundleTrackerImpl(this));
        this.bt.open();
    }

    public void destroy() {
        FileBasedDiscoveryImpl.log(4, "destroy");
        this.bt.close();
        this.discoTracker.close();
        this.spTracker.close();
    }

    protected ServiceEndpointDescription publishService(Collection javaInterfaces, Collection javaInterfacesAndVersions, Collection javaInterfacesAndEndpointInterfaces, Map properties, String strategy, String endpointID) {
        ServiceEndpointDescriptionImpl svcDescr = new ServiceEndpointDescriptionImpl(javaInterfaces, javaInterfacesAndVersions, javaInterfacesAndEndpointInterfaces, properties, endpointID);
        this.storeAndNotify(svcDescr);
        return svcDescr;
    }

    private void storeAndNotify(ServiceEndpointDescription svcDescr) {
        inMemoryCache.put(svcDescr.getEndpointID(), svcDescr);
        this.notifyListenersOnNewServiceDescription(svcDescr);
    }

    protected void publishService(ServiceEndpointDescription svcDescr) {
        this.storeAndNotify(svcDescr);
    }

    protected void unpublishService(ServiceEndpointDescription serviceDescription) {
        this.validateServiceDescription(serviceDescription);
        FileBasedDiscoveryImpl.log(4, "unpublish service " + serviceDescription.toString());
        inMemoryCache.remove(serviceDescription.getEndpointID());
        this.notifyListenersOnRemovedServiceDescription(serviceDescription);
    }

    protected static synchronized void log(int logLevel, String msg) {
        if (logService != null) {
            logService.log(logLevel, msg);
        }
    }

    protected static synchronized void log(int logLevel, String msg, Exception e) {
        if (logService != null) {
            logService.log(logLevel, msg, (Throwable)e);
        }
    }

    public static void setLogService(LogService logger) {
        logService = logger;
    }

    protected void validateServiceDescription(ServiceEndpointDescription serviceDescription) {
        if (serviceDescription == null) {
            throw new IllegalArgumentException("serviceDescription must not be null.");
        }
        if (serviceDescription.getProvidedInterfaces() == null) {
            throw new IllegalArgumentException("Given set of Java interfaces must not be null");
        }
        String ifName = (String)serviceDescription.getProvidedInterfaces().iterator().next();
        if (serviceDescription.getProvidedInterfaces() == null || serviceDescription.getProvidedInterfaces().size() <= 0 || ifName == null || ifName.length() <= 0) {
            throw new IllegalArgumentException("serviceDescription must contain at least one service interface name.");
        }
    }

    protected Map getRegisteredServiceTracker() {
        if (this.discoTrackerCustomizer == null) {
            return new HashMap();
        }
        return new HashMap(this.discoTrackerCustomizer.getDsTrackers());
    }

    public static void notifyOnAvailableSEDs(DiscoveredServiceTracker tracker, Map matchingCriteria) {
        ArrayList cachedServices = new ArrayList(inMemoryCache.values());
        if (cachedServices != null) {
            ArrayList matchingInterfaces = new ArrayList();
            ArrayList matchingFilters = new ArrayList();
            Iterator it = cachedServices.iterator();
            while (it.hasNext()) {
                ServiceEndpointDescription svcDescr = (ServiceEndpointDescription)it.next();
                matchingInterfaces.clear();
                matchingFilters.clear();
                if (!FileBasedDiscoveryImpl.isTrackerInterestedInSED(svcDescr, matchingCriteria, matchingInterfaces, matchingFilters)) continue;
                tracker.serviceChanged((DiscoveredServiceNotification)new DiscoveredServiceNotificationImpl(svcDescr, 1, matchingInterfaces, matchingFilters));
            }
        }
    }

    protected void notifyListenersOnNewServiceDescription(ServiceEndpointDescription svcDescr) {
        ArrayList matchingInterfaces = new ArrayList();
        ArrayList matchingFilters = new ArrayList();
        Map discoveredSTs = this.getRegisteredServiceTracker();
        Iterator it = discoveredSTs.keySet().iterator();
        while (it.hasNext()) {
            DiscoveredServiceTracker st = (DiscoveredServiceTracker)it.next();
            Map trackerProps = (Map)discoveredSTs.get(st);
            matchingInterfaces.clear();
            matchingFilters.clear();
            if (!FileBasedDiscoveryImpl.isTrackerInterestedInSED(svcDescr, trackerProps, matchingInterfaces, matchingFilters)) continue;
            try {
                st.serviceChanged((DiscoveredServiceNotification)new DiscoveredServiceNotificationImpl(svcDescr, 1, matchingInterfaces, matchingFilters));
            }
            catch (Exception e) {
                FileBasedDiscoveryImpl.log(1, "Exceptions where thrown while notifying about a new remote service.", e);
            }
        }
    }

    protected void notifyListenersOnRemovedServiceDescription(ServiceEndpointDescription svcDescr) {
        ArrayList matchingInterfaces = new ArrayList();
        ArrayList matchingFilters = new ArrayList();
        Map discoveredSTs = this.getRegisteredServiceTracker();
        Iterator it = discoveredSTs.keySet().iterator();
        while (it.hasNext()) {
            DiscoveredServiceTracker st = (DiscoveredServiceTracker)it.next();
            Map trackerProps = (Map)discoveredSTs.get(st);
            matchingInterfaces.clear();
            matchingFilters.clear();
            if (!FileBasedDiscoveryImpl.isTrackerInterestedInSED(svcDescr, trackerProps, matchingInterfaces, matchingFilters)) continue;
            try {
                st.serviceChanged((DiscoveredServiceNotification)new DiscoveredServiceNotificationImpl(svcDescr, 4, matchingInterfaces, matchingFilters));
            }
            catch (Exception e) {
                FileBasedDiscoveryImpl.log(1, "Exceptions where thrown while notifying about removal of a remote service.", e);
            }
        }
    }

    protected void notifyListenersOnModifiedServiceDescription(ServiceEndpointDescription svcDescr) {
        ArrayList matchingInterfaces = new ArrayList();
        ArrayList matchingFilters = new ArrayList();
        Map discoveredSTs = this.getRegisteredServiceTracker();
        Iterator it = discoveredSTs.keySet().iterator();
        while (it.hasNext()) {
            DiscoveredServiceTracker st = (DiscoveredServiceTracker)it.next();
            Map trackerProps = (Map)discoveredSTs.get(st);
            matchingInterfaces.clear();
            matchingFilters.clear();
            if (!FileBasedDiscoveryImpl.isTrackerInterestedInSED(svcDescr, trackerProps, matchingInterfaces, matchingFilters)) continue;
            try {
                st.serviceChanged((DiscoveredServiceNotification)new DiscoveredServiceNotificationImpl(svcDescr, 2, matchingInterfaces, matchingFilters));
            }
            catch (Exception e) {
                FileBasedDiscoveryImpl.log(1, "Exceptions where thrown while notifying about modification of a remote service.", e);
            }
        }
    }

    public static boolean isTrackerInterestedInSED(ServiceEndpointDescription svcDescr, Map trackerProperties, Collection matchingInterfaces, Collection matchingFilters) {
        Collection interfaceCriteria = (Collection)trackerProperties.get("osgi.remote.discovery.interest.interfaces");
        Collection filter = (Collection)trackerProperties.get("osgi.remote.discovery.interest.filters");
        boolean notify = false;
        if (interfaceCriteria == null && filter == null) {
            notify = true;
        } else {
            if (interfaceCriteria != null && !interfaceCriteria.isEmpty()) {
                Collection svcInterfaces = svcDescr.getProvidedInterfaces();
                if (svcInterfaces == null) {
                    throw new RuntimeException("no interfaces provided");
                }
                HashSet intersectionResult = new HashSet(interfaceCriteria);
                intersectionResult.retainAll(svcInterfaces);
                if (intersectionResult.size() > 0) {
                    notify = true;
                    if (matchingInterfaces != null) {
                        matchingInterfaces.addAll(intersectionResult);
                    }
                }
            }
            if (filter != null && !filter.isEmpty()) {
                Iterator it = filter.iterator();
                while (it.hasNext()) {
                    String currentFilter = (String)it.next();
                    try {
                        Filter f = context.createFilter(currentFilter);
                        if (!f.match(new Hashtable(svcDescr.getProperties()))) continue;
                        notify = true;
                        if (matchingFilters == null) continue;
                        matchingFilters.add(currentFilter);
                    }
                    catch (InvalidSyntaxException e) {
                        String errMsg = "A filter provided by a DiscoveredServiceTracker is invalid.";
                        errMsg = String.valueOf(errMsg) + " Filter = " + currentFilter;
                        errMsg = String.valueOf(errMsg) + "; DiscoveredServiceTracker service.id = " + trackerProperties.get("service.id");
                        throw new RuntimeException(e.getMessage());
                    }
                    catch (IllegalStateException isex) {
                        isex.printStackTrace();
                    }
                }
            }
        }
        return notify;
    }

    public Map getCachedServices() {
        return new HashMap(inMemoryCache);
    }
}

