/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.osgi.services.distribution;

import java.util.ArrayList;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.IContainerManager;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.internal.osgi.services.distribution.Activator;
import org.eclipse.ecf.internal.osgi.services.distribution.LogUtility;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainer;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainerAdapter;
import org.eclipse.ecf.remoteservice.RemoteServiceContainer;

public abstract class AbstractContainerFinder {
    public static final IRemoteServiceContainer[] EMPTY_REMOTE_SERVICE_CONTAINER_ARRAY = new IRemoteServiceContainer[0];
    static /* synthetic */ Class class$0;

    protected IContainer[] getAllContainers() {
        Activator activator = Activator.getDefault();
        if (activator == null) {
            return null;
        }
        IContainerManager containerManager = activator.getContainerManager();
        if (containerManager == null) {
            return null;
        }
        return containerManager.getAllContainers();
    }

    protected IRemoteServiceContainerAdapter hasRemoteServiceContainerAdapter(IContainer container) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.remoteservice.IRemoteServiceContainerAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IRemoteServiceContainerAdapter)container.getAdapter((Class)clazz);
    }

    protected IRemoteServiceContainer[] getRemoteServiceContainers(IContainer[] containers) {
        ArrayList<RemoteServiceContainer> results = new ArrayList<RemoteServiceContainer>();
        int i = 0;
        while (i < containers.length) {
            IRemoteServiceContainerAdapter adapter = this.hasRemoteServiceContainerAdapter(containers[i]);
            if (adapter != null) {
                results.add(new RemoteServiceContainer(containers[i], adapter));
            }
            ++i;
        }
        return results.toArray(new IRemoteServiceContainer[0]);
    }

    protected boolean includeContainerWithConnectNamespace(IContainer container, String connectNamespaceName) {
        Namespace namespace;
        return connectNamespaceName != null && (namespace = container.getConnectNamespace()) != null && namespace.getName().equals(connectNamespaceName);
    }

    protected void connectContainer(IContainer container, ID connectTargetID, IConnectContext connectContext) throws ContainerConnectException {
        this.trace("connectContainer", "Connecting container=" + container.getID() + " to connectTargetID=" + connectTargetID);
        container.connect(connectTargetID, connectContext);
    }

    protected void trace(String methodName, String message) {
        LogUtility.trace(methodName, "org.eclipse.ecf.osgi.services.distribution/debug/containerfinder", this.getClass(), message);
    }

    protected void traceException(String methodName, String message, Throwable t) {
        LogUtility.traceException(methodName, "org.eclipse.ecf.osgi.services.distribution/debug/exceptions/catching", this.getClass(), message, t);
    }

    protected void logError(String methodName, String message, Throwable t) {
        LogUtility.logError(methodName, "org.eclipse.ecf.osgi.services.distribution/debug/containerfinder", this.getClass(), message, t);
    }

    protected void logError(String methodName, String message) {
        LogUtility.logError(methodName, "org.eclipse.ecf.osgi.services.distribution/debug/containerfinder", this.getClass(), message);
    }

    protected void logWarning(String methodName, String message) {
        LogUtility.logWarning(methodName, "org.eclipse.ecf.osgi.services.distribution/debug/containerfinder", this.getClass(), message);
    }
}

