/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.connectors.jdbc;

import java.lang.reflect.Field;
import java.sql.Types;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.ebpm.connectors.jdbc.PollingParameters;
import org.eclipse.ebpm.connectors.jdbc.PollingTask;
import org.eclipse.ebpm.connectors.jdbc.StatementElement;
import org.eclipse.ebpm.core.AbstractSpagicConnector;
import org.eclipse.ebpm.datasource.IDataSourceManager;
import org.eclipse.ebpm.messaging.api.Exchange;
import org.eclipse.ebpm.messaging.api.Message;
import org.eclipse.ebpm.util.properties.PropertyConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCPoller
extends AbstractSpagicConnector {
    public static final String PROPERTY_MAINQUERYNAME = "mainQueryName";
    public static final String PROPERTY_MAINQUERYSQL = "mainQuerySQL";
    public static final String PROPERTY_KEYCOLUMN = "keyColumn";
    public static final String PROPERTY_INITIALKEYVALUE = "initialKeyValue";
    public static final String PROPERTY_COLUMNNAMEASATTRIBUTE = "columnNameAsAttribute";
    public static final String PROPERTY_ROWNAMEASATTRIBUTE = "rowNameAsAttribute";
    public static final String PROPERTY_VALUEASATTRIBUTE = "valueAsAttribute";
    public static final String PROPERTY_COMMPOINTID = "commPointID";
    public static final String PROPERTY_DATABASETYPE = "databaseType";
    public static final String PROPERTY_DATASOURCENAME = "datasourceName";
    public static final String PROPERTY_PERIOD = "period";
    public static final String PROPERTY_ROWSFOREACHMESSAGE = "rowsForEachMessage";
    public static final String PROPERTY_MAXMESSAGESPERUNIT = "maxMessagesPerUnit";
    private static String MS_SQL_SERVER = "MS_SQL".intern();
    private static String MySQL_SERVER = "MySQL".intern();
    private static String Oracle_SERVER = "Oracle".intern();
    private static String Sybase_SERVER = "Sysbase".intern();
    private static String DB2_SERVER = "DB2".intern();
    private static String Postgre_SQL_SERVER = "Postgres".intern();
    private static String H2_SERVER = "H2".intern();
    private static String JDBC_SERVER = "JDBC_Generic".intern();
    private static String[] supportedDatabases = new String[]{MS_SQL_SERVER, MySQL_SERVER, Oracle_SERVER, Sybase_SERVER, DB2_SERVER, Postgre_SQL_SERVER, H2_SERVER, JDBC_SERVER};
    protected Logger log = LoggerFactory.getLogger(JDBCPoller.class);
    private PollingParameters pollingParams;
    private boolean active;
    private long period;
    private Timer timerService;
    protected final AtomicReference<IDataSourceManager> datasourceManager = new AtomicReference<Object>(null);
    private ResourceBundle statementsBundle;
    static Map<Integer, String> jdbcTypesNames = null;

    public static String getJdbcTypeName(int jdbcType) {
        return jdbcTypesNames.get(new Integer(jdbcType));
    }

    public void init() {
        this.pollingParams = new PollingParameters();
        StatementElement rootStatement = new StatementElement(this.propertyConfigurator.getString(PROPERTY_MAINQUERYNAME), this.propertyConfigurator.getString(PROPERTY_MAINQUERYSQL));
        this.setRootStatement(rootStatement);
        this.setKeyColumn(this.propertyConfigurator.getString(PROPERTY_KEYCOLUMN));
        this.setInitialKeyValue(this.propertyConfigurator.getString(PROPERTY_INITIALKEYVALUE));
        this.setColumnNameAsAttribute(this.propertyConfigurator.getBoolean(PROPERTY_COLUMNNAMEASATTRIBUTE, Boolean.FALSE));
        this.setRowNameAsAttribute(this.propertyConfigurator.getBoolean(PROPERTY_ROWNAMEASATTRIBUTE, Boolean.TRUE));
        this.setValueAsAttribute(this.propertyConfigurator.getBoolean(PROPERTY_VALUEASATTRIBUTE, Boolean.FALSE));
        this.setRowsInMessage(this.propertyConfigurator.getInteger(PROPERTY_ROWSFOREACHMESSAGE, Integer.valueOf(0)));
        this.setCommPointID(this.propertyConfigurator.getString(PROPERTY_COMMPOINTID));
        this.setDatabaseType(this.propertyConfigurator.getString(PROPERTY_DATABASETYPE));
        this.setDatasourceName(this.propertyConfigurator.getString(PROPERTY_DATASOURCENAME));
        this.period = this.propertyConfigurator.getInteger(PROPERTY_PERIOD, Integer.valueOf(5000)).intValue();
        this.setMaxMessagesPerUnit(this.propertyConfigurator.getInteger(PROPERTY_MAXMESSAGESPERUNIT, Integer.valueOf(0)));
        this.statementsBundle = ResourceBundle.getBundle("statements");
        this.setKeyCreationStatement(this.statementsBundle.getString(String.valueOf(this.getDatabaseType()) + "_KEY_CREATE"));
        Map subQueriesMap = this.propertyConfigurator.getXMapProperty("subQueries");
        StatementElement[] subQueries = new StatementElement[subQueriesMap.size()];
        int subQueryCounter = 0;
        for (String key : subQueriesMap.keySet()) {
            Properties value = (Properties)subQueriesMap.get(key);
            subQueries[subQueryCounter] = new StatementElement(key, new PropertyConfigurator(value).getString("Sql"));
            ++subQueryCounter;
        }
        rootStatement.setSubQueries(subQueries);
        if (jdbcTypesNames == null) {
            jdbcTypesNames = new HashMap<Integer, String>();
            Field[] fields = Types.class.getFields();
            int i = 0;
            while (i < fields.length) {
                try {
                    String name = fields[i].getName();
                    Integer value = (Integer)fields[i].get(null);
                    jdbcTypesNames.put(value, name);
                }
                catch (IllegalAccessException illegalAccessException) {}
                ++i;
            }
        }
    }

    public void start() throws Exception {
        super.start();
        this.validate();
        this.timerService = new Timer();
        this.timerService.schedule((TimerTask)new PollingTask(this.pollingParams, this, this.target), new Date(), this.period);
        this.active = true;
    }

    public void stop() throws Exception {
        super.stop();
        this.active = false;
        this.timerService.cancel();
        this.timerService = null;
    }

    public void validate() {
        boolean databaseSupported = false;
        int i = 0;
        while (i < supportedDatabases.length) {
            if (supportedDatabases[i].equals(this.pollingParams.databaseType)) {
                databaseSupported = true;
                break;
            }
            ++i;
        }
        if (!databaseSupported) {
            throw new RuntimeException("Database not supported");
        }
        if (this.pollingParams.keyDatasourceName == null) {
            this.log.debug("Datasource not provided, using: " + this.pollingParams.datasourceName);
            this.pollingParams.keyDatasourceName = this.pollingParams.datasourceName;
        }
    }

    public void setColumnNameAsAttribute(boolean columnNameAsAttribute) {
        this.pollingParams.columnNameAsAttribute = columnNameAsAttribute;
    }

    public void setDatabaseType(String databaseType) {
        this.pollingParams.databaseType = databaseType;
    }

    public String getDatabaseType() {
        return this.pollingParams.databaseType;
    }

    public void setInitialKeyValue(String initialKeyValue) {
        this.pollingParams.initialKeyValue = initialKeyValue;
    }

    public void setKeyColumn(String keyColumn) {
        this.pollingParams.keyColumn = keyColumn;
    }

    public void setRowNameAsAttribute(boolean rowNameAsAttribute) {
        this.pollingParams.rowNameAsAttribute = rowNameAsAttribute;
    }

    public void setRowsInMessage(int rowsInMessage) {
        this.pollingParams.rowsInMessage = rowsInMessage;
    }

    public void setValueAsAttribute(boolean valueAsAttribute) {
        this.pollingParams.valueAsAttribute = valueAsAttribute;
    }

    public void setCommPointID(String commPointID) {
        this.pollingParams.commPointID = commPointID;
    }

    public void setRootStatement(StatementElement rootStatement) {
        this.pollingParams.rootStatement = rootStatement;
    }

    public String getDatasourceName() {
        return this.pollingParams.datasourceName;
    }

    public void setDatasourceName(String datasourceName) {
        this.pollingParams.datasourceName = datasourceName;
    }

    public void setMaxMessagesPerUnit(int maxMessagesPerUnit) {
        this.pollingParams.maxMessagesPerUnit = maxMessagesPerUnit;
    }

    public void setKeyCreationStatement(String keyCreationStatement) {
        this.pollingParams.keyCreationStatement = keyCreationStatement;
    }

    public IDataSourceManager getDataSourceManager() {
        return this.datasourceManager.get();
    }

    public void setDataSourceManager(IDataSourceManager dsm) {
        this.datasourceManager.set(dsm);
    }

    public void unsetDataSourceManager(IDataSourceManager dsManager) {
        this.datasourceManager.compareAndSet(dsManager, null);
    }

    protected void sendMessage(StringBuffer messageStringBuffer) throws Exception {
        this.log.debug("Sending message: " + messageStringBuffer);
        messageStringBuffer.insert(0, "<message>");
        messageStringBuffer.append("</message>");
        Exchange exchange = this.createInOnlyExchange();
        Message inMessage = exchange.getIn(true);
        inMessage.setBody(messageStringBuffer.toString());
        this.send(exchange);
    }

    public void process(Exchange exchange) {
        String exchangeId = exchange.getId();
        this.log.debug("Received acknowledge for exchange: " + exchangeId);
    }
}

